/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.point;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.b3log.latke.ioc.annotated.Annotated;
import org.b3log.latke.ioc.bean.Bean;
import org.b3log.latke.ioc.point.InjectionPoint;
import org.b3log.latke.ioc.util.Beans;

public abstract class AbstractInjectionPoint
implements InjectionPoint {
    private Annotated annotated;
    private Bean<?> ownerBean;

    public AbstractInjectionPoint(Bean<?> ownerBean, Annotated annotated) {
        this.ownerBean = ownerBean;
        this.annotated = annotated;
    }

    @Override
    public Type getType() {
        Type baseType = this.annotated.getBaseType();
        if (baseType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)baseType;
            return parameterizedType.getActualTypeArguments()[0];
        }
        return baseType;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        Set<Annotation> annotations = this.annotated.getAnnotations();
        HashSet ret = Beans.selectQualifiers(annotations);
        return ret == null ? new HashSet() : ret;
    }

    @Override
    public Bean<?> getBean() {
        return this.ownerBean;
    }

    @Override
    public Annotated getAnnotated() {
        return this.annotated;
    }

    @Override
    public boolean isDelegate() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isTransient() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

