/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.bean;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.b3log.latke.intercept.annotation.AfterMethod;
import org.b3log.latke.intercept.annotation.BeforeMethod;
import org.b3log.latke.ioc.bean.Interceptor;

public final class InterceptorHolder {
    private static final Map<String, Set<Interceptor>> BEFORE_METHOD_HOLDER = new HashMap<String, Set<Interceptor>>();
    private static final Map<String, Set<Interceptor>> AFTER_METHOD_HOLDER = new HashMap<String, Set<Interceptor>>();

    private InterceptorHolder() {
    }

    public static void addInterceptor(Interceptor interceptor, Class<? extends Annotation> interceptAnnClass) {
        if (BeforeMethod.class.equals(interceptAnnClass)) {
            String invokingMethodName = interceptor.getInvokingMethodName();
            Set<Interceptor> interceptors = BEFORE_METHOD_HOLDER.get(invokingMethodName);
            if (null == interceptors) {
                interceptors = new HashSet<Interceptor>();
                BEFORE_METHOD_HOLDER.put(invokingMethodName, interceptors);
            }
            interceptors.add(interceptor);
        } else if (AfterMethod.class.equals(interceptAnnClass)) {
            String invokingMethodName = interceptor.getInvokingMethodName();
            Set<Interceptor> interceptors = AFTER_METHOD_HOLDER.get(invokingMethodName);
            if (null == interceptors) {
                interceptors = new HashSet<Interceptor>();
                AFTER_METHOD_HOLDER.put(invokingMethodName, interceptors);
            }
            interceptors.add(interceptor);
        }
    }

    static Set<Interceptor> getInterceptors(String invokingMethodName, Class<? extends Annotation> interceptAnnClass) {
        if (BeforeMethod.class.equals(interceptAnnClass)) {
            Set<Interceptor> ret = BEFORE_METHOD_HOLDER.get(invokingMethodName);
            if (null == ret) {
                return Collections.emptySet();
            }
            return ret;
        }
        if (AfterMethod.class.equals(interceptAnnClass)) {
            Set<Interceptor> ret = AFTER_METHOD_HOLDER.get(invokingMethodName);
            if (null == ret) {
                return Collections.emptySet();
            }
            return ret;
        }
        return Collections.emptySet();
    }
}

