/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.b3log.latke.ioc.BeanManager;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.annotated.AnnotatedConstructor;
import org.b3log.latke.ioc.annotated.AnnotatedField;
import org.b3log.latke.ioc.annotated.AnnotatedMethod;
import org.b3log.latke.ioc.annotated.AnnotatedParameter;
import org.b3log.latke.ioc.annotated.AnnotatedType;
import org.b3log.latke.ioc.annotated.AnnotatedTypeImpl;
import org.b3log.latke.ioc.bean.JavassistMethodHandler;
import org.b3log.latke.ioc.bean.LatkeBean;
import org.b3log.latke.ioc.config.Configurator;
import org.b3log.latke.ioc.context.CreationalContext;
import org.b3log.latke.ioc.inject.Inject;
import org.b3log.latke.ioc.inject.Named;
import org.b3log.latke.ioc.inject.Provider;
import org.b3log.latke.ioc.literal.NamedLiteral;
import org.b3log.latke.ioc.point.FieldInjectionPoint;
import org.b3log.latke.ioc.point.InjectionPoint;
import org.b3log.latke.ioc.point.ParameterInjectionPoint;
import org.b3log.latke.ioc.provider.FieldProvider;
import org.b3log.latke.ioc.provider.ParameterProvider;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.util.Reflections;

public class BeanImpl<T>
implements LatkeBean<T> {
    private static final Logger LOGGER = Logger.getLogger(BeanImpl.class);
    private final Set<Class<? extends Annotation>> stereotypes;
    private LatkeBeanManager beanManager;
    private Configurator configurator;
    private String name;
    private Class<? extends Annotation> scope;
    private Set<Annotation> qualifiers;
    private Class<T> beanClass;
    private Class<T> proxyClass;
    private JavassistMethodHandler javassistMethodHandler;
    private Set<Type> types;
    private AnnotatedType<T> annotatedType;
    private Set<FieldInjectionPoint> fieldInjectionPoints;
    private Map<AnnotatedConstructor<T>, List<ParameterInjectionPoint>> constructorParameterInjectionPoints;
    private Map<AnnotatedMethod<?>, List<ParameterInjectionPoint>> methodParameterInjectionPoints;
    private List<ParameterProvider<?>> constructorParameterProviders;
    private Set<FieldProvider<?>> fieldProviders;
    private Map<AnnotatedMethod<?>, List<ParameterProvider<?>>> methodParameterProviders;

    public BeanImpl(LatkeBeanManager beanManager, String name, Class<? extends Annotation> scope, Set<Annotation> qualifiers, Class<T> beanClass, Set<Type> types, Set<Class<? extends Annotation>> stereotypes) {
        this.beanManager = beanManager;
        this.name = name;
        this.scope = scope;
        this.qualifiers = qualifiers;
        this.beanClass = beanClass;
        this.types = types;
        this.stereotypes = stereotypes;
        this.configurator = beanManager.getConfigurator();
        this.javassistMethodHandler = new JavassistMethodHandler(beanManager);
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(beanClass);
        proxyFactory.setFilter(this.javassistMethodHandler.getMethodFilter());
        this.proxyClass = proxyFactory.createClass();
        this.annotatedType = new AnnotatedTypeImpl<T>(beanClass);
        this.constructorParameterInjectionPoints = new HashMap<AnnotatedConstructor<T>, List<ParameterInjectionPoint>>();
        this.constructorParameterProviders = new ArrayList();
        this.methodParameterInjectionPoints = new HashMap();
        this.methodParameterProviders = new HashMap();
        this.fieldInjectionPoints = new HashSet<FieldInjectionPoint>();
        this.fieldProviders = new HashSet();
        this.initFieldInjectionPoints();
        this.initConstructorInjectionPoints();
        this.initMethodInjectionPoints();
    }

    private void resolveDependencies(Object reference) throws Exception {
        Class<?> superclass = reference.getClass().getSuperclass().getSuperclass();
        this.resolveSuperclassFieldDependencies(reference, superclass);
        this.resolveSuperclassMethodDependencies(reference, superclass);
        this.resolveCurrentclassFieldDependencies(reference);
        this.resolveCurrentclassMethodDependencies(reference);
    }

    private T instantiateReference() throws Exception {
        T ret;
        if (this.constructorParameterInjectionPoints.size() == 1) {
            AnnotatedConstructor<T> annotatedConstructor = this.constructorParameterInjectionPoints.keySet().iterator().next();
            List<ParameterInjectionPoint> paraInjectionPoints = this.constructorParameterInjectionPoints.get(annotatedConstructor);
            Object[] args = new Object[paraInjectionPoints.size()];
            int i = 0;
            for (ParameterInjectionPoint paraInjectionPoint : paraInjectionPoints) {
                ParameterProvider<?> arg = this.beanManager.getInjectableReference(paraInjectionPoint, null);
                if (arg == null) {
                    for (ParameterProvider<?> provider : this.constructorParameterProviders) {
                        if (!provider.getAnnotated().equals(paraInjectionPoint.getAnnotated())) continue;
                        arg = provider;
                        break;
                    }
                }
                args[i++] = arg;
            }
            Member oriBeanConstructor = annotatedConstructor.getJavaMember();
            Constructor<T> constructor = this.proxyClass.getConstructor(((Constructor)oriBeanConstructor).getParameterTypes());
            ret = constructor.newInstance(args);
        } else {
            ret = this.proxyClass.newInstance();
        }
        ((ProxyObject)ret).setHandler((MethodHandler)this.javassistMethodHandler);
        LOGGER.log(Level.TRACE, "Uses Javassist method handler for bean[class={0}]", this.beanClass.getName());
        return ret;
    }

    private void resolveCurrentclassFieldDependencies(Object reference) {
        for (FieldInjectionPoint injectionPoint : this.fieldInjectionPoints) {
            FieldProvider<?> injection = this.beanManager.getInjectableReference(injectionPoint, null);
            if (injection == null) {
                for (FieldProvider<?> provider : this.fieldProviders) {
                    if (!provider.getAnnotated().equals(injectionPoint.getAnnotated())) continue;
                    injection = provider;
                    break;
                }
            }
            Field field = injectionPoint.getAnnotated().getJavaMember();
            try {
                Field declaredField = this.proxyClass.getDeclaredField(field.getName());
                if (!declaredField.isAnnotationPresent(Inject.class)) continue;
                try {
                    declaredField.set(reference, injection);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (NoSuchFieldException ex) {
                try {
                    field.set(reference, injection);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void resolveCurrentclassMethodDependencies(Object reference) {
        for (Map.Entry<AnnotatedMethod<?>, List<ParameterInjectionPoint>> methodParameterInjectionPoint : this.methodParameterInjectionPoints.entrySet()) {
            List<ParameterInjectionPoint> paraSet = methodParameterInjectionPoint.getValue();
            Object[] args = new Object[paraSet.size()];
            int i = 0;
            for (ParameterInjectionPoint paraInjectionPoint : paraSet) {
                ParameterProvider<?> arg = this.beanManager.getInjectableReference(paraInjectionPoint, null);
                if (arg == null) {
                    for (ParameterProvider<?> provider : this.methodParameterProviders.get(methodParameterInjectionPoint.getKey())) {
                        if (!provider.getAnnotated().equals(paraInjectionPoint.getAnnotated())) continue;
                        arg = provider;
                        break;
                    }
                }
                args[i++] = arg;
            }
            AnnotatedMethod<?> annotatedMethod = methodParameterInjectionPoint.getKey();
            Method method = annotatedMethod.getJavaMember();
            try {
                Method declaredMethod = this.proxyClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                try {
                    declaredMethod.setAccessible(true);
                    declaredMethod.invoke(reference, args);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (NoSuchMethodException ex) {
                try {
                    method.setAccessible(true);
                    method.invoke(reference, args);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void resolveSuperclassFieldDependencies(Object reference, Class<?> clazz) throws Exception {
        if (clazz.equals(Object.class)) {
            return;
        }
        Class<?> superclass = clazz.getSuperclass();
        this.resolveSuperclassFieldDependencies(reference, superclass);
        if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) {
            return;
        }
        BeanImpl bean = (BeanImpl)this.beanManager.getBean(clazz);
        Set<FieldInjectionPoint> injectionPoints = bean.fieldInjectionPoints;
        for (FieldInjectionPoint injectionPoint : injectionPoints) {
            FieldProvider<?> injection = this.beanManager.getInjectableReference(injectionPoint, null);
            if (injection == null) {
                for (FieldProvider<?> provider : bean.fieldProviders) {
                    if (!provider.getAnnotated().equals(injectionPoint.getAnnotated())) continue;
                    injection = provider;
                    break;
                }
            }
            Field field = injectionPoint.getAnnotated().getJavaMember();
            try {
                Field declaredField = this.proxyClass.getDeclaredField(field.getName());
                if (Reflections.matchInheritance(declaredField, field)) continue;
                try {
                    field.set(reference, injection);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void resolveSuperclassMethodDependencies(Object reference, Class<?> clazz) throws Exception {
        if (clazz.equals(Object.class)) {
            return;
        }
        Class<?> superclass = clazz.getSuperclass();
        this.resolveSuperclassMethodDependencies(reference, superclass);
        if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) {
            return;
        }
        BeanImpl superBean = (BeanImpl)this.beanManager.getBean(clazz);
        for (Map.Entry<AnnotatedMethod<?>, List<ParameterInjectionPoint>> methodParameterInjectionPoint : superBean.methodParameterInjectionPoints.entrySet()) {
            Method overrideMethod;
            List<ParameterInjectionPoint> paraSet = methodParameterInjectionPoint.getValue();
            Object[] args = new Object[paraSet.size()];
            int i = 0;
            for (ParameterInjectionPoint paraInjectionPoint : paraSet) {
                ParameterProvider<?> arg = this.beanManager.getInjectableReference(paraInjectionPoint, null);
                if (arg == null) {
                    for (ParameterProvider<?> provider : superBean.methodParameterProviders.get(methodParameterInjectionPoint.getKey())) {
                        if (!provider.getAnnotated().equals(paraInjectionPoint.getAnnotated())) continue;
                        arg = provider;
                        break;
                    }
                }
                args[i++] = arg;
            }
            AnnotatedMethod<?> superAnnotatedMethod = methodParameterInjectionPoint.getKey();
            Method superMethod = superAnnotatedMethod.getJavaMember();
            if (!superMethod.equals(overrideMethod = Reflections.getOverrideMethod(superMethod, this.proxyClass))) continue;
            try {
                superMethod.invoke(reference, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.stereotypes;
    }

    @Override
    public boolean isAlternative() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isNullable() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        LOGGER.log(Level.DEBUG, "Destroy bean [name={0}]", this.name);
    }

    @Override
    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        HashSet<InjectionPoint> ret = new HashSet<InjectionPoint>();
        for (List<ParameterInjectionPoint> constructorParameterInjectionPointList : this.constructorParameterInjectionPoints.values()) {
            ret.addAll(constructorParameterInjectionPointList);
        }
        ret.addAll(this.fieldInjectionPoints);
        for (List<ParameterInjectionPoint> methodParameterInjectionPointList : this.methodParameterInjectionPoints.values()) {
            ret.addAll(methodParameterInjectionPointList);
        }
        return ret;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    private void setScope(Class<? extends Annotation> scope) {
        this.scope = scope;
    }

    @Override
    public Set<Type> getTypes() {
        return this.types;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        T ret = null;
        try {
            ret = this.instantiateReference();
            this.resolveDependencies(ret);
        }
        catch (Exception ex) {
            LOGGER.log(Level.ERROR, ex.getMessage(), ex);
        }
        return ret;
    }

    @Override
    public LatkeBean<T> named(String name) {
        NamedLiteral namedQualifier = new NamedLiteral(name);
        this.addQualifier(namedQualifier);
        return this;
    }

    @Override
    public LatkeBean<T> qualified(Annotation qualifier, Annotation ... qualifiers) {
        this.addQualifier(qualifier);
        for (Annotation q : qualifiers) {
            this.addQualifier(q);
        }
        return this;
    }

    @Override
    public LatkeBean<T> scoped(Class<? extends Annotation> scope) {
        this.setScope(scope);
        return this;
    }

    public String toString() {
        return "[name=" + this.name + ", scope=" + this.scope.getName() + ", qualifiers=" + this.qualifiers + ", class=" + this.beanClass.getName() + ", types=" + this.types + "]";
    }

    private void initConstructorInjectionPoints() {
        Set<AnnotatedConstructor<T>> annotatedConstructors = this.annotatedType.getConstructors();
        for (AnnotatedConstructor<T> annotatedConstructor : annotatedConstructors) {
            List parameters = annotatedConstructor.getParameters();
            ArrayList<ParameterInjectionPoint> paraInjectionPointArrayList = new ArrayList<ParameterInjectionPoint>();
            for (AnnotatedParameter annotatedParameter : parameters) {
                Type type = annotatedParameter.getBaseType();
                if (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                if (type.equals(Provider.class)) {
                    ParameterProvider provider = new ParameterProvider(this.beanManager, annotatedParameter);
                    this.constructorParameterProviders.add(provider);
                }
                ParameterInjectionPoint parameterInjectionPoint = new ParameterInjectionPoint(this, annotatedParameter);
                paraInjectionPointArrayList.add(parameterInjectionPoint);
            }
            this.constructorParameterInjectionPoints.put(annotatedConstructor, paraInjectionPointArrayList);
        }
    }

    private void initMethodInjectionPoints() {
        Set<AnnotatedMethod<T>> annotatedMethods = this.annotatedType.getMethods();
        for (AnnotatedMethod<T> annotatedMethod : annotatedMethods) {
            List parameters = annotatedMethod.getParameters();
            ArrayList<ParameterInjectionPoint> paraInjectionPointArrayList = new ArrayList<ParameterInjectionPoint>();
            ArrayList paraProviders = new ArrayList();
            for (AnnotatedParameter annotatedParameter : parameters) {
                Type type = annotatedParameter.getBaseType();
                if (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                if (type.equals(Provider.class)) {
                    ParameterProvider provider = new ParameterProvider(this.beanManager, annotatedParameter);
                    paraProviders.add(provider);
                }
                ParameterInjectionPoint parameterInjectionPoint = new ParameterInjectionPoint(this, annotatedParameter);
                paraInjectionPointArrayList.add(parameterInjectionPoint);
            }
            this.methodParameterProviders.put(annotatedMethod, paraProviders);
            this.methodParameterInjectionPoints.put(annotatedMethod, paraInjectionPointArrayList);
        }
    }

    private void initFieldInjectionPoints() {
        Set<AnnotatedField<T>> annotatedFields = this.annotatedType.getFields();
        for (AnnotatedField<T> annotatedField : annotatedFields) {
            Field field = annotatedField.getJavaMember();
            if (field.getType().equals(Provider.class)) {
                FieldProvider provider = new FieldProvider(this.beanManager, annotatedField);
                this.fieldProviders.add(provider);
                FieldInjectionPoint fieldInjectionPoint = new FieldInjectionPoint(this, annotatedField);
                this.fieldInjectionPoints.add(fieldInjectionPoint);
                continue;
            }
            FieldInjectionPoint fieldInjectionPoint = new FieldInjectionPoint(this, annotatedField);
            this.fieldInjectionPoints.add(fieldInjectionPoint);
        }
    }

    private void addQualifier(Annotation qualifier) {
        if (qualifier.getClass().equals(NamedLiteral.class)) {
            NamedLiteral namedQualifier = (NamedLiteral)this.getNamedQualifier();
            NamedLiteral newNamedQualifier = (NamedLiteral)qualifier;
            if (!namedQualifier.value().equals(newNamedQualifier.value())) {
                this.setNamedQualifier(newNamedQualifier);
            }
        } else {
            this.qualifiers.add(qualifier);
        }
        this.configurator.addClassQualifierBinding(this.beanClass, qualifier);
    }

    private Annotation getNamedQualifier() {
        for (Annotation qualifier : this.qualifiers) {
            if (!qualifier.annotationType().equals(Named.class)) continue;
            return qualifier;
        }
        throw new RuntimeException("A bean has one qualifier(Named) at least!");
    }

    private void setNamedQualifier(Annotation namedQualifier) {
        for (Annotation qualifier : this.qualifiers) {
            if (!qualifier.annotationType().equals(Named.class)) continue;
            this.qualifiers.remove(qualifier);
            this.qualifiers.add(namedQualifier);
            this.name = ((Named)namedQualifier).value();
        }
    }
}

