/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.annotated;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.b3log.latke.intercept.annotation.AfterMethod;
import org.b3log.latke.intercept.annotation.BeforeMethod;
import org.b3log.latke.ioc.annotated.AnnotatedConstructor;
import org.b3log.latke.ioc.annotated.AnnotatedConstructorImpl;
import org.b3log.latke.ioc.annotated.AnnotatedField;
import org.b3log.latke.ioc.annotated.AnnotatedFieldImpl;
import org.b3log.latke.ioc.annotated.AnnotatedMethod;
import org.b3log.latke.ioc.annotated.AnnotatedMethodImpl;
import org.b3log.latke.ioc.annotated.AnnotatedType;
import org.b3log.latke.ioc.bean.Interceptor;
import org.b3log.latke.ioc.bean.InterceptorHolder;
import org.b3log.latke.ioc.inject.Inject;
import org.b3log.latke.ioc.util.Beans;
import org.b3log.latke.util.CollectionUtils;
import org.b3log.latke.util.Reflections;

public class AnnotatedTypeImpl<T>
implements AnnotatedType<T> {
    private Class<T> beanClass;
    private Set<AnnotatedConstructor<T>> annotatedConstructors;
    private Set<AnnotatedMethod<? super T>> annotatedMethods;
    private Set<AnnotatedField<? super T>> annotatedFields;

    public AnnotatedTypeImpl(Class<T> beanClass) {
        this.beanClass = beanClass;
        this.annotatedConstructors = new HashSet<AnnotatedConstructor<T>>();
        this.annotatedFields = new HashSet<AnnotatedField<? super T>>();
        this.annotatedMethods = new HashSet<AnnotatedMethod<? super T>>();
        this.initAnnotatedConstructor();
        this.initAnnotatedFields();
        this.initAnnotatedMethods();
    }

    @Override
    public Class<T> getJavaClass() {
        return this.beanClass;
    }

    @Override
    public Set<AnnotatedConstructor<T>> getConstructors() {
        return this.annotatedConstructors;
    }

    @Override
    public Set<AnnotatedMethod<? super T>> getMethods() {
        return this.annotatedMethods;
    }

    @Override
    public Set<AnnotatedField<? super T>> getFields() {
        return this.annotatedFields;
    }

    @Override
    public Type getBaseType() {
        return this.beanClass;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return CollectionUtils.arrayToSet(this.beanClass.getAnnotations());
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void initAnnotatedConstructor() {
        for (Constructor<?> constructor : this.beanClass.getDeclaredConstructors()) {
            boolean isNeedToBeInjected = constructor.isAnnotationPresent(Inject.class);
            if (!isNeedToBeInjected) continue;
            AnnotatedConstructorImpl annotatedConstructor = new AnnotatedConstructorImpl(constructor);
            constructor.setAccessible(true);
            this.annotatedConstructors.add(annotatedConstructor);
        }
    }

    private void initAnnotatedFields() {
        AnnotatedFieldImpl annotatedField;
        boolean isNeedToBeInjected;
        Set<Field> inheritedFields = Reflections.getInheritedFields(this.beanClass);
        Set<Field> hiddenFields = Reflections.getHiddenFields(this.beanClass);
        Set<Field> ownFields = Reflections.getOwnFields(this.beanClass);
        for (Field field : hiddenFields) {
            isNeedToBeInjected = field.isAnnotationPresent(Inject.class);
            if (!isNeedToBeInjected) continue;
            annotatedField = new AnnotatedFieldImpl(field);
            field.setAccessible(true);
            this.annotatedFields.add(annotatedField);
        }
        for (Field field : inheritedFields) {
            isNeedToBeInjected = field.isAnnotationPresent(Inject.class);
            if (!isNeedToBeInjected) continue;
            annotatedField = new AnnotatedFieldImpl(field);
            field.setAccessible(true);
            this.annotatedFields.add(annotatedField);
        }
        for (Field field : ownFields) {
            isNeedToBeInjected = field.isAnnotationPresent(Inject.class);
            if (!isNeedToBeInjected) continue;
            annotatedField = new AnnotatedFieldImpl(field);
            field.setAccessible(true);
            this.annotatedFields.add(annotatedField);
        }
    }

    private void initAnnotatedMethods() {
        AnnotatedMethodImpl annotatedMethod;
        boolean isNeedToBeInjected;
        Set<Method> inheritedMethods = Reflections.getInheritedMethods(this.beanClass);
        Set<Method> overriddenMethods = Reflections.getOverriddenMethods(this.beanClass);
        Set<Method> ownMethods = Reflections.getOwnMethods(this.beanClass);
        for (Method method : overriddenMethods) {
            isNeedToBeInjected = method.isAnnotationPresent(Inject.class);
            if (isNeedToBeInjected) {
                annotatedMethod = new AnnotatedMethodImpl(method);
                method.setAccessible(true);
                this.annotatedMethods.add(annotatedMethod);
            }
            this.initInterceptor(method);
        }
        for (Method method : inheritedMethods) {
            isNeedToBeInjected = method.isAnnotationPresent(Inject.class);
            if (isNeedToBeInjected) {
                annotatedMethod = new AnnotatedMethodImpl(method);
                method.setAccessible(true);
                this.annotatedMethods.add(annotatedMethod);
            }
            this.initInterceptor(method);
        }
        for (Method method : ownMethods) {
            isNeedToBeInjected = method.isAnnotationPresent(Inject.class);
            if (isNeedToBeInjected) {
                annotatedMethod = new AnnotatedMethodImpl(method);
                method.setAccessible(true);
                this.annotatedMethods.add(annotatedMethod);
            }
            this.initInterceptor(method);
        }
    }

    @Override
    public Set<Type> getTypeClosure() {
        return Beans.getBeanTypes(this.beanClass);
    }

    private void initInterceptor(Method method) {
        AfterMethod afterMethod;
        BeforeMethod beforeMethod = method.getAnnotation(BeforeMethod.class);
        if (null != beforeMethod) {
            InterceptorHolder.addInterceptor(new Interceptor(method, beforeMethod), BeforeMethod.class);
        }
        if (null != (afterMethod = method.getAnnotation(AfterMethod.class))) {
            InterceptorHolder.addInterceptor(new Interceptor(method, afterMethod), AfterMethod.class);
        }
    }
}

