/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.image.local;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.b3log.latke.image.Image;
import org.b3log.latke.image.ImageService;

public final class LocalImageService
implements ImageService {
    @Override
    public Image makeImage(byte[] data) {
        Image ret = new Image();
        ret.setData(data);
        return ret;
    }

    @Override
    public Image makeImage(List<Image> images) {
        if (null == images || images.isEmpty()) {
            return null;
        }
        try {
            byte[] data;
            Image firstImage = images.get(0);
            BufferedImage tmp = ImageIO.read(new ByteArrayInputStream(firstImage.getData()));
            for (int i = 1; i < images.size(); ++i) {
                Image image = images.get(i);
                data = image.getData();
                BufferedImage awtImage = ImageIO.read(new ByteArrayInputStream(data));
                tmp = LocalImageService.splice(tmp, awtImage);
            }
            Image ret = new Image();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)tmp, "PNG", byteArrayOutputStream);
            data = byteArrayOutputStream.toByteArray();
            ret.setData(data);
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static BufferedImage splice(java.awt.Image image1, java.awt.Image image2) {
        int[][] size = new int[][]{{image1.getWidth(null), image1.getHeight(null)}, {image2.getWidth(null), image2.getHeight(null)}};
        int width = size[0][0] + size[1][0];
        int height = Math.max(size[0][1], size[1][1]);
        BufferedImage ret = new BufferedImage(width, height, 1);
        Graphics2D g2 = ret.createGraphics();
        g2.drawImage(image1, 0, 0, null);
        g2.drawImage(image2, size[0][0], 0, null);
        return ret;
    }
}

