/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.event;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.b3log.latke.Latkes;
import org.b3log.latke.event.AbstractEventListener;
import org.b3log.latke.event.Event;
import org.b3log.latke.event.EventException;
import org.b3log.latke.event.SynchronizedEventQueue;
import org.b3log.latke.ioc.inject.Named;
import org.b3log.latke.ioc.inject.Singleton;
import org.b3log.latke.repository.jdbc.JdbcRepository;

@Named(value="LatkeBuiltInEventManager")
@Singleton
public class EventManager {
    private SynchronizedEventQueue synchronizedEventQueue = new SynchronizedEventQueue(this);

    public void fireEventSynchronously(Event<?> event) throws EventException {
        this.synchronizedEventQueue.fireEvent(event);
    }

    public <T> Future<T> fireEventAsynchronously(final Event<?> event) throws EventException {
        FutureTask futureTask = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                EventManager.this.synchronizedEventQueue.fireEvent(event);
                JdbcRepository.dispose();
                return null;
            }
        });
        Latkes.EXECUTOR_SERVICE.execute(futureTask);
        return futureTask;
    }

    public void registerListener(AbstractEventListener<?> eventListener) {
        this.synchronizedEventQueue.addListener(eventListener);
    }

    public void unregisterListener(AbstractEventListener<?> eventListener) {
        this.synchronizedEventQueue.deleteListener(eventListener);
    }
}

