/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.cache.redis;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.b3log.latke.Latkes;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

final class Connections {
    private static final Logger LOGGER = Logger.getLogger(Connections.class);
    private static JedisPool pool;

    private Connections() {
    }

    static Jedis getJedis() {
        return pool.getResource();
    }

    static void shutdown() {
        pool.close();
    }

    static {
        try {
            JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
            Latkes.RuntimeCache runtimeCache = Latkes.getRuntimeCache();
            if (Latkes.RuntimeCache.REDIS == runtimeCache) {
                int minConnCnt = Integer.valueOf(Latkes.getLocalProperty("redis.minConnCnt"));
                jedisPoolConfig.setMinIdle(minConnCnt);
                int maxConnCnt = Integer.valueOf(Latkes.getLocalProperty("redis.maxConnCnt"));
                jedisPoolConfig.setMaxTotal(maxConnCnt);
                String host = Latkes.getLocalProperty("redis.host");
                int port = Integer.valueOf(Latkes.getLocalProperty("redis.port"));
                String password = Latkes.getLatkeProperty("redis.password");
                long waitTime = Long.valueOf(Latkes.getLocalProperty("redis.waitTime"));
                jedisPoolConfig.setMaxWaitMillis(waitTime);
                pool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port, 2000, password);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Initializes redis connection pool failed", e);
        }
    }
}

