/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.cache.local.memory;

import java.io.Serializable;
import java.util.Collection;
import org.b3log.latke.cache.AbstractCache;
import org.b3log.latke.cache.local.memory.DoubleLinkedMap;
import org.b3log.latke.logging.Logger;
import org.json.JSONObject;

public final class LruMemoryCache
extends AbstractCache
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(LruMemoryCache.class);
    private DoubleLinkedMap<String, JSONObject> map = new DoubleLinkedMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, JSONObject value) {
        this.remove(key);
        this.putCountInc();
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            if (this.getCachedCount() >= this.getMaxCount()) {
                this.collect();
            }
            this.map.addFirst(key, value);
            this.cachedCountInc();
        }
    }

    @Override
    public synchronized JSONObject get(String key) {
        JSONObject ret = this.map.get(key);
        if (null != ret) {
            this.hitCountInc();
            this.map.makeFirst(key);
            return ret;
        }
        this.missCountInc();
        return null;
    }

    @Override
    public synchronized void remove(String key) {
        boolean removed = this.map.remove(key);
        if (removed) {
            this.cachedCountDec();
        }
    }

    @Override
    public synchronized void remove(Collection<String> keys) {
        for (String key : keys) {
            this.remove(key);
        }
    }

    @Override
    public synchronized void collect() {
        this.map.removeLast();
        this.cachedCountDec();
    }

    @Override
    public synchronized void removeAll() {
        this.map.removeAll();
        this.setCachedCount(0L);
        this.setMissCount(0L);
        this.setHitCount(0);
    }

    @Override
    public boolean contains(String key) {
        return null != this.get(key);
    }
}

