/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.util.Strings;
import org.json.JSONArray;
import org.json.JSONObject;

public final class Requests {
    private static final Logger LOGGER = Logger.getLogger(Requests.class.getName());
    public static final String PAGINATION_PATH_PATTERN = "*/*/*";
    private static final int DEFAULT_PAGE_SIZE = 15;
    private static final int DEFAULT_WINDOW_SIZE = 20;
    private static final Pattern MOBILE_USER_AGENT_PATTERN = Pattern.compile("android.+mobile|avantgo|bada|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge|maemo|midp|mmp|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)|plucker|pocket|psp|symbian|treo|up.(browser|link)|ucweb|vodafone|wap|webos|windows (ce|phone)|xda|xiino|htc|MQQBrowser", 2);
    private static final Pattern SEARCH_ENGINE_BOT_USER_AGENT_PATTERN = Pattern.compile("spider|bot|fetcher|crawler|google|yahoo|sogou|youdao|Xianguo.com|RssBandit|JianKongBao Monitor|BAE Online Platform|B3log", 2);
    private static final int COOKIE_EXPIRY = 86400;

    public static void log(HttpServletRequest httpServletRequest, Level level, Logger logger) {
        if (!logger.isLoggable(level)) {
            return;
        }
        logger.log(level, Requests.getLog(httpServletRequest), new Object[0]);
    }

    public static String getLog(HttpServletRequest httpServletRequest) {
        String indents = "    ";
        StringBuilder logBuilder = new StringBuilder("Request [").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("method=").append(httpServletRequest.getMethod()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("URL=").append(httpServletRequest.getRequestURL()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("contentType=").append(httpServletRequest.getContentType()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("characterEncoding=").append(httpServletRequest.getCharacterEncoding()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("local=[").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("    ").append("addr=").append(httpServletRequest.getLocalAddr()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("    ").append("port=").append(httpServletRequest.getLocalPort()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("    ").append("name=").append(httpServletRequest.getLocalName()).append("],").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("remote=[").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("    ").append("addr=").append(Requests.getRemoteAddr(httpServletRequest)).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("    ").append("port=").append(httpServletRequest.getRemotePort()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("    ").append("host=").append(httpServletRequest.getRemoteHost()).append("],").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("headers=[").append(Strings.LINE_SEPARATOR);
        StringBuilder headerLogBuilder = new StringBuilder();
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            String value = httpServletRequest.getHeader(name);
            headerLogBuilder.append("    ").append("    ").append(name).append("=").append(value);
            headerLogBuilder.append(Strings.LINE_SEPARATOR);
        }
        headerLogBuilder.append("    ").append("]");
        logBuilder.append(headerLogBuilder.toString()).append(Strings.LINE_SEPARATOR).append("]");
        return logBuilder.toString();
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String ret = request.getHeader("X-forwarded-for");
        if (Strings.isEmptyOrNull(ret)) {
            ret = request.getHeader("X-Real-IP");
        }
        if (Strings.isEmptyOrNull(ret)) {
            return request.getRemoteAddr();
        }
        return ret.split(",")[0];
    }

    public static String mobileSwitchToggle(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        String ret = null;
        if (null == cookies || 0 == cookies.length) {
            return ret;
        }
        try {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!"btouch_switch_toggle".equals(cookie.getName())) continue;
                ret = cookie.getValue();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Parses cookie failed", e);
        }
        return ret;
    }

    public static boolean searchEngineBotRequest(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (Strings.isEmptyOrNull(userAgent)) {
            return false;
        }
        return SEARCH_ENGINE_BOT_USER_AGENT_PATTERN.matcher(userAgent).find();
    }

    public static boolean hasBeenServed(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (null == cookies || 0 == cookies.length) {
            return false;
        }
        boolean needToCreate = true;
        boolean needToAppend = true;
        JSONArray cookieJSONArray = null;
        try {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!"visited".equals(cookie.getName())) continue;
                cookieJSONArray = new JSONArray(cookie.getValue());
                if (null == cookieJSONArray || 0 == cookieJSONArray.length()) {
                    return false;
                }
                needToCreate = false;
                for (int j = 0; j < cookieJSONArray.length(); ++j) {
                    String visitedURL = cookieJSONArray.optString(j);
                    if (!request.getRequestURI().equals(visitedURL)) continue;
                    needToAppend = false;
                    return true;
                }
            }
            if (needToCreate) {
                StringBuilder builder = new StringBuilder("[").append("\"").append(request.getRequestURI()).append("\"]");
                Cookie c = new Cookie("visited", builder.toString());
                c.setMaxAge(86400);
                c.setPath("/");
                response.addCookie(c);
            } else if (needToAppend) {
                cookieJSONArray.put(request.getRequestURI());
                Cookie c = new Cookie("visited", cookieJSONArray.toString());
                c.setMaxAge(86400);
                c.setPath("/");
                response.addCookie(c);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Parses cookie failed, clears the cookie[name=visited]", e);
            Cookie c = new Cookie("visited", null);
            c.setMaxAge(0);
            c.setPath("/");
            response.addCookie(c);
        }
        return false;
    }

    public static boolean mobileRequest(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (Strings.isEmptyOrNull(userAgent)) {
            return false;
        }
        return MOBILE_USER_AGENT_PATTERN.matcher(userAgent).find();
    }

    public static JSONObject buildPaginationRequest(String path) {
        Integer currentPageNum = Requests.getCurrentPageNum(path);
        Integer pageSize = Requests.getPageSize(path);
        Integer windowSize = Requests.getWindowSize(path);
        JSONObject ret = new JSONObject();
        ret.put("paginationCurrentPageNum", currentPageNum);
        ret.put("paginationPageSize", pageSize);
        ret.put("paginationWindowSize", windowSize);
        return ret;
    }

    public static int getCurrentPageNum(String path) {
        LOGGER.log(Level.TRACE, "Getting current page number[path={0}]", path);
        if (Strings.isEmptyOrNull(path) || path.equals("/")) {
            return 1;
        }
        String currentPageNumber = path.split("/")[0];
        if (!Strings.isNumeric(currentPageNumber)) {
            return 1;
        }
        return Integer.valueOf(currentPageNumber);
    }

    public static int getPageSize(String path) {
        LOGGER.log(Level.TRACE, "Page number[string={0}]", path);
        if (Strings.isEmptyOrNull(path)) {
            return 15;
        }
        String[] parts = path.split("/");
        if (1 >= parts.length) {
            return 15;
        }
        String pageSize = parts[1];
        if (!Strings.isNumeric(pageSize)) {
            return 15;
        }
        return Integer.valueOf(pageSize);
    }

    public static int getWindowSize(String path) {
        LOGGER.log(Level.TRACE, "Page number[string={0}]", path);
        if (Strings.isEmptyOrNull(path)) {
            return 20;
        }
        String[] parts = path.split("/");
        if (2 >= parts.length) {
            return 20;
        }
        String windowSize = parts[2];
        if (!Strings.isNumeric(windowSize)) {
            return 20;
        }
        return Integer.valueOf(windowSize);
    }

    public static JSONObject parseRequestJSONObject(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        StringBuilder sb = new StringBuilder();
        String errMsg = "Can not parse request[requestURI=" + request.getRequestURI() + ", method=" + request.getMethod() + "], returns an empty json object";
        try {
            BufferedReader reader;
            try {
                reader = request.getReader();
            }
            catch (IllegalStateException illegalStateException) {
                reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
            }
            String line = reader.readLine();
            while (null != line) {
                sb.append(line);
                line = reader.readLine();
            }
            reader.close();
            String tmp = sb.toString();
            if (Strings.isEmptyOrNull(tmp)) {
                tmp = "{}";
            }
            return new JSONObject(tmp);
        }
        catch (Exception ex) {
            LOGGER.log(Level.ERROR, errMsg, ex);
            return new JSONObject();
        }
    }

    private Requests() {
    }
}

