/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.b3log.latke.servlet.renderer.AbstractHTTPResponseRenderer;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.json.JSONObject;

public final class HTTPRequestContext {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private AbstractHTTPResponseRenderer renderer;

    public AbstractHTTPResponseRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(AbstractHTTPResponseRenderer renderer) {
        this.renderer = renderer;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public HTTPRequestContext renderJSONPretty(JSONObject json) {
        JSONRenderer jsonRenderer = new JSONRenderer();
        jsonRenderer.setJSONObject(json);
        jsonRenderer.setPretty(true);
        this.renderer = jsonRenderer;
        return this;
    }

    public HTTPRequestContext renderJSON() {
        JSONRenderer jsonRenderer = new JSONRenderer();
        JSONObject ret = new JSONObject().put("sc", false);
        jsonRenderer.setJSONObject(ret);
        this.renderer = jsonRenderer;
        return this;
    }

    public HTTPRequestContext renderJSON(JSONObject json) {
        JSONRenderer jsonRenderer = new JSONRenderer();
        jsonRenderer.setJSONObject(json);
        this.renderer = jsonRenderer;
        return this;
    }

    public HTTPRequestContext renderJSON(boolean sc) {
        JSONRenderer jsonRenderer = new JSONRenderer();
        JSONObject ret = new JSONObject().put("sc", sc);
        jsonRenderer.setJSONObject(ret);
        this.renderer = jsonRenderer;
        return this;
    }

    public HTTPRequestContext renderTrueResult() {
        if (this.renderer instanceof JSONRenderer) {
            JSONRenderer r = (JSONRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put("sc", true);
        }
        return this;
    }

    public HTTPRequestContext renderFalseResult() {
        if (this.renderer instanceof JSONRenderer) {
            JSONRenderer r = (JSONRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put("sc", false);
        }
        return this;
    }

    public HTTPRequestContext renderMsg(String msg) {
        if (this.renderer instanceof JSONRenderer) {
            JSONRenderer r = (JSONRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put("msg", msg);
        }
        return this;
    }

    public HTTPRequestContext renderJSONValue(String name, Object obj) {
        if (this.renderer instanceof JSONRenderer) {
            JSONRenderer r = (JSONRenderer)this.renderer;
            JSONObject ret = r.getJSONObject();
            ret.put(name, obj);
        }
        return this;
    }
}

