/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.service;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.Latkes;
import org.b3log.latke.ioc.inject.Named;
import org.b3log.latke.ioc.inject.Singleton;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.service.LangPropsService;
import org.b3log.latke.util.Locales;

@Named
@Singleton
public class LangPropsServiceImpl
implements LangPropsService {
    private static final Logger LOGGER = Logger.getLogger(LangPropsServiceImpl.class.getName());
    private static final Map<Locale, Map<String, String>> LANGS = new HashMap<Locale, Map<String, String>>();

    @Override
    public Map<String, String> getAll(Locale locale) {
        Map<String, String> ret = LANGS.get(locale);
        if (null == ret) {
            ResourceBundle langBundle;
            ret = new HashMap<String, String>();
            try {
                langBundle = ResourceBundle.getBundle("lang", locale);
            }
            catch (MissingResourceException e) {
                LOGGER.log(Level.WARN, "{0}, using default locale[{1}] instead", e.getMessage(), Latkes.getLocale());
                try {
                    langBundle = ResourceBundle.getBundle("lang", Latkes.getLocale());
                }
                catch (MissingResourceException ex) {
                    LOGGER.log(Level.WARN, "{0}, using default lang.properties instead", e.getMessage());
                    langBundle = ResourceBundle.getBundle("lang");
                }
            }
            Enumeration<String> keys = langBundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = this.replaceVars(langBundle.getString(key));
                ret.put(key, value);
            }
            LANGS.put(locale, ret);
        }
        return ret;
    }

    @Override
    public String get(String key) {
        return this.get("lang", key, Locales.getLocale());
    }

    @Override
    public String get(String key, Locale locale) {
        return this.get("lang", key, locale);
    }

    private String get(String baseName, String key, Locale locale) {
        if (!"lang".equals(baseName)) {
            RuntimeException e = new RuntimeException("i18n resource[baseName=" + baseName + "] not found");
            LOGGER.log(Level.ERROR, e.getMessage(), e);
            throw e;
        }
        try {
            return this.replaceVars(ResourceBundle.getBundle(baseName, locale).getString(key));
        }
        catch (MissingResourceException e) {
            LOGGER.log(Level.WARN, "{0}, get it from default locale[{1}]", e.getMessage(), Latkes.getLocale());
            return ResourceBundle.getBundle(baseName, Latkes.getLocale()).getString(key);
        }
    }

    private String replaceVars(String langValue) {
        String ret = StringUtils.replace((String)langValue, (String)"${servePath}", (String)Latkes.getServePath());
        ret = StringUtils.replace((String)ret, (String)"${staticServePath}", (String)Latkes.getStaticServePath());
        return ret;
    }
}

