/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.mail;

import org.b3log.latke.logging.Logger;
import org.b3log.latke.mail.MailService;

public final class MailServiceFactory {
    private static final Logger LOGGER = Logger.getLogger(MailServiceFactory.class.getName());
    private static final MailService MAIL_SERVICE;

    private MailServiceFactory() {
    }

    public static MailService getMailService() {
        return MAIL_SERVICE;
    }

    static {
        LOGGER.info("Constructing mail service....");
        try {
            Class<?> mailServiceClass = Class.forName("org.b3log.latke.mail.local.LocalMailService");
            MAIL_SERVICE = (MailService)mailServiceClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can not initialize mail service!", e);
        }
        LOGGER.info("Constructed mail service");
    }
}

