/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Set;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import org.b3log.latke.intercept.annotation.AfterMethod;
import org.b3log.latke.intercept.annotation.BeforeMethod;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.bean.Interceptor;
import org.b3log.latke.ioc.bean.InterceptorHolder;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.annotation.Transactional;
import org.b3log.latke.repository.jdbc.JdbcRepository;
import org.b3log.latke.repository.jdbc.JdbcTransaction;

public final class JavassistMethodHandler
implements MethodHandler {
    private static final Logger LOGGER = Logger.getLogger(JavassistMethodHandler.class);
    private LatkeBeanManager beanManager;
    private MethodFilter methodFilter = new MethodFilter(){

        public boolean isHandled(Method method) {
            String name = method.getName();
            return !"beginTransaction".equals(name) && !"hasTransactionBegun".equals(name);
        }
    };

    public JavassistMethodHandler(LatkeBeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public Object invoke(Object proxy, Method method, Method proceed, Object[] params) throws Throwable {
        Object ret;
        LOGGER.trace("Processing invocation [" + method.toString() + "]");
        Class<?> declaringClass = method.getDeclaringClass();
        String invokingMethodName = declaringClass.getName() + '#' + method.getName();
        this.handleInterceptor(invokingMethodName, params, BeforeMethod.class);
        boolean withTransactionalAnno = method.isAnnotationPresent(Transactional.class);
        boolean alreadyInTransaction = null != JdbcRepository.TX.get();
        boolean needHandleTrans = withTransactionalAnno && !alreadyInTransaction;
        JdbcTransaction transaction = null;
        if (needHandleTrans) {
            try {
                transaction = new JdbcTransaction();
            }
            catch (SQLException e) {
                LOGGER.log(Level.ERROR, "Failed to initialize JDBC transaction", e);
                throw new IllegalStateException("Begin a transaction failed");
            }
            JdbcRepository.TX.set(transaction);
        }
        try {
            ret = proceed.invoke(proxy, params);
            if (needHandleTrans) {
                transaction.commit();
            }
        }
        catch (InvocationTargetException e) {
            if (needHandleTrans && null != transaction && transaction.isActive()) {
                transaction.rollback();
            }
            throw e.getTargetException();
        }
        this.handleInterceptor(invokingMethodName, params, AfterMethod.class);
        return ret;
    }

    private void handleInterceptor(String invokingMehtodName, Object[] params, Class<? extends Annotation> interceptAnnClass) {
        Set<Interceptor> interceptors = InterceptorHolder.getInterceptors(invokingMehtodName, interceptAnnClass);
        for (Interceptor interceptor : interceptors) {
            Method interceptMethod = interceptor.getInterceptMethod();
            Class<?> interceptMethodClass = interceptMethod.getDeclaringClass();
            try {
                Object reference = this.beanManager.getReference(interceptMethodClass);
                interceptMethod.invoke(reference, params);
            }
            catch (Exception e) {
                String errMsg = "Interception[" + interceptor.toString() + "] execute failed";
                LOGGER.log(Level.ERROR, errMsg, e);
                throw new RuntimeException(errMsg);
            }
        }
    }

    public MethodFilter getMethodFilter() {
        return this.methodFilter;
    }
}

