/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.cache.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.b3log.latke.cache.AbstractCache;
import org.b3log.latke.cache.redis.Connections;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.json.JSONObject;
import redis.clients.jedis.Jedis;

public final class RedisCache
extends AbstractCache {
    private static final Logger LOGGER = Logger.getLogger(RedisCache.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String key) {
        Jedis jedis = null;
        try {
            jedis = Connections.getJedis();
            boolean bl = jedis.exists(key);
            return bl;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Contains key [" + key + "] failed", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, JSONObject value) {
        Jedis jedis = null;
        try {
            jedis = Connections.getJedis();
            jedis.set(this.getName() + key, value.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Put data to cache with key [" + key + "] failed", e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject get(String key) {
        Jedis jedis = null;
        try {
            jedis = Connections.getJedis();
            String s = jedis.get(this.getName() + key);
            if (null == s) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject jSONObject = new JSONObject(s);
            return jSONObject;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Get data from cache with key [" + key + "] failed", e);
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        Jedis jedis = null;
        try {
            jedis = Connections.getJedis();
            jedis.del(this.getName() + key);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Remove data to cache with key [" + key + "] failed", e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Collection<String> keys) {
        ArrayList<String> cacheKeys = new ArrayList<String>(keys.size());
        String cacheName = this.getName();
        for (String key : keys) {
            cacheKeys.add(cacheName + key);
        }
        Jedis jedis = null;
        try {
            jedis = Connections.getJedis();
            jedis.del(cacheKeys.toArray(new String[0]));
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Remove data to cache with keys [" + keys + "] failed", e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    public void removeAll() {
        Jedis jedis = null;
        try {
            jedis = Connections.getJedis();
            Set keys = jedis.keys("*");
            this.remove(keys);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Clear cache failed", e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    public static void shutdown() {
        try {
            Connections.shutdown();
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Shutdown redis connection pool failed", e);
        }
    }

    @Override
    public void collect() {
    }
}

