/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajdt.internal.compiler.lookup.OwningClassSupportForFieldBindings;
import org.aspectj.ajdt.internal.compiler.lookup.OwningClassSupportForMethodBindings;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.IPrivilegedHandler;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ImportConflictBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TagBits;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.UpdatedMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.aspectj.runtime.internal.AroundClosure;

public abstract class Scope
implements BaseTypes,
CompilerModifiers,
ProblemReasons,
TagBits,
TypeConstants,
TypeIds {
    public static final int BLOCK_SCOPE = 1;
    public static final int CLASS_SCOPE = 3;
    public static final int COMPILATION_UNIT_SCOPE = 4;
    public static final int METHOD_SCOPE = 2;
    public static final int NOT_COMPATIBLE = -1;
    public static final int COMPATIBLE = 0;
    public static final int AUTOBOX_COMPATIBLE = 1;
    public static final int VARARGS_COMPATIBLE = 2;
    public int kind;
    public Scope parent;

    public static int compareTypes(TypeBinding left, TypeBinding right) {
        if (left.isCompatibleWith(right)) {
            return -1;
        }
        if (right.isCompatibleWith(left)) {
            return 1;
        }
        return 0;
    }

    public static TypeBinding getBaseType(char[] name) {
        int length = name.length;
        if (length > 2 && length < 8) {
            switch (name[0]) {
                case 'i': {
                    if (length != 3 || name[1] != 'n' || name[2] != 't') break;
                    return BaseTypes.IntBinding;
                }
                case 'v': {
                    if (length != 4 || name[1] != 'o' || name[2] != 'i' || name[3] != 'd') break;
                    return BaseTypes.VoidBinding;
                }
                case 'b': {
                    if (length == 7 && name[1] == 'o' && name[2] == 'o' && name[3] == 'l' && name[4] == 'e' && name[5] == 'a' && name[6] == 'n') {
                        return BaseTypes.BooleanBinding;
                    }
                    if (length != 4 || name[1] != 'y' || name[2] != 't' || name[3] != 'e') break;
                    return BaseTypes.ByteBinding;
                }
                case 'c': {
                    if (length != 4 || name[1] != 'h' || name[2] != 'a' || name[3] != 'r') break;
                    return BaseTypes.CharBinding;
                }
                case 'd': {
                    if (length != 6 || name[1] != 'o' || name[2] != 'u' || name[3] != 'b' || name[4] != 'l' || name[5] != 'e') break;
                    return BaseTypes.DoubleBinding;
                }
                case 'f': {
                    if (length != 5 || name[1] != 'l' || name[2] != 'o' || name[3] != 'a' || name[4] != 't') break;
                    return BaseTypes.FloatBinding;
                }
                case 'l': {
                    if (length != 4 || name[1] != 'o' || name[2] != 'n' || name[3] != 'g') break;
                    return BaseTypes.LongBinding;
                }
                case 's': {
                    if (length != 5 || name[1] != 'h' || name[2] != 'o' || name[3] != 'r' || name[4] != 't') break;
                    return BaseTypes.ShortBinding;
                }
            }
        }
        return null;
    }

    public static ReferenceBinding[] substitute(Substitution substitution, ReferenceBinding[] originalTypes) {
        if (originalTypes == null) {
            return null;
        }
        ReferenceBinding[] substitutedTypes = originalTypes;
        int i = 0;
        int length = originalTypes.length;
        while (i < length) {
            ReferenceBinding originalType = originalTypes[i];
            ReferenceBinding substitutedParameter = (ReferenceBinding)Scope.substitute(substitution, originalType);
            if (substitutedParameter != originalType) {
                if (substitutedTypes == originalTypes) {
                    substitutedTypes = new ReferenceBinding[length];
                    System.arraycopy(originalTypes, 0, substitutedTypes, 0, i);
                }
                substitutedTypes[i] = substitutedParameter;
            } else if (substitutedTypes != originalTypes) {
                substitutedTypes[i] = originalType;
            }
            ++i;
        }
        return substitutedTypes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeBinding substitute(Substitution substitution, TypeBinding originalType) {
        switch (originalType.kind()) {
            case 4100: {
                return substitution.substitute((TypeVariableBinding)originalType);
            }
            case 260: {
                TypeBinding[] originalArguments;
                ReferenceBinding originalEnclosing;
                ParameterizedTypeBinding originalParameterizedType = (ParameterizedTypeBinding)originalType;
                ReferenceBinding substitutedEnclosing = originalEnclosing = originalType.enclosingType();
                if (originalEnclosing != null) {
                    substitutedEnclosing = (ReferenceBinding)Scope.substitute(substitution, originalEnclosing);
                }
                if (substitution.isRawSubstitution()) {
                    return originalParameterizedType.environment.createRawType(originalParameterizedType.type, substitutedEnclosing);
                }
                TypeBinding[] substitutedArguments = originalArguments = originalParameterizedType.arguments;
                if (originalArguments != null) {
                    substitutedArguments = Scope.substitute(substitution, originalArguments);
                }
                if (substitutedArguments == originalArguments && substitutedEnclosing == originalEnclosing) return originalType;
                if (substitutedEnclosing != null && substitutedEnclosing != originalEnclosing || originalParameterizedType.type.isBinaryBinding()) return originalParameterizedType.environment.createParameterizedType(originalParameterizedType.type, substitutedArguments, substitutedEnclosing);
                TypeVariableBinding[] originalVariables = originalParameterizedType.type.typeVariables();
                int i = 0;
                int length = originalVariables.length;
                while (i < length) {
                    if (substitutedArguments[i] != originalVariables[i]) return originalParameterizedType.environment.createParameterizedType(originalParameterizedType.type, substitutedArguments, substitutedEnclosing);
                    ++i;
                }
                return originalParameterizedType.type;
            }
            case 68: {
                ArrayBinding originalArrayType = (ArrayBinding)originalType;
                TypeBinding originalLeafComponentType = originalArrayType.leafComponentType;
                TypeBinding substitute = Scope.substitute(substitution, originalLeafComponentType);
                if (substitute == originalLeafComponentType) return originalType;
                return originalArrayType.environment.createArrayType(substitute.leafComponentType(), substitute.dimensions() + originalType.dimensions());
            }
            case 516: {
                WildcardBinding wildcard = (WildcardBinding)originalType;
                if (wildcard.boundKind == 0) return originalType;
                TypeBinding originalBound = wildcard.bound;
                TypeBinding substitutedBound = Scope.substitute(substitution, originalBound);
                TypeBinding[] originalOtherBounds = wildcard.otherBounds;
                TypeBinding[] substitutedOtherBounds = Scope.substitute(substitution, originalOtherBounds);
                if (substitutedBound == originalBound && originalOtherBounds == substitutedOtherBounds) return originalType;
                return wildcard.environment.createWildcard(wildcard.genericType, wildcard.rank, substitutedBound, substitutedOtherBounds, wildcard.boundKind);
            }
            case 4: {
                if (!originalType.isMemberType()) return originalType;
            }
            case 2052: {
                TypeBinding[] substitutedArguments;
                ReferenceBinding originalEnclosing;
                ReferenceBinding originalReferenceType = (ReferenceBinding)originalType;
                ReferenceBinding substitutedEnclosing = originalEnclosing = originalType.enclosingType();
                if (originalEnclosing != null) {
                    substitutedEnclosing = (ReferenceBinding)Scope.substitute(substitution, originalEnclosing);
                }
                if (substitution.isRawSubstitution()) {
                    return substitution.environment().createRawType(originalReferenceType, substitutedEnclosing);
                }
                TypeBinding[] originalArguments = originalReferenceType.typeVariables();
                if (originalArguments == TypeConstants.NoTypeVariables) {
                    originalArguments = null;
                    substitutedArguments = null;
                } else {
                    substitutedArguments = Scope.substitute(substitution, originalArguments);
                }
                if (substitutedArguments == originalArguments && substitutedEnclosing == originalEnclosing) return originalType;
                return substitution.environment().createParameterizedType(originalReferenceType, substitutedArguments, substitutedEnclosing);
            }
        }
        return originalType;
    }

    public static TypeBinding[] substitute(Substitution substitution, TypeBinding[] originalTypes) {
        if (originalTypes == null) {
            return null;
        }
        TypeBinding[] substitutedTypes = originalTypes;
        int i = 0;
        int length = originalTypes.length;
        while (i < length) {
            TypeBinding originalType = originalTypes[i];
            TypeBinding substitutedParameter = Scope.substitute(substitution, originalType);
            if (substitutedParameter != originalType) {
                if (substitutedTypes == originalTypes) {
                    substitutedTypes = new TypeBinding[length];
                    System.arraycopy(originalTypes, 0, substitutedTypes, 0, i);
                }
                substitutedTypes[i] = substitutedParameter;
            } else if (substitutedTypes != originalTypes) {
                substitutedTypes[i] = originalType;
            }
            ++i;
        }
        return substitutedTypes;
    }

    protected Scope(int kind, Scope parent) {
        this.kind = kind;
        this.parent = parent;
    }

    public TypeBinding boxing(TypeBinding type) {
        if (type.isBaseType()) {
            return this.environment().computeBoxingType(type);
        }
        return type;
    }

    public final ClassScope classScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final CompilationUnitScope compilationUnitScope() {
        Scope lastScope = null;
        Scope scope = this;
        do {
            lastScope = scope;
        } while ((scope = scope.parent) != null);
        return (CompilationUnitScope)lastScope;
    }

    public final CompilerOptions compilerOptions() {
        return this.compilationUnitScope().environment.globalOptions;
    }

    protected final MethodBinding computeCompatibleMethod(MethodBinding method, TypeBinding[] arguments, InvocationSite invocationSite) {
        TypeBinding[] genericTypeArguments = invocationSite.genericTypeArguments();
        TypeBinding[] parameters = method.parameters;
        TypeVariableBinding[] typeVariables = method.typeVariables;
        if (parameters == arguments && (method.returnType.tagBits & 0x20000000L) == 0L && genericTypeArguments == null && typeVariables == TypeConstants.NoTypeVariables) {
            return method;
        }
        int argLength = arguments.length;
        int paramLength = parameters.length;
        boolean isVarArgs = method.isVarargs();
        if (!(argLength == paramLength || isVarArgs && argLength >= paramLength - 1)) {
            return null;
        }
        if (typeVariables != TypeConstants.NoTypeVariables) {
            TypeBinding[] newArgs = null;
            int i = 0;
            while (i < argLength) {
                TypeBinding param;
                TypeBinding typeBinding = param = i < paramLength ? parameters[i] : parameters[paramLength - 1];
                if (arguments[i].isBaseType() != param.isBaseType()) {
                    if (newArgs == null) {
                        newArgs = new TypeBinding[argLength];
                        System.arraycopy(arguments, 0, newArgs, 0, argLength);
                    }
                    newArgs[i] = this.environment().computeBoxingType(arguments[i]);
                }
                ++i;
            }
            if (newArgs != null) {
                arguments = newArgs;
            }
            if ((method = ParameterizedGenericMethodBinding.computeCompatibleMethod(method, arguments, this, invocationSite)) == null) {
                return null;
            }
            if (!method.isValidBinding()) {
                return method;
            }
            parameters = method.parameters;
        } else if (genericTypeArguments != null) {
            if (method instanceof ParameterizedGenericMethodBinding) {
                if (!((ParameterizedGenericMethodBinding)method).wasInferred) {
                    return new ProblemMethodBinding(method, method.selector, genericTypeArguments, 13);
                }
            } else {
                return new ProblemMethodBinding(method, method.selector, genericTypeArguments, 11);
            }
        }
        if (this.parameterCompatibilityLevel(method, arguments) > -1) {
            return method;
        }
        if (genericTypeArguments != null) {
            return new ProblemMethodBinding(method, method.selector, arguments, 12);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean connectTypeVariables(TypeParameter[] typeParameters) {
        noProblems = true;
        if (typeParameters == null || this.compilerOptions().sourceLevel < 0x310000L) {
            return true;
        }
        types = new TypeBinding[2];
        invocations = new HashMap<K, V>(2);
        i = 0;
        paramLength = typeParameters.length;
        while (i < paramLength) {
            block21: {
                block23: {
                    block22: {
                        typeParameter = typeParameters[i];
                        typeVariable = typeParameter.binding;
                        if (typeVariable == null) {
                            return false;
                        }
                        typeVariable.superclass = this.getJavaLangObject();
                        typeVariable.superInterfaces = TypeConstants.NoSuperInterfaces;
                        typeVariable.firstBound = null;
                        typeRef = typeParameter.type;
                        if (typeRef == null) break block21;
                        v0 = superType = this.kind == 2 ? typeRef.resolveType((BlockScope)this, false) : typeRef.resolveType((ClassScope)this);
                        if (superType != null) break block22;
                        typeVariable.tagBits |= 32768L;
                        noProblems = false;
                        break block21;
                    }
                    typeRef.resolvedType = superType;
                    if (!superType.isArrayType()) break block23;
                    this.problemReporter().boundCannotBeArray(typeRef, superType);
                    break block21;
                }
                if (!superType.isTypeVariable()) ** GOTO lbl-1000
                varSuperType = (TypeVariableBinding)superType;
                if (varSuperType.rank >= typeVariable.rank && varSuperType.declaringElement == typeVariable.declaringElement) {
                    this.problemReporter().forwardTypeVariableReference(typeParameter, varSuperType);
                    typeVariable.tagBits |= 32768L;
                    noProblems = false;
                } else lbl-1000:
                // 2 sources

                {
                    if ((superRefType = (ReferenceBinding)superType).isFinal()) {
                        this.problemReporter().finalVariableBound(typeVariable, typeRef);
                    }
                    if (!superType.isInterface()) {
                        typeVariable.superclass = superRefType;
                    } else {
                        typeVariable.superInterfaces = new ReferenceBinding[]{superRefType};
                    }
                    typeVariable.firstBound = superRefType;
                    boundRefs = typeParameter.bounds;
                    if (boundRefs != null) {
                        j = 0;
                        boundLength = boundRefs.length;
                        block1: while (j < boundLength) {
                            typeRef = boundRefs[j];
                            v1 = superType = this.kind == 2 ? typeRef.resolveType((BlockScope)this, false) : typeRef.resolveType((ClassScope)this);
                            if (superType == null) {
                                typeVariable.tagBits |= 32768L;
                                noProblems = false;
                                break;
                            }
                            typeRef.resolvedType = superType;
                            types[0] = superType;
                            if (superType.isArrayType()) {
                                this.problemReporter().boundCannotBeArray(typeRef, superType);
                                break;
                            }
                            superRefType = (ReferenceBinding)superType;
                            if (!superType.isInterface()) {
                                this.problemReporter().boundMustBeAnInterface(typeRef, superType);
                                typeVariable.tagBits |= 32768L;
                                noProblems = false;
                                break;
                            }
                            if (typeVariable.firstBound == typeVariable.superclass) {
                                types[1] = typeVariable.superclass;
                                mecs = this.minimalErasedCandidates(types, invocations);
                                if (mecs != null) {
                                    k = 0;
                                    max = mecs.length;
                                    while (k < max) {
                                        mec = mecs[k];
                                        if (mec != null && (invalidSize = (invalidInvocations = (Set)invocations.get(mec)).size()) > 1) {
                                            collisions = new TypeBinding[invalidSize];
                                            invalidInvocations.toArray(collisions);
                                            this.problemReporter().superinterfacesCollide(collisions[0].erasure(), typeRef, collisions[1], collisions[0]);
                                            typeVariable.tagBits |= 32768L;
                                            noProblems = false;
                                            break block1;
                                        }
                                        ++k;
                                    }
                                }
                            }
                            index = typeVariable.superInterfaces.length;
                            while (--index >= 0) {
                                previousInterface = typeVariable.superInterfaces[index];
                                if (previousInterface == superRefType) {
                                    this.problemReporter().duplicateBounds(typeRef, superType);
                                    typeVariable.tagBits |= 32768L;
                                    noProblems = false;
                                    break block1;
                                }
                                types[1] = previousInterface;
                                invocations.clear();
                                mecs = this.minimalErasedCandidates(types, invocations);
                                if (mecs == null) continue;
                                m = 0;
                                max = mecs.length;
                                while (m < max) {
                                    mec = mecs[m];
                                    if (mec != null && (invalidSize = (invalidInvocations = (Set)invocations.get(mec)).size()) > 1) {
                                        collisions = new TypeBinding[invalidSize];
                                        invalidInvocations.toArray(collisions);
                                        this.problemReporter().superinterfacesCollide(collisions[0].erasure(), typeRef, collisions[0], collisions[1]);
                                        typeVariable.tagBits |= 32768L;
                                        noProblems = false;
                                        break block1;
                                    }
                                    ++m;
                                }
                            }
                            size = typeVariable.superInterfaces.length;
                            typeVariable.superInterfaces = new ReferenceBinding[size + 1];
                            System.arraycopy(typeVariable.superInterfaces, 0, typeVariable.superInterfaces, 0, size);
                            typeVariable.superInterfaces[size] = superRefType;
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        return noProblems;
    }

    public ArrayBinding createArrayType(TypeBinding type, int dimension) {
        if (type.isValidBinding()) {
            return this.environment().createArrayType(type, dimension);
        }
        return new ArrayBinding(type, dimension, this.environment());
    }

    public TypeVariableBinding[] createTypeVariables(TypeParameter[] typeParameters, Binding declaringElement) {
        if (typeParameters == null || this.compilerOptions().sourceLevel < 0x310000L) {
            return TypeConstants.NoTypeVariables;
        }
        TypeVariableBinding[] typeVariableBindings = TypeConstants.NoTypeVariables;
        PackageBinding unitPackage = this.compilationUnitScope().fPackage;
        int length = typeParameters.length;
        typeVariableBindings = new TypeVariableBinding[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            TypeParameter typeParameter = typeParameters[i];
            TypeVariableBinding parameterBinding = new TypeVariableBinding(typeParameter.name, declaringElement, i);
            parameterBinding.fPackage = unitPackage;
            typeParameter.binding = parameterBinding;
            int j = 0;
            while (j < count) {
                TypeVariableBinding knownVar = typeVariableBindings[j];
                if (CharOperation.equals(knownVar.sourceName, typeParameter.name)) {
                    this.problemReporter().duplicateTypeParameterInType(typeParameter);
                }
                ++j;
            }
            typeVariableBindings[count++] = parameterBinding;
            ++i;
        }
        if (count != length) {
            TypeVariableBinding[] typeVariableBindingArray = typeVariableBindings;
            typeVariableBindings = new TypeVariableBinding[count];
            System.arraycopy(typeVariableBindingArray, 0, typeVariableBindings, 0, count);
        }
        return typeVariableBindings;
    }

    public final ClassScope enclosingClassScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof ClassScope)) continue;
            return (ClassScope)scope;
        }
        return null;
    }

    public final MethodScope enclosingMethodScope() {
        Scope scope = this;
        while ((scope = scope.parent) != null) {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        }
        return null;
    }

    public ReferenceContext enclosingReferenceContext() {
        Scope current = this;
        while ((current = current.parent) != null) {
            switch (current.kind) {
                case 2: {
                    return ((MethodScope)current).referenceContext;
                }
                case 3: {
                    return ((ClassScope)current).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)current).referenceContext;
                }
            }
        }
        return null;
    }

    public final SourceTypeBinding enclosingSourceType() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return ((ClassScope)scope).referenceContext.binding;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public SourceTypeBinding invocationType() {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            return ((ClassScope)scope).invocationType();
        } while ((scope = scope.parent) != null);
        return null;
    }

    public final LookupEnvironment environment() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).environment;
    }

    public MethodBinding findDefaultAbstractMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite, ReferenceBinding classHierarchyStart, MethodBinding matchingMethod, ObjectVector found) {
        boolean isCompliant14;
        int startFoundSize = found.size;
        ReferenceBinding currentType = classHierarchyStart;
        while (currentType != null) {
            matchingMethod = this.findMethodInSuperInterfaces(currentType, selector, found, matchingMethod);
            currentType = currentType.superclass();
        }
        CompilationUnitScope unitScope = this.compilationUnitScope();
        int foundSize = found.size;
        if (foundSize == startFoundSize) {
            if (matchingMethod != null) {
                unitScope.recordTypeReferences(matchingMethod.thrownExceptions);
            }
            return matchingMethod;
        }
        MethodBinding[] candidates = new MethodBinding[foundSize - startFoundSize];
        int candidatesCount = 0;
        MethodBinding problemMethod = null;
        int i = startFoundSize;
        while (i < foundSize) {
            MethodBinding methodBinding = (MethodBinding)found.elementAt(i);
            MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
            if (compatibleMethod != null) {
                if (compatibleMethod.isValidBinding()) {
                    candidates[candidatesCount++] = compatibleMethod;
                } else if (problemMethod == null) {
                    problemMethod = compatibleMethod;
                }
            }
            ++i;
        }
        if (candidatesCount == 1) {
            unitScope.recordTypeReferences(candidates[0].thrownExceptions);
            return candidates[0];
        }
        if (candidatesCount == 0) {
            if (problemMethod != null) {
                return problemMethod;
            }
            int argLength = argumentTypes.length;
            int i2 = 0;
            while (i2 < foundSize) {
                block16: {
                    MethodBinding methodBinding = (MethodBinding)found.elementAt(i2);
                    TypeBinding[] params = methodBinding.parameters;
                    int paramLength = params.length;
                    int a = 0;
                    block3: while (a < argLength) {
                        TypeBinding arg = argumentTypes[a];
                        int p = 0;
                        while (p < paramLength) {
                            if (params[p] != arg) {
                                ++p;
                                continue;
                            }
                            ++a;
                            continue block3;
                        }
                        break block16;
                    }
                    return methodBinding;
                }
                ++i2;
            }
            return (MethodBinding)found.elementAt(0);
        }
        boolean bl = isCompliant14 = this.compilerOptions().complianceLevel >= 0x300000L;
        if (isCompliant14) {
            return this.mostSpecificMethodBinding(candidates, candidatesCount, argumentTypes, invocationSite);
        }
        return this.mostSpecificInterfaceMethodBinding(candidates, candidatesCount, invocationSite);
    }

    public ReferenceBinding findDirectMemberType(char[] typeName, ReferenceBinding enclosingType) {
        if ((enclosingType.tagBits & 0x4000L) != 0L) {
            return null;
        }
        SourceTypeBinding enclosingSourceType = this.enclosingSourceType();
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordReference(enclosingType, typeName);
        ReferenceBinding memberType = enclosingType.getMemberType(typeName);
        if (memberType != null) {
            unitScope.recordTypeReference(memberType);
            if (enclosingSourceType == null ? memberType.canBeSeenBy(this.getCurrentPackage()) : memberType.canBeSeenBy(enclosingType, enclosingSourceType)) {
                return memberType;
            }
            return new ProblemReferenceBinding(typeName, memberType, 2);
        }
        return null;
    }

    public MethodBinding findExactMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordTypeReferences(argumentTypes);
        MethodBinding exactMethod = receiverType.getExactMethod(selector, argumentTypes, unitScope);
        if (exactMethod != null && exactMethod.typeVariables == TypeConstants.NoTypeVariables) {
            unitScope.recordTypeReferences(exactMethod.thrownExceptions);
            if (receiverType.isInterface() || exactMethod.canBeSeenBy(receiverType, invocationSite, this)) {
                if (receiverType.id != 1 && argumentTypes == TypeConstants.NoParameters && CharOperation.equals(selector, TypeConstants.GETCLASS) && exactMethod.returnType.isParameterizedType()) {
                    return ParameterizedMethodBinding.instantiateGetClass(receiverType, exactMethod, this);
                }
                if (exactMethod.typeVariables != TypeConstants.NoTypeVariables || invocationSite.genericTypeArguments() != null) {
                    MethodBinding compatibleMethod = this.computeCompatibleMethod(exactMethod, argumentTypes, invocationSite);
                    if (!compatibleMethod.isValidBinding() && exactMethod.typeVariables != TypeConstants.NoTypeVariables) {
                        return null;
                    }
                    exactMethod = compatibleMethod;
                }
                return exactMethod;
            }
        }
        return null;
    }

    public static final IPrivilegedHandler findPrivilegedHandler(ReferenceBinding type) {
        if (type == null) {
            return null;
        }
        if (type instanceof SourceTypeBinding && ((SourceTypeBinding)type).privilegedHandler != null) {
            return ((SourceTypeBinding)type).privilegedHandler;
        }
        return Scope.findPrivilegedHandler(type.enclosingType());
    }

    /*
     * Enabled aggressive block sorting
     */
    public FieldBinding findField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite, boolean needResolve) {
        CompilationUnitScope unitScope;
        block34: {
            TypeBinding leafType;
            unitScope = this.compilationUnitScope();
            unitScope.recordTypeReference(receiverType);
            switch (receiverType.kind()) {
                case 132: {
                    return null;
                }
                case 516: 
                case 4100: {
                    TypeBinding receiverErasure = receiverType.erasure();
                    if (receiverErasure.isArrayType()) {
                        leafType = receiverErasure.leafComponentType();
                        break;
                    }
                    break block34;
                }
                case 68: {
                    leafType = receiverType.leafComponentType();
                    break;
                }
                default: {
                    break block34;
                }
            }
            if (leafType instanceof ReferenceBinding && !((ReferenceBinding)leafType).canBeSeenBy(this)) {
                return new ProblemFieldBinding((ReferenceBinding)leafType, fieldName, 8);
            }
            if (!CharOperation.equals(fieldName, TypeConstants.LENGTH)) return null;
            return ArrayBinding.ArrayLength;
        }
        ReferenceBinding currentType = (ReferenceBinding)receiverType;
        if (!currentType.canBeSeenBy(this)) {
            return new ProblemFieldBinding(currentType, fieldName, 8);
        }
        FieldBinding field = currentType.getField(fieldName, true, invocationSite, this);
        if (field != null) {
            FieldBinding ret = field.getVisibleBinding(currentType, invocationSite, this);
            if (ret != null) {
                return ret;
            }
            if (invocationSite == null ? field.canBeSeenBy(this.getCurrentPackage()) : field.canBeSeenBy(currentType, invocationSite, this)) {
                return field;
            }
            FieldBinding fieldBinding = field;
            return new ProblemFieldBinding(field, (ReferenceBinding)Scope.declaringClass_aroundBody1$advice(this, fieldBinding, OwningClassSupportForFieldBindings.aspectOf(), fieldBinding, null), fieldName, 2);
        }
        ReferenceBinding[][] interfacesToVisit = null;
        int lastPosition = -1;
        FieldBinding visibleField = null;
        boolean keepLooking = true;
        FieldBinding notVisibleField = null;
        while (keepLooking) {
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces == null) {
                ((SourceTypeBinding)currentType).scope.connectTypeHierarchy();
                itsInterfaces = currentType.superInterfaces();
            }
            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = new ReferenceBinding[5][];
                }
                if (++lastPosition == interfacesToVisit.length) {
                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                }
                interfacesToVisit[lastPosition] = itsInterfaces;
            }
            if ((currentType = currentType.superclass()) == null) break;
            unitScope.recordTypeReference(currentType);
            field = currentType.getField(fieldName, needResolve, invocationSite, this);
            if (field == null) continue;
            keepLooking = false;
            if ((field = field.getVisibleBinding(receiverType, invocationSite, this)) != null) {
                if (!field.canBeSeenBy(receiverType, invocationSite, this)) continue;
                if (visibleField != null) {
                    FieldBinding fieldBinding = visibleField;
                    return new ProblemFieldBinding(visibleField, (ReferenceBinding)Scope.declaringClass_aroundBody3$advice(this, fieldBinding, OwningClassSupportForFieldBindings.aspectOf(), fieldBinding, null), fieldName, 3);
                }
                visibleField = field;
                continue;
            }
            if (notVisibleField != null) continue;
            notVisibleField = field;
        }
        if (interfacesToVisit != null) {
            int length;
            int j;
            ReferenceBinding[] interfaces;
            ProblemFieldBinding ambiguous = null;
            int i = 0;
            block6: while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    ReferenceBinding anInterface = interfaces[j];
                    if ((anInterface.tagBits & 0x800L) == 0L) {
                        anInterface.tagBits |= 0x800L;
                        unitScope.recordTypeReference(anInterface);
                        field = anInterface.getField(fieldName, true, invocationSite, this);
                        if (field != null) {
                            if ((field = field.getVisibleBinding(receiverType, invocationSite, this)) != null) {
                                if (visibleField == null) {
                                    visibleField = field;
                                } else {
                                    FieldBinding fieldBinding = visibleField;
                                    ambiguous = new ProblemFieldBinding(visibleField, (ReferenceBinding)Scope.declaringClass_aroundBody5$advice(this, fieldBinding, OwningClassSupportForFieldBindings.aspectOf(), fieldBinding, null), fieldName, 3);
                                    break block6;
                                }
                            }
                        } else {
                            ReferenceBinding[] itsInterfaces = anInterface.superInterfaces();
                            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                                if (++lastPosition == interfacesToVisit.length) {
                                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                                }
                                interfacesToVisit[lastPosition] = itsInterfaces;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    interfaces[j].tagBits &= 0xFFFFFFFFFFFFF7FFL;
                    ++j;
                }
                ++i;
            }
            if (ambiguous != null) {
                return ambiguous;
            }
        }
        if (visibleField != null) {
            return visibleField;
        }
        if (notVisibleField == null) return null;
        return new ProblemFieldBinding(notVisibleField, currentType, fieldName, 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ReferenceBinding findMemberType(char[] typeName, ReferenceBinding enclosingType) {
        if ((enclosingType.tagBits & 0x4000L) != 0L) {
            return null;
        }
        SourceTypeBinding enclosingSourceType = this.invocationType();
        PackageBinding currentPackage = this.getCurrentPackage();
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordReference(enclosingType, typeName);
        ReferenceBinding memberType = enclosingType.getMemberType(typeName);
        if (memberType != null) {
            unitScope.recordTypeReference(memberType);
            if (enclosingSourceType == null) {
                if (!memberType.canBeSeenBy(currentPackage)) return new ProblemReferenceBinding(typeName, memberType, 2);
                return memberType;
            }
            if (!memberType.canBeSeenBy(enclosingType, enclosingSourceType)) return new ProblemReferenceBinding(typeName, memberType, 2);
            return memberType;
        }
        ReferenceBinding currentType = enclosingType;
        ReferenceBinding[][] interfacesToVisit = null;
        int lastPosition = -1;
        ReferenceBinding visibleMemberType = null;
        boolean keepLooking = true;
        ReferenceBinding notVisible = null;
        while (keepLooking) {
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces == null) {
                if (currentType.isHierarchyBeingConnected()) {
                    return null;
                }
                ((SourceTypeBinding)currentType).scope.connectTypeHierarchy();
                itsInterfaces = currentType.superInterfaces();
            }
            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                if (interfacesToVisit == null) {
                    interfacesToVisit = new ReferenceBinding[5][];
                }
                if (++lastPosition == interfacesToVisit.length) {
                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                }
                interfacesToVisit[lastPosition] = itsInterfaces;
            }
            if ((currentType = currentType.superclass()) == null) break;
            unitScope.recordReference(currentType, typeName);
            memberType = currentType.getMemberType(typeName);
            if (memberType == null) continue;
            unitScope.recordTypeReference(memberType);
            keepLooking = false;
            if (enclosingSourceType == null ? memberType.canBeSeenBy(currentPackage) : memberType.canBeSeenBy(enclosingType, enclosingSourceType)) {
                if (visibleMemberType != null) return new ProblemReferenceBinding(typeName, null, 3);
                visibleMemberType = memberType;
                continue;
            }
            notVisible = memberType;
        }
        if (interfacesToVisit != null) {
            int length;
            int j;
            ReferenceBinding[] interfaces;
            ProblemReferenceBinding ambiguous = null;
            int i = 0;
            block1: while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    block23: {
                        ReferenceBinding anInterface = interfaces[j];
                        if ((anInterface.tagBits & 0x800L) == 0L) {
                            anInterface.tagBits |= 0x800L;
                            unitScope.recordReference(anInterface, typeName);
                            memberType = anInterface.getMemberType(typeName);
                            if (memberType != null) {
                                unitScope.recordTypeReference(memberType);
                                if (visibleMemberType == null) {
                                    visibleMemberType = memberType;
                                    break block23;
                                } else {
                                    ambiguous = new ProblemReferenceBinding(typeName, null, 3);
                                    break block1;
                                }
                            }
                            ReferenceBinding[] itsInterfaces = anInterface.superInterfaces();
                            if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                                if (++lastPosition == interfacesToVisit.length) {
                                    ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                    interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                    System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                                }
                                interfacesToVisit[lastPosition] = itsInterfaces;
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    interfaces[j].tagBits &= 0xFFFFFFFFFFFFF7FFL;
                    ++j;
                }
                ++i;
            }
            if (ambiguous != null) {
                return ambiguous;
            }
        }
        if (visibleMemberType != null) {
            return visibleMemberType;
        }
        if (notVisible == null) return null;
        return new ProblemReferenceBinding(typeName, notVisible, 2);
    }

    public MethodBinding findMethod(ReferenceBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        ReferenceBinding currentType = receiverType;
        MethodBinding matchingMethod = null;
        ObjectVector found = new ObjectVector();
        CompilationUnitScope unitScope = this.compilationUnitScope();
        unitScope.recordTypeReferences(argumentTypes);
        if (currentType.isInterface()) {
            unitScope.recordTypeReference(currentType);
            Object[] currentMethods = currentType.getMethods(selector);
            int currentLength = currentMethods.length;
            if (currentLength == 1) {
                matchingMethod = currentMethods[0];
            } else if (currentLength > 1) {
                found.addAll(currentMethods);
            }
            matchingMethod = this.findMethodInSuperInterfaces(currentType, selector, found, matchingMethod);
            currentType = this.getJavaLangObject();
        }
        boolean isCompliant14 = this.compilerOptions().complianceLevel >= 0x300000L;
        ReferenceBinding classHierarchyStart = currentType;
        boolean mustBePublic = receiverType.isInterface();
        while (currentType != null) {
            unitScope.recordTypeReference(currentType);
            Object[] currentMethods = currentType.getMethods(selector);
            int currentLength = currentMethods.length;
            if (isCompliant14 && (mustBePublic || matchingMethod != null || found.size > 0)) {
                int i = 0;
                int l = currentLength;
                while (i < l) {
                    MethodBinding currentMethod = currentMethods[i];
                    if (mustBePublic && !currentMethod.isPublic()) {
                        --currentLength;
                        currentMethods[i] = null;
                    } else if (matchingMethod != null) {
                        if (!(!currentMethod.areParametersEqual(matchingMethod) || matchingMethod.typeVariables != TypeConstants.NoTypeVariables && invocationSite.genericTypeArguments() == null || matchingMethod.hasSubstitutedParameters() && !currentMethod.original().areParametersEqual(matchingMethod.original()))) {
                            --currentLength;
                            currentMethods[i] = null;
                        }
                    } else {
                        int j = 0;
                        int max = found.size;
                        while (j < max) {
                            if (((MethodBinding)found.elementAt(j)).areParametersEqual(currentMethod)) {
                                --currentLength;
                                currentMethods[i] = null;
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            if (currentLength == 1 && matchingMethod == null && found.size == 0) {
                matchingMethod = currentMethods[0];
            } else if (currentLength > 0) {
                int maxMethod;
                if (matchingMethod != null) {
                    found.add(matchingMethod);
                    matchingMethod = null;
                }
                if ((maxMethod = currentMethods.length) == currentLength) {
                    found.addAll(currentMethods);
                } else {
                    int i = 0;
                    int max = currentMethods.length;
                    while (i < max) {
                        Object currentMethod = currentMethods[i];
                        if (currentMethod != null) {
                            found.add(currentMethod);
                        }
                        ++i;
                    }
                }
            }
            currentType = currentType.superclass();
        }
        int foundSize = found.size;
        MethodBinding[] candidates = null;
        int candidatesCount = 0;
        boolean checkedMatchingMethod = false;
        MethodBinding problemMethod = null;
        if (foundSize > 0) {
            int i = 0;
            while (i < foundSize) {
                MethodBinding methodBinding = (MethodBinding)found.elementAt(i);
                MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
                if (compatibleMethod != null) {
                    if (compatibleMethod.isValidBinding()) {
                        switch (candidatesCount) {
                            case 0: {
                                matchingMethod = compatibleMethod;
                                checkedMatchingMethod = true;
                                break;
                            }
                            case 1: {
                                candidates = new MethodBinding[foundSize];
                                candidates[0] = matchingMethod;
                                matchingMethod = null;
                            }
                            default: {
                                candidates[candidatesCount] = compatibleMethod;
                            }
                        }
                        ++candidatesCount;
                    } else if (problemMethod == null) {
                        problemMethod = compatibleMethod;
                    }
                }
                ++i;
            }
        }
        if (candidatesCount > 0) {
            problemMethod = null;
        }
        if (matchingMethod != null) {
            MethodBinding compatibleMethod;
            if (!checkedMatchingMethod && (compatibleMethod = this.computeCompatibleMethod(matchingMethod, argumentTypes, invocationSite)) != null) {
                if (compatibleMethod.isValidBinding()) {
                    matchingMethod = compatibleMethod;
                    checkedMatchingMethod = true;
                } else {
                    problemMethod = compatibleMethod;
                }
            }
            if (checkedMatchingMethod && !matchingMethod.canBeSeenBy(receiverType, invocationSite, this)) {
                MethodBinding interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, null, found);
                if (interfaceMethod != null) {
                    return interfaceMethod;
                }
                unitScope.recordTypeReferences(matchingMethod.thrownExceptions);
                return matchingMethod;
            }
            if ((matchingMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, matchingMethod, found)) != null) {
                return matchingMethod;
            }
            return problemMethod;
        }
        if (candidatesCount == 0) {
            MethodBinding interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, matchingMethod, found);
            if (interfaceMethod != null) {
                return interfaceMethod;
            }
            if (problemMethod != null) {
                return problemMethod;
            }
            int argLength = argumentTypes.length;
            foundSize = found.size;
            int i = 0;
            while (i < foundSize) {
                block62: {
                    MethodBinding methodBinding = (MethodBinding)found.elementAt(i);
                    TypeBinding[] params = methodBinding.parameters;
                    int paramLength = params.length;
                    int a = 0;
                    block10: while (a < argLength) {
                        TypeBinding arg = argumentTypes[a];
                        int p = 0;
                        while (p < paramLength) {
                            if (params[p] != arg) {
                                ++p;
                                continue;
                            }
                            ++a;
                            continue block10;
                        }
                        break block62;
                    }
                    return methodBinding;
                }
                ++i;
            }
            if (found.size == 0) {
                return null;
            }
            return (MethodBinding)found.elementAt(0);
        }
        if (this.compilerOptions().sourceLevel >= 0x310000L) {
            int i = 0;
            while (i < candidatesCount) {
                MethodBinding current = candidates[i];
                if (current instanceof ParameterizedGenericMethodBinding) {
                    current = ((ParameterizedGenericMethodBinding)current).originalMethod;
                }
                if (current instanceof ParameterizedMethodBinding) {
                    int j = i + 1;
                    while (j < candidatesCount) {
                        MethodBinding methodBinding = current;
                        MethodBinding methodBinding2 = candidates[j];
                        if ((ReferenceBinding)Scope.declaringClass_aroundBody7$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null) == (ReferenceBinding)Scope.declaringClass_aroundBody9$advice(this, methodBinding2, OwningClassSupportForMethodBindings.aspectOf(), methodBinding2, null) && current.areParametersEqual(candidates[j])) {
                            return new ProblemMethodBinding(candidates[i].selector, candidates[i].parameters, 3);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        int visiblesCount = 0;
        int i = 0;
        while (i < candidatesCount) {
            MethodBinding methodBinding = candidates[i];
            if ((methodBinding = methodBinding.getVisibleBinding(receiverType, invocationSite, this)) != null && methodBinding.canBeSeenBy(receiverType, invocationSite, this)) {
                if (visiblesCount != i) {
                    candidates[i] = null;
                    candidates[visiblesCount] = methodBinding;
                }
                ++visiblesCount;
            }
            ++i;
        }
        if (visiblesCount == 1) {
            unitScope.recordTypeReferences(candidates[0].thrownExceptions);
            return candidates[0];
        }
        if (visiblesCount == 0) {
            MethodBinding interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, matchingMethod, found);
            if (interfaceMethod != null) {
                return interfaceMethod;
            }
            return new ProblemMethodBinding(candidates[0], candidates[0].selector, candidates[0].parameters, 2);
        }
        if (isCompliant14) {
            MethodBinding interfaceMethod;
            matchingMethod = this.mostSpecificMethodBinding(candidates, visiblesCount, argumentTypes, invocationSite);
            if (this.parameterCompatibilityLevel(matchingMethod, argumentTypes) > 0 && (interfaceMethod = this.findDefaultAbstractMethod(receiverType, selector, argumentTypes, invocationSite, classHierarchyStart, matchingMethod, new ObjectVector())) != null) {
                return interfaceMethod;
            }
            return matchingMethod;
        }
        MethodBinding methodBinding = candidates[0];
        ReferenceBinding declaringClass = (ReferenceBinding)Scope.declaringClass_aroundBody11$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null);
        return !declaringClass.isInterface() ? this.mostSpecificClassMethodBinding(candidates, visiblesCount, invocationSite) : this.mostSpecificInterfaceMethodBinding(candidates, visiblesCount, invocationSite);
    }

    public MethodBinding findMethodForArray(ArrayBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        TypeBinding leafType = receiverType.leafComponentType();
        if (leafType instanceof ReferenceBinding && !((ReferenceBinding)leafType).canBeSeenBy(this)) {
            return new ProblemMethodBinding(selector, TypeConstants.NoParameters, (ReferenceBinding)leafType, 8);
        }
        ReferenceBinding object = this.getJavaLangObject();
        MethodBinding methodBinding = object.getExactMethod(selector, argumentTypes, null);
        if (methodBinding != null) {
            if (argumentTypes == TypeConstants.NoParameters) {
                switch (selector[0]) {
                    case 'c': {
                        if (!CharOperation.equals(selector, TypeConstants.CLONE)) break;
                        return new UpdatedMethodBinding(this.compilerOptions().targetJDK >= 0x300000L ? receiverType : object, methodBinding.modifiers & 0xFFFFFFFB | 1, TypeConstants.CLONE, methodBinding.returnType, argumentTypes, null, object);
                    }
                    case 'g': {
                        if (!CharOperation.equals(selector, TypeConstants.GETCLASS) || !methodBinding.returnType.isParameterizedType()) break;
                        return ParameterizedMethodBinding.instantiateGetClass(receiverType, methodBinding, this);
                    }
                }
            }
            if (methodBinding.canBeSeenBy(receiverType, invocationSite, this)) {
                return methodBinding;
            }
        }
        if ((methodBinding = this.findMethod(object, selector, argumentTypes, invocationSite)) == null) {
            return new ProblemMethodBinding(selector, argumentTypes, 1);
        }
        if (methodBinding.isValidBinding()) {
            MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
            if (compatibleMethod == null) {
                return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 1);
            }
            if (!compatibleMethod.isValidBinding()) {
                return compatibleMethod;
            }
            methodBinding = compatibleMethod;
            if (!methodBinding.canBeSeenBy(receiverType, invocationSite, this)) {
                return new ProblemMethodBinding(methodBinding, selector, methodBinding.parameters, 2);
            }
        }
        return methodBinding;
    }

    public MethodBinding findMethodInSuperInterfaces(ReferenceBinding currentType, char[] selector, ObjectVector found, MethodBinding matchingMethod) {
        ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
            int length;
            int j;
            ReferenceBinding[] interfaces;
            ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
            int lastPosition = -1;
            if (++lastPosition == interfacesToVisit.length) {
                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
            }
            interfacesToVisit[lastPosition] = itsInterfaces;
            int i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    currentType = interfaces[j];
                    if ((currentType.tagBits & 0x800L) == 0L) {
                        currentType.tagBits |= 0x800L;
                        this.compilationUnitScope().recordTypeReference(currentType);
                        Object[] currentMethods = currentType.getMethods(selector);
                        int currentLength = currentMethods.length;
                        if (currentLength == 1 && matchingMethod == null && found.size == 0) {
                            matchingMethod = currentMethods[0];
                        } else if (currentLength > 0) {
                            if (matchingMethod != null) {
                                found.add(matchingMethod);
                                matchingMethod = null;
                            }
                            found.addAll(currentMethods);
                        }
                        itsInterfaces = currentType.superInterfaces();
                        if (itsInterfaces != TypeConstants.NoSuperInterfaces) {
                            if (++lastPosition == interfacesToVisit.length) {
                                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                            }
                            interfacesToVisit[lastPosition] = itsInterfaces;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i <= lastPosition) {
                interfaces = interfacesToVisit[i];
                j = 0;
                length = interfaces.length;
                while (j < length) {
                    interfaces[j].tagBits &= 0xFFFFFFFFFFFFF7FFL;
                    ++j;
                }
                ++i;
            }
        }
        return matchingMethod;
    }

    public ReferenceBinding findType(char[] typeName, PackageBinding declarationPackage, PackageBinding invocationPackage) {
        this.compilationUnitScope().recordReference(declarationPackage.compoundName, typeName);
        ReferenceBinding typeBinding = declarationPackage.getType(typeName);
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isValidBinding() && declarationPackage != invocationPackage && !typeBinding.canBeSeenBy(invocationPackage)) {
            return new ProblemReferenceBinding(typeName, typeBinding, 2);
        }
        return typeBinding;
    }

    public LocalVariableBinding findVariable(char[] variable) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Binding getBinding(char[] name, int mask, InvocationSite invocationSite, boolean needResolve) {
        try {
            Binding binding = null;
            Binding problemField = null;
            if ((mask & 3) != 0) {
                boolean insideStaticContext = false;
                boolean insideConstructorCall = false;
                boolean insideTypeAnnotation = false;
                Binding foundField = null;
                ProblemFieldBinding foundInsideProblem = null;
                Scope scope = this;
                int depth = 0;
                int foundDepth = 0;
                SourceTypeBinding foundActualReceiverType = null;
                block8: while (true) {
                    switch (scope.kind) {
                        case 2: {
                            MethodScope methodScope = (MethodScope)scope;
                            insideStaticContext |= methodScope.isStatic;
                            insideConstructorCall |= methodScope.isConstructorCall;
                            insideTypeAnnotation = methodScope.insideTypeAnnotation;
                        }
                        case 1: {
                            LocalVariableBinding variableBinding = scope.findVariable(name);
                            if (variableBinding == null) break;
                            if (foundField != null && foundField.isValidBinding()) {
                                Binding binding2 = foundField;
                                return new ProblemFieldBinding((FieldBinding)foundField, (ReferenceBinding)Scope.declaringClass_aroundBody13$advice(this, (FieldBinding)binding2, OwningClassSupportForFieldBindings.aspectOf(), (FieldBinding)binding2, null), name, 5);
                            }
                            if (depth <= 0) return variableBinding;
                            invocationSite.setDepth(depth);
                            return variableBinding;
                        }
                        case 3: {
                            FieldBinding fieldBinding;
                            ClassScope classScope = (ClassScope)scope;
                            SourceTypeBinding enclosingType = classScope.referenceContext.binding;
                            if (!insideTypeAnnotation && (fieldBinding = classScope.findField(enclosingType, name, invocationSite, needResolve)) != null) {
                                if (fieldBinding.problemId() == 3) {
                                    if (foundField == null) return fieldBinding;
                                    if (foundField.problemId() == 2) {
                                        return fieldBinding;
                                    }
                                    Binding binding3 = foundField;
                                    return new ProblemFieldBinding((FieldBinding)foundField, (ReferenceBinding)Scope.declaringClass_aroundBody15$advice(this, (FieldBinding)binding3, OwningClassSupportForFieldBindings.aspectOf(), (FieldBinding)binding3, null), name, 5);
                                }
                                ProblemFieldBinding insideProblem = null;
                                if (fieldBinding.isValidBinding()) {
                                    FieldBinding fieldBinding2;
                                    if (!fieldBinding.isStatic()) {
                                        if (insideConstructorCall) {
                                            FieldBinding fieldBinding3 = fieldBinding;
                                            insideProblem = new ProblemFieldBinding(fieldBinding, (ReferenceBinding)Scope.declaringClass_aroundBody17$advice(this, fieldBinding3, OwningClassSupportForFieldBindings.aspectOf(), fieldBinding3, null), name, 6);
                                        } else if (insideStaticContext) {
                                            FieldBinding fieldBinding4 = fieldBinding;
                                            insideProblem = new ProblemFieldBinding(fieldBinding, (ReferenceBinding)Scope.declaringClass_aroundBody19$advice(this, fieldBinding4, OwningClassSupportForFieldBindings.aspectOf(), fieldBinding4, null), name, 7);
                                        }
                                    }
                                    if (enclosingType == (ReferenceBinding)Scope.declaringClass_aroundBody21$advice(this, fieldBinding2 = fieldBinding, OwningClassSupportForFieldBindings.aspectOf(), fieldBinding2, null) || this.compilerOptions().complianceLevel >= 0x300000L) {
                                        if (foundField == null) {
                                            FieldBinding fieldBinding5;
                                            if (depth > 0) {
                                                invocationSite.setDepth(depth);
                                                invocationSite.setActualReceiverType(enclosingType);
                                            }
                                            if (insideProblem == null) {
                                                fieldBinding5 = fieldBinding;
                                                return fieldBinding5;
                                            }
                                            fieldBinding5 = insideProblem;
                                            return fieldBinding5;
                                        }
                                        if (foundField.isValidBinding()) {
                                            Binding binding4 = foundField;
                                            FieldBinding fieldBinding6 = fieldBinding;
                                            if ((ReferenceBinding)Scope.declaringClass_aroundBody23$advice(this, (FieldBinding)binding4, OwningClassSupportForFieldBindings.aspectOf(), (FieldBinding)binding4, null) != (ReferenceBinding)Scope.declaringClass_aroundBody25$advice(this, fieldBinding6, OwningClassSupportForFieldBindings.aspectOf(), fieldBinding6, null)) {
                                                Binding binding5 = foundField;
                                                return new ProblemFieldBinding((FieldBinding)foundField, (ReferenceBinding)Scope.declaringClass_aroundBody27$advice(this, (FieldBinding)binding5, OwningClassSupportForFieldBindings.aspectOf(), (FieldBinding)binding5, null), name, 5);
                                            }
                                        }
                                    }
                                }
                                if (foundField == null || foundField.problemId() == 2 && fieldBinding.problemId() != 2) {
                                    foundDepth = depth;
                                    foundActualReceiverType = enclosingType;
                                    foundInsideProblem = insideProblem;
                                    foundField = fieldBinding;
                                }
                            }
                            insideTypeAnnotation = false;
                            depth += classScope.addDepth();
                            insideStaticContext |= this.invocationType().isStatic();
                            MethodScope enclosingMethodScope = scope.methodScope();
                            insideConstructorCall = enclosingMethodScope == null ? false : enclosingMethodScope.isConstructorCall;
                            break;
                        }
                        case 4: {
                            break block8;
                        }
                    }
                    scope = scope.parent;
                }
                if (foundInsideProblem != null) {
                    return foundInsideProblem;
                }
                if (foundField != null) {
                    if (foundField.isValidBinding()) {
                        if (foundDepth <= 0) return foundField;
                        invocationSite.setDepth(foundDepth);
                        invocationSite.setActualReceiverType(foundActualReceiverType);
                        return foundField;
                    }
                    problemField = foundField;
                    foundField = null;
                }
                if (this.compilerOptions().sourceLevel >= 0x310000L) {
                    CompilationUnitScope unitScope = (CompilationUnitScope)scope;
                    ImportBinding[] imports = unitScope.imports;
                    if (imports != null) {
                        int i = 0;
                        int length = imports.length;
                        while (i < length) {
                            ImportBinding importBinding = imports[i];
                            if (importBinding.isStatic() && !importBinding.onDemand && CharOperation.equals(importBinding.compoundName[importBinding.compoundName.length - 1], name) && unitScope.resolveSingleImport(importBinding) != null && importBinding.resolvedImport instanceof FieldBinding) {
                                FieldBinding fieldBinding = (FieldBinding)importBinding.resolvedImport;
                                ReferenceBinding declaringClass = (ReferenceBinding)Scope.declaringClass_aroundBody29$advice(this, fieldBinding, OwningClassSupportForFieldBindings.aspectOf(), fieldBinding, null);
                                if (declaringClass.canBeSeenBy(this)) {
                                    ImportReference importReference = importBinding.reference;
                                    if (importReference != null) {
                                        importReference.used = true;
                                    }
                                    invocationSite.setActualReceiverType(declaringClass);
                                    return importBinding.resolvedImport;
                                }
                                if (problemField == null) {
                                    problemField = new ProblemFieldBinding(declaringClass, name, 8);
                                }
                            }
                            ++i;
                        }
                        boolean foundInImport = false;
                        int i2 = 0;
                        int length2 = imports.length;
                        while (i2 < length2) {
                            FieldBinding temp;
                            Binding resolvedImport;
                            ImportBinding importBinding = imports[i2];
                            if (importBinding.isStatic() && importBinding.onDemand && (resolvedImport = importBinding.resolvedImport) instanceof ReferenceBinding && (temp = this.findField((ReferenceBinding)resolvedImport, name, invocationSite, needResolve)) != null) {
                                if (!temp.isValidBinding()) {
                                    if (problemField == null) {
                                        problemField = temp;
                                    }
                                } else if (temp.isStatic()) {
                                    ImportReference importReference = importBinding.reference;
                                    if (importReference != null) {
                                        importReference.used = true;
                                    }
                                    if (foundInImport) {
                                        return new ProblemReferenceBinding(name, null, 3);
                                    }
                                    foundField = temp;
                                    foundInImport = true;
                                }
                            }
                            ++i2;
                        }
                        if (foundField != null) {
                            Binding binding6 = foundField;
                            invocationSite.setActualReceiverType((ReferenceBinding)Scope.declaringClass_aroundBody31$advice(this, (FieldBinding)binding6, OwningClassSupportForFieldBindings.aspectOf(), (FieldBinding)binding6, null));
                            return foundField;
                        }
                    }
                }
            }
            if ((mask & 4) != 0) {
                binding = Scope.getBaseType(name);
                if (binding != null) {
                    return binding;
                }
                binding = this.getTypeOrPackage(name, (mask & 0x10) == 0 ? 4 : 20);
                if (binding.isValidBinding()) return binding;
                if (mask == 4) {
                    return binding;
                }
            } else if ((mask & 0x10) != 0) {
                this.compilationUnitScope().recordSimpleReference(name);
                binding = this.environment().getTopLevelPackage(name);
                if (binding != null) {
                    return binding;
                }
            }
            if (problemField == null) return new ProblemBinding(name, (ReferenceBinding)this.enclosingSourceType(), 1);
            return problemField;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    public MethodBinding getConstructor(ReferenceBinding receiverType, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        try {
            CompilationUnitScope unitScope = this.compilationUnitScope();
            unitScope.recordTypeReference(receiverType);
            unitScope.recordTypeReferences(argumentTypes);
            MethodBinding methodBinding = receiverType.getExactConstructor(argumentTypes);
            if (methodBinding != null) {
                methodBinding = methodBinding.getVisibleBinding(invocationSite, this);
            }
            if (methodBinding != null && methodBinding.canBeSeenBy(invocationSite, this)) {
                if (invocationSite.genericTypeArguments() != null) {
                    methodBinding = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
                }
                return methodBinding;
            }
            MethodBinding[] methods = receiverType.getMethods(TypeConstants.INIT);
            if (methods == TypeConstants.NoMethods) {
                return new ProblemMethodBinding(TypeConstants.INIT, argumentTypes, 1);
            }
            MethodBinding[] compatible = new MethodBinding[methods.length];
            int compatibleIndex = 0;
            MethodBinding problemMethod = null;
            int i = 0;
            int length = methods.length;
            while (i < length) {
                MethodBinding compatibleMethod = this.computeCompatibleMethod(methods[i], argumentTypes, invocationSite);
                if (compatibleMethod != null) {
                    if (compatibleMethod.isValidBinding()) {
                        compatible[compatibleIndex++] = compatibleMethod;
                    } else if (problemMethod == null) {
                        problemMethod = compatibleMethod;
                    }
                }
                ++i;
            }
            if (compatibleIndex == 0) {
                if (problemMethod == null) {
                    return new ProblemMethodBinding(TypeConstants.INIT, argumentTypes, 1);
                }
                return problemMethod;
            }
            MethodBinding[] visible = new MethodBinding[compatibleIndex];
            int visibleIndex = 0;
            int i2 = 0;
            while (i2 < compatibleIndex) {
                MethodBinding method = compatible[i2];
                if ((method = method.getVisibleBinding(invocationSite, this)) != null && method.canBeSeenBy(invocationSite, this)) {
                    visible[visibleIndex++] = method;
                }
                ++i2;
            }
            if (visibleIndex == 1) {
                return visible[0];
            }
            if (visibleIndex == 0) {
                return new ProblemMethodBinding(compatible[0], TypeConstants.INIT, compatible[0].parameters, 2);
            }
            return this.mostSpecificMethodBinding(visible, visibleIndex, argumentTypes, invocationSite);
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    public final PackageBinding getCurrentPackage() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).fPackage;
    }

    public int getDeclarationModifiers() {
        switch (this.kind) {
            case 1: 
            case 2: {
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding context = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                    if (context == null) break;
                    return context.modifiers;
                }
                SourceTypeBinding type = ((BlockScope)this).referenceType().binding;
                if (methodScope.initializedField != null) {
                    return methodScope.initializedField.modifiers;
                }
                if (type == null) break;
                return type.modifiers;
            }
            case 3: {
                SourceTypeBinding context = ((ClassScope)this).referenceType().binding;
                if (context == null) break;
                return context.modifiers;
            }
        }
        return -1;
    }

    public FieldBinding getField(TypeBinding receiverType, char[] fieldName, InvocationSite invocationSite) {
        try {
            FieldBinding field = this.findField(receiverType, fieldName, invocationSite, true);
            if (field != null) {
                return field;
            }
            return new ProblemFieldBinding(receiverType instanceof ReferenceBinding ? (ReferenceBinding)receiverType : null, fieldName, 1);
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public MethodBinding getImplicitMethod(char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        block58: {
            Binding foundMethod;
            block59: {
                boolean insideStaticContext = false;
                boolean insideConstructorCall = false;
                boolean insideTypeAnnotation = false;
                foundMethod = null;
                MethodBinding foundFuzzyProblem = null;
                ProblemMethodBinding foundInsideProblem = null;
                Scope scope = this;
                int depth = 0;
                block5: while (true) {
                    switch (scope.kind) {
                        case 2: {
                            MethodScope methodScope = (MethodScope)scope;
                            insideStaticContext |= methodScope.isStatic;
                            insideConstructorCall |= methodScope.isConstructorCall;
                            insideTypeAnnotation = methodScope.insideTypeAnnotation;
                            break;
                        }
                        case 3: {
                            ClassScope classScope = (ClassScope)scope;
                            SourceTypeBinding receiverType = classScope.referenceContext.binding;
                            if (!insideTypeAnnotation) {
                                MethodBinding methodBinding;
                                boolean isExactMatch = true;
                                MethodBinding methodBinding2 = methodBinding = foundMethod == null ? classScope.findExactMethod(receiverType, selector, argumentTypes, invocationSite) : classScope.findExactMethod(receiverType, ((MethodBinding)foundMethod).selector, ((MethodBinding)foundMethod).parameters, invocationSite);
                                if (methodBinding == null) {
                                    isExactMatch = false;
                                    methodBinding = classScope.findMethod(receiverType, selector, argumentTypes, invocationSite);
                                }
                                if (methodBinding != null) {
                                    if (methodBinding.problemId() == 3) {
                                        if (foundMethod != null && foundMethod.problemId() != 2) {
                                            return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 5);
                                        }
                                        return methodBinding;
                                    }
                                    MethodBinding fuzzyProblem = null;
                                    ProblemMethodBinding insideProblem = null;
                                    if (methodBinding.isValidBinding()) {
                                        MethodBinding methodBinding3;
                                        if (!isExactMatch) {
                                            MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
                                            if (compatibleMethod == null) {
                                                if (foundMethod == null || foundMethod.problemId() == 2) {
                                                    return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 1);
                                                }
                                                fuzzyProblem = new ProblemMethodBinding(methodBinding, selector, methodBinding.parameters, 5);
                                            } else if (!compatibleMethod.isValidBinding()) {
                                                fuzzyProblem = compatibleMethod;
                                            } else {
                                                methodBinding = compatibleMethod;
                                                if (!methodBinding.canBeSeenBy(receiverType, invocationSite, classScope)) {
                                                    MethodBinding visMethodBinding = methodBinding.getVisibleBinding(invocationSite, this);
                                                    if (visMethodBinding == null) {
                                                        fuzzyProblem = new ProblemMethodBinding(methodBinding, selector, methodBinding.parameters, 2);
                                                    } else {
                                                        methodBinding = visMethodBinding;
                                                    }
                                                }
                                            }
                                        }
                                        if (fuzzyProblem == null && !methodBinding.isStatic()) {
                                            if (insideConstructorCall) {
                                                insideProblem = new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, 6);
                                            } else if (insideStaticContext) {
                                                insideProblem = new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, 7);
                                            }
                                        }
                                        if (receiverType == (ReferenceBinding)Scope.declaringClass_aroundBody33$advice(this, methodBinding3 = methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding3, null) || receiverType.getMethods(selector) != TypeConstants.NoMethods || (fuzzyProblem == null || fuzzyProblem.problemId() != 2) && this.compilerOptions().complianceLevel >= 0x300000L) {
                                            if (foundMethod == null) {
                                                if (depth > 0) {
                                                    invocationSite.setDepth(depth);
                                                    invocationSite.setActualReceiverType(receiverType);
                                                }
                                                if (fuzzyProblem != null) {
                                                    return fuzzyProblem;
                                                }
                                                if (insideProblem != null) {
                                                    return insideProblem;
                                                }
                                                return methodBinding;
                                            }
                                            Binding binding = foundMethod;
                                            MethodBinding methodBinding4 = methodBinding;
                                            if ((ReferenceBinding)Scope.declaringClass_aroundBody35$advice(this, (MethodBinding)binding, OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)binding, null) != (ReferenceBinding)Scope.declaringClass_aroundBody37$advice(this, methodBinding4, OwningClassSupportForMethodBindings.aspectOf(), methodBinding4, null)) {
                                                return new ProblemMethodBinding(methodBinding, methodBinding.selector, methodBinding.parameters, 5);
                                            }
                                        }
                                    }
                                    if (foundMethod == null || foundMethod.problemId() == 2 && methodBinding.problemId() != 2) {
                                        if (depth > 0) {
                                            invocationSite.setDepth(depth);
                                            invocationSite.setActualReceiverType(receiverType);
                                        }
                                        foundFuzzyProblem = fuzzyProblem;
                                        foundInsideProblem = insideProblem;
                                        if (fuzzyProblem == null) {
                                            foundMethod = methodBinding;
                                        }
                                    }
                                }
                            }
                            insideTypeAnnotation = false;
                            ++depth;
                            insideStaticContext |= receiverType.isStatic();
                            MethodScope enclosingMethodScope = scope.methodScope();
                            insideConstructorCall = enclosingMethodScope == null ? false : enclosingMethodScope.isConstructorCall;
                            break;
                        }
                        case 4: {
                            break block5;
                        }
                    }
                    scope = scope.parent;
                }
                if (foundFuzzyProblem != null) {
                    return foundFuzzyProblem;
                }
                if (foundInsideProblem != null) {
                    return foundInsideProblem;
                }
                if (foundMethod != null) {
                    return foundMethod;
                }
                if (!insideStaticContext || this.compilerOptions().sourceLevel < 0x310000L) break block58;
                CompilationUnitScope unitScope = (CompilationUnitScope)scope;
                ImportBinding[] imports = unitScope.imports;
                if (imports == null) break block59;
                MethodBinding[] visible = null;
                boolean skipOnDemand = false;
                int i = 0;
                int length = imports.length;
                while (i < length) {
                    block57: {
                        Binding possible;
                        block61: {
                            MethodBinding compatibleMethod;
                            block62: {
                                ImportBinding importBinding;
                                block63: {
                                    block60: {
                                        importBinding = imports[i];
                                        if (!importBinding.isStatic()) break block57;
                                        Binding resolvedImport = importBinding.resolvedImport;
                                        possible = null;
                                        if (importBinding.onDemand) {
                                            if (!skipOnDemand && resolvedImport instanceof ReferenceBinding) {
                                                possible = this.findMethod((ReferenceBinding)resolvedImport, selector, argumentTypes, invocationSite);
                                            }
                                        } else if (resolvedImport instanceof MethodBinding) {
                                            MethodBinding staticMethod = (MethodBinding)resolvedImport;
                                            if (CharOperation.equals(staticMethod.selector, selector)) {
                                                MethodBinding methodBinding = staticMethod;
                                                possible = this.findMethod((ReferenceBinding)Scope.declaringClass_aroundBody39$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null), selector, argumentTypes, invocationSite);
                                            }
                                        } else if (resolvedImport instanceof FieldBinding) {
                                            char[][] importName;
                                            TypeBinding referencedType;
                                            FieldBinding staticField = (FieldBinding)resolvedImport;
                                            if (CharOperation.equals(staticField.name, selector) && (referencedType = this.getType(importName = importBinding.reference.tokens, importName.length - 1)) != null) {
                                                possible = this.findMethod((ReferenceBinding)referencedType, selector, argumentTypes, invocationSite);
                                            }
                                        }
                                        if (possible == null || possible == foundMethod) break block57;
                                        if (possible.isValidBinding()) break block60;
                                        if (foundMethod == null) {
                                            foundMethod = possible;
                                        }
                                        break block57;
                                    }
                                    if (!((MethodBinding)possible).isStatic()) break block57;
                                    compatibleMethod = this.computeCompatibleMethod((MethodBinding)possible, argumentTypes, invocationSite);
                                    if (compatibleMethod == null) break block61;
                                    if (!compatibleMethod.isValidBinding()) break block57;
                                    if (!compatibleMethod.canBeSeenBy(unitScope.fPackage)) break block62;
                                    ImportReference importReference = importBinding.reference;
                                    if (importReference != null) {
                                        importReference.used = true;
                                    }
                                    if (foundMethod != null && foundMethod.isValidBinding()) break block63;
                                    foundMethod = compatibleMethod;
                                    if (!importBinding.onDemand && foundMethod.isValidBinding()) {
                                        skipOnDemand = true;
                                    }
                                    break block57;
                                }
                                if (!skipOnDemand && !importBinding.onDemand) {
                                    visible = null;
                                    foundMethod = compatibleMethod;
                                    skipOnDemand = true;
                                    break block57;
                                } else if (visible == null) {
                                    visible = new MethodBinding[]{foundMethod, compatibleMethod};
                                    break block57;
                                } else {
                                    int visibleLength = visible.length;
                                    MethodBinding[] temp = new MethodBinding[visibleLength + 1];
                                    System.arraycopy(visible, 0, temp, 0, visibleLength);
                                    temp[visibleLength] = compatibleMethod;
                                    visible = temp;
                                }
                                break block57;
                            }
                            if (foundMethod == null) {
                                foundMethod = new ProblemMethodBinding(compatibleMethod, selector, compatibleMethod.parameters, 2);
                            }
                            break block57;
                        }
                        if (foundMethod == null) {
                            foundMethod = new ProblemMethodBinding((MethodBinding)possible, selector, argumentTypes, 1);
                        }
                    }
                    ++i;
                }
                if (visible != null) {
                    foundMethod = this.mostSpecificMethodBinding(visible, visible.length, argumentTypes, invocationSite);
                }
            }
            if (foundMethod != null) {
                Binding binding = foundMethod;
                invocationSite.setActualReceiverType((ReferenceBinding)Scope.declaringClass_aroundBody41$advice(this, (MethodBinding)binding, OwningClassSupportForMethodBindings.aspectOf(), (MethodBinding)binding, null));
                return foundMethod;
            }
        }
        return new ProblemMethodBinding(selector, argumentTypes, 1);
    }

    public final ReferenceBinding getJavaIoSerializable() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_IO_SERIALIZABLE);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_IO_SERIALIZABLE);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_IO_SERIALIZABLE, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangAnnotationAnnotation() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangAssertionError() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_ASSERTIONERROR);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_ASSERTIONERROR);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_ASSERTIONERROR, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangClass() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_CLASS);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_CLASS);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_CLASS, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangCloneable() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_CLONEABLE);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_CLONEABLE);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_CLONEABLE, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangEnum() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_ENUM);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_ENUM);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_ENUM, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangIterable() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_ITERABLE);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_ITERABLE);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_ITERABLE, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangObject() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_OBJECT);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_OBJECT);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_OBJECT, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangString() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_STRING);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_STRING);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_STRING, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaLangThrowable() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_LANG_THROWABLE);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_LANG_THROWABLE);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_LANG_THROWABLE, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getJavaUtilIterator() {
        this.compilationUnitScope().recordQualifiedReference(TypeConstants.JAVA_UTIL_ITERATOR);
        ReferenceBinding type = this.environment().getType(TypeConstants.JAVA_UTIL_ITERATOR);
        if (type != null) {
            return type;
        }
        this.problemReporter().isClassPathCorrect(TypeConstants.JAVA_UTIL_ITERATOR, this.referenceCompilationUnit());
        return null;
    }

    public final ReferenceBinding getMemberType(char[] typeName, ReferenceBinding enclosingType) {
        ReferenceBinding memberType = this.findMemberType(typeName, enclosingType);
        if (memberType != null) {
            return memberType;
        }
        return new ProblemReferenceBinding(typeName, null, 1);
    }

    public MethodBinding getMethod(TypeBinding receiverType, char[] selector, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        try {
            switch (receiverType.kind()) {
                case 132: {
                    return new ProblemMethodBinding(selector, argumentTypes, 1);
                }
                case 68: {
                    this.compilationUnitScope().recordTypeReference(receiverType);
                    return this.findMethodForArray((ArrayBinding)receiverType, selector, argumentTypes, invocationSite);
                }
            }
            this.compilationUnitScope().recordTypeReference(receiverType);
            ReferenceBinding currentType = (ReferenceBinding)receiverType;
            if (!currentType.canBeSeenBy(this)) {
                return new ProblemMethodBinding(selector, argumentTypes, 8);
            }
            MethodBinding methodBinding = this.findExactMethod(currentType, selector, argumentTypes, invocationSite);
            if (methodBinding != null) {
                return methodBinding;
            }
            methodBinding = this.findMethod(currentType, selector, argumentTypes, invocationSite);
            if (methodBinding == null) {
                return new ProblemMethodBinding(selector, argumentTypes, 1);
            }
            if (methodBinding.isValidBinding()) {
                MethodBinding compatibleMethod = this.computeCompatibleMethod(methodBinding, argumentTypes, invocationSite);
                if (compatibleMethod == null) {
                    return new ProblemMethodBinding(methodBinding, selector, argumentTypes, 1);
                }
                if (!compatibleMethod.isValidBinding()) {
                    return compatibleMethod;
                }
                methodBinding = compatibleMethod;
                if (!methodBinding.canBeSeenBy(currentType, invocationSite, this)) {
                    MethodBinding visMethodBinding = methodBinding.getVisibleBinding(invocationSite, this);
                    if (visMethodBinding == null) {
                        return new ProblemMethodBinding(methodBinding, selector, methodBinding.parameters, 2);
                    }
                    methodBinding = visMethodBinding;
                }
            }
            if (receiverType.id != 1 && argumentTypes == TypeConstants.NoParameters && CharOperation.equals(selector, TypeConstants.GETCLASS) && methodBinding.returnType.isParameterizedType()) {
                return ParameterizedMethodBinding.instantiateGetClass(receiverType, methodBinding, this);
            }
            return methodBinding;
        }
        catch (AbortCompilation e) {
            e.updateContext(invocationSite, this.referenceCompilationUnit().compilationResult);
            throw e;
        }
    }

    public final Binding getPackage(char[][] compoundName) {
        this.compilationUnitScope().recordQualifiedReference(compoundName);
        Binding binding = this.getTypeOrPackage(compoundName[0], 20);
        if (binding == null) {
            return new ProblemReferenceBinding(compoundName[0], null, 1);
        }
        if (!binding.isValidBinding()) {
            return (ReferenceBinding)binding;
        }
        if (!(binding instanceof PackageBinding)) {
            return null;
        }
        int currentIndex = 1;
        PackageBinding packageBinding = (PackageBinding)binding;
        while (currentIndex < compoundName.length) {
            if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
            }
            if (!binding.isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, binding.problemId());
            }
            if (!(binding instanceof PackageBinding)) {
                return packageBinding;
            }
            packageBinding = (PackageBinding)binding;
        }
        return new ProblemReferenceBinding(compoundName, null, 1);
    }

    public final TypeBinding getType(char[] name) {
        TypeBinding binding = Scope.getBaseType(name);
        if (binding != null) {
            return binding;
        }
        return (ReferenceBinding)this.getTypeOrPackage(name, 4);
    }

    public final TypeBinding getType(char[] name, PackageBinding packageBinding) {
        if (packageBinding == null) {
            return this.getType(name);
        }
        Binding binding = packageBinding.getTypeOrPackage(name);
        if (binding == null) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, name), null, 1);
        }
        if (!binding.isValidBinding()) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, name), null, binding.problemId());
        }
        ReferenceBinding typeBinding = (ReferenceBinding)binding;
        if (!typeBinding.canBeSeenBy(this)) {
            return new ProblemReferenceBinding(CharOperation.arrayConcat(packageBinding.compoundName, name), typeBinding, 2);
        }
        return typeBinding;
    }

    /*
     * Unable to fully structure code
     */
    public final TypeBinding getType(char[][] compoundName, int typeNameLength) {
        if (typeNameLength == 1 && (binding = Scope.getBaseType(compoundName[0])) != null) {
            return binding;
        }
        unitScope = this.compilationUnitScope();
        unitScope.recordQualifiedReference(compoundName);
        binding = this.getTypeOrPackage(compoundName[0], typeNameLength == 1 ? 4 : 20);
        if (binding == null) {
            return new ProblemReferenceBinding(compoundName[0], null, 1);
        }
        if (!binding.isValidBinding()) {
            return (ReferenceBinding)binding;
        }
        currentIndex = 1;
        checkVisibility = false;
        if (binding instanceof PackageBinding) {
            packageBinding = (PackageBinding)binding;
            while (currentIndex < typeNameLength) {
                if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
                }
                if (!binding.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, binding.problemId());
                }
                if (!(binding instanceof PackageBinding)) break;
                packageBinding = (PackageBinding)binding;
            }
            if (binding instanceof PackageBinding) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
            }
            checkVisibility = true;
        }
        typeBinding = (ReferenceBinding)binding;
        unitScope.recordTypeReference(typeBinding);
        if (!checkVisibility || typeBinding.canBeSeenBy(this)) ** GOTO lbl34
        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 2);
lbl-1000:
        // 1 sources

        {
            if ((typeBinding = this.getMemberType(compoundName[currentIndex++], typeBinding)).isValidBinding()) continue;
            if (typeBinding instanceof ProblemReferenceBinding) {
                problemBinding = (ProblemReferenceBinding)typeBinding;
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), problemBinding.closestMatch, typeBinding.problemId());
            }
            return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, typeBinding.problemId());
lbl34:
            // 2 sources

            ** while (currentIndex < typeNameLength)
        }
lbl35:
        // 1 sources

        return typeBinding;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Binding getTypeOrPackage(char[] name, int mask) {
        PackageBinding packageBinding;
        Binding binding;
        Scope scope = this;
        Binding foundType = null;
        boolean insideStaticContext = false;
        boolean insideTypeAnnotation = false;
        if ((mask & 4) == 0) {
            Scope next = scope;
            while ((next = scope.parent) != null) {
                scope = next;
            }
        } else {
            block7: while (true) {
                switch (scope.kind) {
                    case 2: {
                        TypeVariableBinding typeVariable;
                        MethodScope methodScope = (MethodScope)scope;
                        AbstractMethodDeclaration methodDecl = methodScope.referenceMethod();
                        if (methodDecl != null && methodDecl.binding != null && (typeVariable = methodDecl.binding.getTypeVariable(name)) != null) {
                            return typeVariable;
                        }
                        insideStaticContext |= methodScope.isStatic;
                        insideTypeAnnotation = methodScope.insideTypeAnnotation;
                    }
                    case 1: {
                        ReferenceBinding localType = ((BlockScope)scope).findLocalType(name);
                        if (localType == null) break;
                        if (foundType != null && foundType != localType) {
                            return new ProblemReferenceBinding(name, (ReferenceBinding)foundType, 5);
                        }
                        return localType;
                    }
                    case 3: {
                        ReferenceBinding memberType;
                        TypeVariableBinding typeVariable;
                        SourceTypeBinding sourceType = ((ClassScope)scope).referenceContext.binding;
                        if (scope == this && sourceType.isHierarchyBeingConnected()) {
                            typeVariable = sourceType.getTypeVariable(name);
                            if (typeVariable != null) {
                                return typeVariable;
                            }
                            if (CharOperation.equals(name, sourceType.sourceName)) {
                                return sourceType;
                            }
                            insideStaticContext |= sourceType.isStatic();
                            break;
                        }
                        typeVariable = scope.findTypeVariable(name, sourceType);
                        if (typeVariable != null) {
                            if (insideStaticContext) {
                                return new ProblemReferenceBinding(name, (ReferenceBinding)typeVariable, 7);
                            }
                            return typeVariable;
                        }
                        if (!insideTypeAnnotation && (memberType = this.findMemberType(name, sourceType)) != null) {
                            if (memberType.problemId() == 3) {
                                if (foundType != null && foundType.problemId() != 2) {
                                    return new ProblemReferenceBinding(name, (ReferenceBinding)foundType, 5);
                                }
                                return memberType;
                            }
                            if (memberType.isValidBinding() && (sourceType == memberType.enclosingType() || this.compilerOptions().complianceLevel >= 0x300000L)) {
                                if (insideStaticContext && !memberType.isStatic() && sourceType.isGenericType()) {
                                    return new ProblemReferenceBinding(name, memberType, 7);
                                }
                                if (foundType == null) {
                                    return memberType;
                                }
                                if (foundType.isValidBinding() && foundType != memberType) {
                                    return new ProblemReferenceBinding(name, (ReferenceBinding)foundType, 5);
                                }
                            }
                            if (foundType == null || foundType.problemId() == 2 && memberType.problemId() != 2) {
                                foundType = memberType;
                            }
                        }
                        insideTypeAnnotation = false;
                        insideStaticContext |= sourceType.isStatic();
                        if (!CharOperation.equals(sourceType.sourceName, name)) break;
                        if (foundType != null && foundType != sourceType && foundType.problemId() != 2) {
                            return new ProblemReferenceBinding(name, (ReferenceBinding)foundType, 5);
                        }
                        return sourceType;
                    }
                    case 4: {
                        break block7;
                    }
                }
                scope = scope.parent;
            }
            if (foundType != null && foundType.problemId() != 2) {
                return foundType;
            }
        }
        CompilationUnitScope unitScope = (CompilationUnitScope)scope;
        HashtableOfObject typeOrPackageCache = unitScope.typeOrPackageCache;
        if (typeOrPackageCache != null && (binding = (Binding)typeOrPackageCache.get(name)) != null) {
            if (binding instanceof ImportBinding) {
                ImportReference importReference = ((ImportBinding)binding).reference;
                if (importReference != null) {
                    importReference.used = true;
                }
                if (binding instanceof ImportConflictBinding) {
                    binding = ((ImportConflictBinding)binding).conflictingTypeBinding;
                    typeOrPackageCache.put(name, binding);
                } else {
                    binding = ((ImportBinding)binding).resolvedImport;
                    typeOrPackageCache.put(name, binding);
                }
            }
            if ((mask & 4) != 0) {
                if (foundType != null && foundType.problemId() != 2 && binding.problemId() != 3) {
                    return foundType;
                }
                if (binding instanceof ReferenceBinding) {
                    return binding;
                }
            }
            if ((mask & 0x10) != 0 && binding instanceof PackageBinding) {
                return binding;
            }
        }
        if ((mask & 4) != 0) {
            ImportBinding[] imports = unitScope.imports;
            if (imports != null && typeOrPackageCache == null) {
                int i = 0;
                int length = imports.length;
                while (i < length) {
                    Binding resolvedImport;
                    ImportBinding importBinding = imports[i];
                    if (!importBinding.onDemand && CharOperation.equals(importBinding.compoundName[importBinding.compoundName.length - 1], name) && (resolvedImport = unitScope.resolveSingleImport(importBinding)) != null && (!(resolvedImport instanceof MethodBinding) || (resolvedImport = (ReferenceBinding)this.getType(importBinding.compoundName, importBinding.compoundName.length)).isValidBinding()) && resolvedImport instanceof TypeBinding) {
                        ImportReference importReference = importBinding.reference;
                        if (importReference != null) {
                            importReference.used = true;
                        }
                        return resolvedImport;
                    }
                    ++i;
                }
            }
            PackageBinding currentPackage = unitScope.fPackage;
            unitScope.recordReference(currentPackage.compoundName, name);
            Binding binding2 = currentPackage.getTypeOrPackage(name);
            if (binding2 instanceof ReferenceBinding) {
                if (typeOrPackageCache != null) {
                    typeOrPackageCache.put(name, binding2);
                }
                return binding2;
            }
            if (imports != null) {
                boolean foundInImport = false;
                ReferenceBinding type = null;
                int i = 0;
                int length = imports.length;
                while (i < length) {
                    ImportBinding someImport = imports[i];
                    if (someImport.onDemand) {
                        Binding resolvedImport = someImport.resolvedImport;
                        ReferenceBinding temp = null;
                        if (resolvedImport instanceof PackageBinding) {
                            temp = this.findType(name, (PackageBinding)resolvedImport, currentPackage);
                        } else if (someImport.isStatic()) {
                            temp = this.findMemberType(name, (ReferenceBinding)resolvedImport);
                            if (temp != null && !temp.isStatic()) {
                                temp = null;
                            }
                        } else {
                            temp = this.findDirectMemberType(name, (ReferenceBinding)resolvedImport);
                        }
                        if (temp != type && temp != null) {
                            if (temp.isValidBinding()) {
                                ImportReference importReference = someImport.reference;
                                if (importReference != null) {
                                    importReference.used = true;
                                }
                                if (foundInImport) {
                                    temp = new ProblemReferenceBinding(name, null, 3);
                                    if (typeOrPackageCache != null) {
                                        typeOrPackageCache.put(name, temp);
                                    }
                                    return temp;
                                }
                                type = temp;
                                foundInImport = true;
                            } else if (foundType == null) {
                                foundType = temp;
                            }
                        }
                    }
                    ++i;
                }
                if (type != null) {
                    if (typeOrPackageCache != null) {
                        typeOrPackageCache.put(name, type);
                    }
                    return type;
                }
            }
        }
        unitScope.recordSimpleReference(name);
        if ((mask & 0x10) != 0 && (packageBinding = unitScope.environment.getTopLevelPackage(name)) != null) {
            if (typeOrPackageCache != null) {
                typeOrPackageCache.put(name, packageBinding);
            }
            return packageBinding;
        }
        if (foundType == null) {
            foundType = new ProblemReferenceBinding(name, null, 1);
            if (typeOrPackageCache != null && (mask & 0x10) != 0) {
                typeOrPackageCache.put(name, foundType);
            }
        }
        return foundType;
    }

    /*
     * Unable to fully structure code
     */
    public final Binding getTypeOrPackage(char[][] compoundName) {
        nameLength = compoundName.length;
        if (nameLength == 1 && (binding = Scope.getBaseType(compoundName[0])) != null) {
            return binding;
        }
        binding = this.getTypeOrPackage(compoundName[0], 20);
        if (!binding.isValidBinding()) {
            return binding;
        }
        currentIndex = 1;
        checkVisibility = false;
        if (binding instanceof PackageBinding) {
            packageBinding = (PackageBinding)binding;
            while (currentIndex < nameLength) {
                if ((binding = packageBinding.getTypeOrPackage(compoundName[currentIndex++])) == null) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, 1);
                }
                if (!binding.isValidBinding()) {
                    return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, binding.problemId());
                }
                if (!(binding instanceof PackageBinding)) break;
                packageBinding = (PackageBinding)binding;
            }
            if (binding instanceof PackageBinding) {
                return binding;
            }
            checkVisibility = true;
        }
        typeBinding = (ReferenceBinding)binding;
        qualifiedType = (ReferenceBinding)this.environment().convertToRawType(typeBinding);
        if (!checkVisibility || typeBinding.canBeSeenBy(this)) ** GOTO lbl32
        return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), typeBinding, 2);
lbl-1000:
        // 1 sources

        {
            if (!(typeBinding = this.getMemberType(compoundName[currentIndex++], typeBinding)).isValidBinding()) {
                return new ProblemReferenceBinding(CharOperation.subarray(compoundName, 0, currentIndex), null, typeBinding.problemId());
            }
            if (typeBinding.isGenericType()) {
                qualifiedType = this.environment().createRawType(typeBinding, qualifiedType);
                continue;
            }
            v0 = qualifiedType = qualifiedType != null && (qualifiedType.isRawType() != false || qualifiedType.isParameterizedType() != false) ? this.environment().createParameterizedType(typeBinding, null, qualifiedType) : typeBinding;
lbl32:
            // 3 sources

            ** while (currentIndex < nameLength)
        }
lbl33:
        // 1 sources

        return qualifiedType;
    }

    public static TypeBinding[] greaterLowerBound(TypeBinding[] types) {
        if (types == null) {
            return null;
        }
        int length = types.length;
        if (length == 0) {
            return null;
        }
        TypeBinding[] result = types;
        int removed = 0;
        int i = 0;
        while (i < length) {
            TypeBinding iType = result[i];
            if (iType != null) {
                int j = 0;
                while (j < length) {
                    TypeBinding jType;
                    if (i != j && (jType = result[j]) != null && iType.isCompatibleWith(jType)) {
                        if (result == types) {
                            TypeBinding[] typeBindingArray = result;
                            result = new TypeBinding[length];
                            System.arraycopy(typeBindingArray, 0, result, 0, length);
                        }
                        result[j] = null;
                        ++removed;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (removed == 0) {
            return result;
        }
        if (length == removed) {
            return null;
        }
        TypeBinding[] trimmedResult = new TypeBinding[length - removed];
        int i2 = 0;
        int index = 0;
        while (i2 < length) {
            TypeBinding iType = result[i2];
            if (iType != null) {
                trimmedResult[index++] = iType;
            }
            ++i2;
        }
        return trimmedResult;
    }

    public static ReferenceBinding[] greaterLowerBound(ReferenceBinding[] types) {
        if (types == null) {
            return null;
        }
        int length = types.length;
        if (length == 0) {
            return null;
        }
        ReferenceBinding[] result = types;
        int removed = 0;
        int i = 0;
        while (i < length) {
            ReferenceBinding iType = result[i];
            if (iType != null) {
                int j = 0;
                while (j < length) {
                    ReferenceBinding jType;
                    if (i != j && (jType = result[j]) != null && iType.isCompatibleWith(jType)) {
                        if (result == types) {
                            ReferenceBinding[] referenceBindingArray = result;
                            result = new ReferenceBinding[length];
                            System.arraycopy(referenceBindingArray, 0, result, 0, length);
                        }
                        result[j] = null;
                        ++removed;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (removed == 0) {
            return result;
        }
        if (length == removed) {
            return null;
        }
        ReferenceBinding[] trimmedResult = new ReferenceBinding[length - removed];
        int i2 = 0;
        int index = 0;
        while (i2 < length) {
            ReferenceBinding iType = result[i2];
            if (iType != null) {
                trimmedResult[index++] = iType;
            }
            ++i2;
        }
        return trimmedResult;
    }

    public CaseStatement innermostSwitchCase() {
        Scope scope = this;
        do {
            if (!(scope instanceof BlockScope)) continue;
            return ((BlockScope)scope).enclosingCase;
        } while ((scope = scope.parent) != null);
        return null;
    }

    public boolean isBoxingCompatibleWith(TypeBinding expressionType, TypeBinding targetType) {
        LookupEnvironment environment = this.environment();
        if (environment.globalOptions.sourceLevel < 0x310000L || expressionType.isBaseType() == targetType.isBaseType()) {
            return false;
        }
        TypeBinding convertedType = environment.computeBoxingType(expressionType);
        return convertedType == targetType || convertedType.isCompatibleWith(targetType);
    }

    public final boolean isDefinedInField(FieldBinding field) {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            MethodScope methodScope = (MethodScope)scope;
            if (methodScope.initializedField != field) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInMethod(MethodBinding method) {
        Scope scope = this;
        do {
            ReferenceContext refContext;
            if (!(scope instanceof MethodScope) || !((refContext = ((MethodScope)scope).referenceContext) instanceof AbstractMethodDeclaration) || ((AbstractMethodDeclaration)refContext).binding != method) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public final boolean isDefinedInSameUnit(ReferenceBinding type) {
        Scope scope;
        ReferenceBinding enclosingType = type;
        while ((type = enclosingType.enclosingType()) != null) {
            enclosingType = type;
        }
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        SourceTypeBinding[] topLevelTypes = ((CompilationUnitScope)unitScope).topLevelTypes;
        int i = topLevelTypes.length;
        while (--i >= 0) {
            if (topLevelTypes[i] != enclosingType) continue;
            return true;
        }
        return false;
    }

    public final boolean isDefinedInType(ReferenceBinding type) {
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope) || ((ClassScope)scope).referenceContext.binding != type) continue;
            return true;
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideCase(CaseStatement caseStatement) {
        Scope scope = this;
        do {
            switch (scope.kind) {
                case 1: {
                    if (((BlockScope)scope).enclosingCase != caseStatement) break;
                    return true;
                }
            }
        } while ((scope = scope.parent) != null);
        return false;
    }

    public boolean isInsideDeprecatedCode() {
        switch (this.kind) {
            case 1: 
            case 2: {
                MethodScope methodScope = this.methodScope();
                if (!methodScope.isInsideInitializer()) {
                    MethodBinding context = ((AbstractMethodDeclaration)methodScope.referenceContext).binding;
                    if (context == null || !context.isViewedAsDeprecated()) break;
                    return true;
                }
                SourceTypeBinding type = ((BlockScope)this).referenceType().binding;
                if (methodScope.initializedField != null && methodScope.initializedField.isViewedAsDeprecated()) {
                    return true;
                }
                if (type == null || !type.isViewedAsDeprecated()) break;
                return true;
            }
            case 3: {
                SourceTypeBinding context = ((ClassScope)this).referenceType().binding;
                if (context == null || !context.isViewedAsDeprecated()) break;
                return true;
            }
        }
        return false;
    }

    private TypeBinding leastContainingInvocation(TypeBinding mec, Set invocations, List lubStack) {
        if (invocations == null) {
            return mec;
        }
        int length = invocations.size();
        Iterator iter = invocations.iterator();
        if (length == 1) {
            return (TypeBinding)iter.next();
        }
        int dim = mec.dimensions();
        int argLength = (mec = mec.leafComponentType()).typeVariables().length;
        if (argLength == 0) {
            return mec;
        }
        TypeBinding[] bestArguments = new TypeBinding[argLength];
        block5: while (iter.hasNext()) {
            TypeBinding invocation = ((TypeBinding)iter.next()).leafComponentType();
            switch (invocation.kind()) {
                case 2052: {
                    TypeVariableBinding[] invocationVariables = invocation.typeVariables();
                    int i = 0;
                    while (i < argLength) {
                        TypeBinding bestArgument = this.leastContainingTypeArgument(bestArguments[i], invocationVariables[i], (ReferenceBinding)mec, i, lubStack);
                        if (bestArgument == null) {
                            return null;
                        }
                        bestArguments[i] = bestArgument;
                        ++i;
                    }
                    continue block5;
                }
                case 260: {
                    ParameterizedTypeBinding parameterizedType = (ParameterizedTypeBinding)invocation;
                    int i = 0;
                    while (i < argLength) {
                        TypeBinding bestArgument = this.leastContainingTypeArgument(bestArguments[i], parameterizedType.arguments[i], (ReferenceBinding)mec, i, lubStack);
                        if (bestArgument == null) {
                            return null;
                        }
                        bestArguments[i] = bestArgument;
                        ++i;
                    }
                    continue block5;
                }
                case 1028: {
                    return dim == 0 ? invocation : this.environment().createArrayType(invocation, dim);
                }
            }
        }
        ParameterizedTypeBinding least = this.environment().createParameterizedType((ReferenceBinding)mec.erasure(), bestArguments, mec.enclosingType());
        return dim == 0 ? least : this.environment().createArrayType(least, dim);
    }

    private TypeBinding leastContainingTypeArgument(TypeBinding u, TypeBinding v, ReferenceBinding genericType, int rank, List lubStack) {
        if (u == null) {
            return v;
        }
        if (u == v) {
            return u;
        }
        if (v.isWildcard()) {
            WildcardBinding wildV = (WildcardBinding)v;
            if (u.isWildcard()) {
                WildcardBinding wildU = (WildcardBinding)u;
                switch (wildU.boundKind) {
                    case 1: {
                        switch (wildV.boundKind) {
                            case 1: {
                                TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{wildU.bound, wildV.bound}, lubStack);
                                if (lub == null) {
                                    return null;
                                }
                                if (lub == BaseTypes.IntBinding) {
                                    return this.environment().createWildcard(genericType, rank, null, null, 0);
                                }
                                return this.environment().createWildcard(genericType, rank, lub, null, 1);
                            }
                            case 2: {
                                if (wildU.bound == wildV.bound) {
                                    return wildU.bound;
                                }
                                return this.environment().createWildcard(genericType, rank, null, null, 0);
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (wildU.boundKind == 2) {
                            TypeBinding[] glb = Scope.greaterLowerBound(new TypeBinding[]{wildU.bound, wildV.bound});
                            if (glb == null) {
                                return null;
                            }
                            return this.environment().createWildcard(genericType, rank, glb[0], null, 2);
                        } else {
                            break;
                        }
                    }
                }
            } else {
                switch (wildV.boundKind) {
                    case 1: {
                        TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{u, wildV.bound}, lubStack);
                        if (lub == null) {
                            return null;
                        }
                        if (lub == BaseTypes.IntBinding) {
                            return this.environment().createWildcard(genericType, rank, null, null, 0);
                        }
                        return this.environment().createWildcard(genericType, rank, lub, null, 1);
                    }
                    case 2: {
                        TypeBinding[] glb = Scope.greaterLowerBound(new TypeBinding[]{u, wildV.bound});
                        if (glb == null) {
                            return null;
                        }
                        return this.environment().createWildcard(genericType, rank, glb[0], null, 2);
                    }
                }
            }
        } else if (u.isWildcard()) {
            WildcardBinding wildU = (WildcardBinding)u;
            switch (wildU.boundKind) {
                case 1: {
                    TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{wildU.bound, v}, lubStack);
                    if (lub == null) {
                        return null;
                    }
                    if (lub == BaseTypes.IntBinding) {
                        return this.environment().createWildcard(genericType, rank, null, null, 0);
                    }
                    return this.environment().createWildcard(genericType, rank, lub, null, 1);
                }
                case 2: {
                    TypeBinding[] glb = Scope.greaterLowerBound(new TypeBinding[]{wildU.bound, v});
                    if (glb == null) {
                        return null;
                    }
                    return this.environment().createWildcard(genericType, rank, glb[0], null, 2);
                }
            }
        }
        TypeBinding lub = this.lowerUpperBound(new TypeBinding[]{u, v}, lubStack);
        if (lub == null) {
            return null;
        }
        if (lub == BaseTypes.IntBinding) {
            return this.environment().createWildcard(genericType, rank, null, null, 0);
        }
        return this.environment().createWildcard(genericType, rank, lub, null, 1);
    }

    public TypeBinding lowerUpperBound(TypeBinding[] types) {
        int typeLength = types.length;
        if (typeLength == 1) {
            TypeBinding type = types[0];
            return type == null ? BaseTypes.VoidBinding : type;
        }
        return this.lowerUpperBound(types, new ArrayList(1));
    }

    private TypeBinding lowerUpperBound(TypeBinding[] types, List lubStack) {
        int typeLength = types.length;
        if (typeLength == 1) {
            TypeBinding type = types[0];
            return type == null ? BaseTypes.VoidBinding : type;
        }
        int stackLength = lubStack.size();
        int i = 0;
        while (i < stackLength) {
            block23: {
                TypeBinding[] lubTypes = (TypeBinding[])lubStack.get(i);
                int lubTypeLength = lubTypes.length;
                if (lubTypeLength >= typeLength) {
                    int j = 0;
                    block6: while (j < typeLength) {
                        TypeBinding type = types[j];
                        int k = 0;
                        while (k < lubTypeLength) {
                            if (lubTypes[k] != type && !lubTypes[k].isEquivalentTo(type)) {
                                ++k;
                                continue;
                            }
                            ++j;
                            continue block6;
                        }
                        break block23;
                    }
                    return BaseTypes.IntBinding;
                }
            }
            ++i;
        }
        lubStack.add(types);
        HashMap invocations = new HashMap(1);
        TypeBinding[] mecs = this.minimalErasedCandidates(types, invocations);
        if (mecs == null) {
            return null;
        }
        int length = mecs.length;
        if (length == 0) {
            return BaseTypes.VoidBinding;
        }
        int count = 0;
        TypeBinding firstBound = null;
        int commonDim = -1;
        int i2 = 0;
        while (i2 < length) {
            TypeBinding mec = mecs[i2];
            if (mec != null) {
                if ((mec = this.leastContainingInvocation(mec, (Set)invocations.get(mec), lubStack)) == null) {
                    return null;
                }
                int dim = mec.dimensions();
                if (commonDim == -1) {
                    commonDim = dim;
                } else if (dim != commonDim) {
                    return null;
                }
                if (firstBound == null && !mec.leafComponentType().isInterface()) {
                    firstBound = mec.leafComponentType();
                }
                mecs[count++] = mec;
            }
            ++i2;
        }
        switch (count) {
            case 0: {
                return BaseTypes.VoidBinding;
            }
            case 1: {
                return mecs[0];
            }
            case 2: {
                if ((commonDim == 0 ? mecs[1].id : mecs[1].leafComponentType().id) == 1) {
                    return mecs[0];
                }
                if ((commonDim == 0 ? mecs[0].id : mecs[0].leafComponentType().id) != 1) break;
                return mecs[1];
            }
        }
        TypeBinding[] otherBounds = new TypeBinding[count - 1];
        int rank = 0;
        int i3 = 0;
        while (i3 < count) {
            TypeBinding mec;
            TypeBinding typeBinding = mec = commonDim == 0 ? mecs[i3] : mecs[i3].leafComponentType();
            if (mec.isInterface()) {
                otherBounds[rank++] = (ReferenceBinding)mec;
            }
            ++i3;
        }
        WildcardBinding intersectionType = this.environment().createWildcard(null, 0, firstBound, otherBounds, 1);
        return commonDim == 0 ? intersectionType : this.environment().createArrayType(intersectionType, commonDim);
    }

    public final MethodScope methodScope() {
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            return (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected TypeBinding[] minimalErasedCandidates(TypeBinding[] types, Map allInvocations) {
        length = types.length;
        indexOfFirst = -1;
        actualLength = 0;
        i = 0;
        while (i < length) {
            type = types[i];
            if (type != null) {
                if (type.isBaseType()) {
                    return null;
                }
                if (indexOfFirst < 0) {
                    indexOfFirst = i;
                }
                ++actualLength;
            }
            ++i;
        }
        switch (actualLength) {
            case 0: {
                return TypeConstants.NoTypes;
            }
            case 1: {
                return types;
            }
        }
        firstType = types[indexOfFirst];
        if (firstType.isBaseType()) {
            return null;
        }
        typesToVisit = new ArrayList<TypeBinding>(5);
        dim = firstType.dimensions();
        leafType = firstType.leafComponentType();
        v0 = firstErasure = leafType.isTypeVariable() != false || leafType.isWildcard() != false ? firstType : firstType.erasure();
        if (firstErasure != firstType) {
            someInvocations = new HashSet<TypeBinding>(1);
            someInvocations.add(firstType);
            allInvocations.put(firstErasure, someInvocations);
        }
        typesToVisit.add(firstType);
        max = 1;
        i = 0;
        while (i < max) {
            block52: {
                block51: {
                    typeToVisit = (TypeBinding)typesToVisit.get(i);
                    dim = typeToVisit.dimensions();
                    if (dim <= 0) break block51;
                    leafType = typeToVisit.leafComponentType();
                    switch (leafType.id) {
                        case 1: {
                            if (dim <= 1) ** GOTO lbl51
                            elementType = ((ArrayBinding)typeToVisit).elementsType();
                            if (!typesToVisit.contains(elementType)) {
                                typesToVisit.add(elementType);
                                ++max;
                            }
                            break block52;
                        }
lbl51:
                        // 2 sources

                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            superType = this.getJavaIoSerializable();
                            if (!typesToVisit.contains(superType)) {
                                typesToVisit.add(superType);
                                ++max;
                            }
                            if (!typesToVisit.contains(superType = this.getJavaLangCloneable())) {
                                typesToVisit.add(superType);
                                ++max;
                            }
                            if (!typesToVisit.contains(superType = this.getJavaLangObject())) {
                                typesToVisit.add(superType);
                                ++max;
                            }
                            break block52;
                        }
                        default: {
                            typeToVisit = leafType;
                        }
                    }
                }
                if ((currentType = (ReferenceBinding)typeToVisit).isCapture() && (firstBound = ((CaptureBinding)currentType).firstBound) != null && firstBound.isArrayType()) {
                    v1 = superType = dim == 0 ? firstBound : this.environment().createArrayType(firstBound, dim);
                    if (!typesToVisit.contains(superType)) {
                        typesToVisit.add(superType);
                        ++max;
                        v2 = superTypeErasure = firstBound.isTypeVariable() != false || firstBound.isWildcard() != false ? superType : superType.erasure();
                        if (superTypeErasure != superType) {
                            someInvocations = new HashSet<TypeBinding>(1);
                            someInvocations.add(superType);
                            allInvocations.put(superTypeErasure, someInvocations);
                        }
                    }
                } else {
                    itsInterfaces = currentType.superInterfaces();
                    j = 0;
                    count = itsInterfaces.length;
                    while (j < count) {
                        itsInterface = itsInterfaces[j];
                        v3 /* !! */  = superType = dim == 0 ? itsInterface : this.environment().createArrayType(itsInterface, dim);
                        if (!typesToVisit.contains(superType)) {
                            typesToVisit.add(superType);
                            ++max;
                            v4 /* !! */  = superTypeErasure = itsInterface.isTypeVariable() != false || itsInterface.isWildcard() != false ? superType : superType.erasure();
                            if (superTypeErasure != superType) {
                                someInvocations = new HashSet<ReferenceBinding>(1);
                                someInvocations.add(superType);
                                allInvocations.put(superTypeErasure, someInvocations);
                            }
                        }
                        ++j;
                    }
                    itsSuperclass = currentType.superclass();
                    if (itsSuperclass != null) {
                        v5 /* !! */  = superType = dim == 0 ? itsSuperclass : this.environment().createArrayType(itsSuperclass, dim);
                        if (!typesToVisit.contains(superType)) {
                            typesToVisit.add(superType);
                            ++max;
                            v6 /* !! */  = superTypeErasure = itsSuperclass.isTypeVariable() != false || itsSuperclass.isWildcard() != false ? superType : superType.erasure();
                            if (superTypeErasure != superType) {
                                someInvocations = new HashSet<ReferenceBinding>(1);
                                someInvocations.add(superType);
                                allInvocations.put(superTypeErasure, someInvocations);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        superLength = typesToVisit.size();
        erasedSuperTypes = new TypeBinding[superLength];
        rank = 0;
        iter = typesToVisit.iterator();
        while (iter.hasNext()) {
            type = (TypeBinding)iter.next();
            leafType = type.leafComponentType();
            v7 = erasedSuperTypes[rank++] = leafType.isTypeVariable() != false || leafType.isWildcard() != false ? type : type.erasure();
        }
        remaining = superLength;
        i = indexOfFirst + 1;
        while (i < length) {
            block53: {
                block54: {
                    otherType = types[i];
                    if (otherType == null) break block53;
                    if (!otherType.isArrayType()) break block54;
                    j = 0;
                    while (j < superLength) {
                        erasedSuperType = erasedSuperTypes[j];
                        if (erasedSuperType != null && erasedSuperType != otherType) {
                            match = ((ArrayBinding)otherType).findSuperTypeWithSameErasure(erasedSuperType);
                            if (match == null) {
                                erasedSuperTypes[j] = null;
                                if (--remaining == 0) {
                                    return null;
                                }
                            } else {
                                someInvocations = (HashSet<TypeBinding>)allInvocations.get(erasedSuperType);
                                if (someInvocations == null) {
                                    someInvocations = new HashSet<TypeBinding>(1);
                                }
                                someInvocations.add(match);
                                allInvocations.put(erasedSuperType, someInvocations);
                            }
                        }
                        ++j;
                    }
                    break block53;
                }
                otherRefType = (ReferenceBinding)otherType;
                j = 0;
                while (j < superLength) {
                    block55: {
                        block56: {
                            erasedSuperType = erasedSuperTypes[j];
                            if (erasedSuperType == null) break block55;
                            if (erasedSuperType != otherType && (erasedSuperType.id != 1 || !otherType.isInterface())) break block56;
                            match /* !! */  = erasedSuperType;
                            ** GOTO lbl-1000
                        }
                        match /* !! */  = erasedSuperType.isArrayType() != false ? null : otherRefType.findSuperTypeWithSameErasure(erasedSuperType);
                        if (match /* !! */  == null) {
                            erasedSuperTypes[j] = null;
                            if (--remaining == 0) {
                                return null;
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            someInvocations = (HashSet<TypeBinding>)allInvocations.get(erasedSuperType);
                            if (someInvocations == null) {
                                someInvocations = new HashSet<TypeBinding>(1);
                            }
                            someInvocations.add(match /* !! */ );
                            allInvocations.put(erasedSuperType, someInvocations);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (remaining > 1) {
            i = 0;
            while (i < superLength) {
                erasedSuperType = erasedSuperTypes[i];
                if (erasedSuperType != null) {
                    j = 0;
                    while (j < superLength) {
                        if (i != j && (otherType = erasedSuperTypes[j]) != null) {
                            if (erasedSuperType instanceof ReferenceBinding) {
                                if (!(otherType.id == 1 && erasedSuperType.isInterface() || ((ReferenceBinding)erasedSuperType).findSuperTypeWithSameErasure(otherType) == null)) {
                                    erasedSuperTypes[j] = null;
                                    --remaining;
                                }
                            } else if (!(!erasedSuperType.isArrayType() || otherType.isArrayType() && otherType.leafComponentType().id == 1 && otherType.dimensions() == erasedSuperType.dimensions() && erasedSuperType.leafComponentType().isInterface() || ((ArrayBinding)erasedSuperType).findSuperTypeWithSameErasure(otherType) == null)) {
                                erasedSuperTypes[j] = null;
                                --remaining;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return erasedSuperTypes;
    }

    protected final MethodBinding mostSpecificClassMethodBinding(MethodBinding[] visible, int visibleSize, InvocationSite invocationSite) {
        MethodBinding problemMethod = null;
        MethodBinding previous = null;
        int i = 0;
        while (i < visibleSize) {
            block6: {
                MethodBinding method = visible[i];
                if (previous != null) {
                    MethodBinding methodBinding = method;
                    MethodBinding methodBinding2 = previous;
                    if ((ReferenceBinding)Scope.declaringClass_aroundBody43$advice(this, methodBinding, OwningClassSupportForMethodBindings.aspectOf(), methodBinding, null) != (ReferenceBinding)Scope.declaringClass_aroundBody45$advice(this, methodBinding2, OwningClassSupportForMethodBindings.aspectOf(), methodBinding2, null)) break;
                }
                if (!method.isStatic()) {
                    previous = method;
                }
                int j = 0;
                while (j < visibleSize) {
                    if (i == j || visible[j].areParametersCompatibleWith(method.parameters)) {
                        ++j;
                        continue;
                    }
                    break block6;
                }
                this.compilationUnitScope().recordTypeReferences(method.thrownExceptions);
                return method;
            }
            ++i;
        }
        if (problemMethod == null) {
            return new ProblemMethodBinding(visible[0].selector, visible[0].parameters, 3);
        }
        return problemMethod;
    }

    protected final MethodBinding mostSpecificInterfaceMethodBinding(MethodBinding[] visible, int visibleSize, InvocationSite invocationSite) {
        MethodBinding problemMethod = null;
        int i = 0;
        while (i < visibleSize) {
            block4: {
                MethodBinding method = visible[i];
                int j = 0;
                while (j < visibleSize) {
                    if (i == j || visible[j].areParametersCompatibleWith(method.parameters)) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                this.compilationUnitScope().recordTypeReferences(method.thrownExceptions);
                return method;
            }
            ++i;
        }
        if (problemMethod == null) {
            return new ProblemMethodBinding(visible[0].selector, visible[0].parameters, 3);
        }
        return problemMethod;
    }

    protected final MethodBinding mostSpecificMethodBinding(MethodBinding[] visible, int visibleSize, TypeBinding[] argumentTypes, InvocationSite invocationSite) {
        int[] compatibilityLevels = new int[visibleSize];
        int i = 0;
        while (i < visibleSize) {
            compatibilityLevels[i] = this.parameterCompatibilityLevel(visible[i], argumentTypes);
            ++i;
        }
        int level = 0;
        int max = 2;
        while (level <= max) {
            int i2 = 0;
            block2: while (i2 < visibleSize) {
                block22: {
                    if (compatibilityLevels[i2] == level) {
                        MethodBinding method = visible[i2];
                        TypeBinding[] params = method.tiebreakMethod().parameters;
                        int j = 0;
                        while (j < visibleSize) {
                            if (i2 != j && compatibilityLevels[j] == level) {
                                max = level;
                                MethodBinding method2 = visible[j];
                                if (!method2.tiebreakMethod().areParametersCompatibleWith(params)) {
                                    TypeBinding[] params2;
                                    int paramLength;
                                    if (!method.isVarargs() || !method2.isVarargs() || (paramLength = params.length) != (params2 = method2.tiebreakMethod().parameters).length) break block22;
                                    int p = paramLength - 2;
                                    while (p >= 0) {
                                        if (params[p] == params2[p] || params[p].isCompatibleWith(params2[p])) {
                                            --p;
                                            continue;
                                        }
                                        break block22;
                                    }
                                    TypeBinding elementsType = ((ArrayBinding)params2[paramLength - 1]).elementsType();
                                    if (!params[paramLength - 1].isCompatibleWith(elementsType)) break block22;
                                } else if (method.original() != method2.original() && method.tiebreakMethod().areParametersEqual(method2.tiebreakMethod())) {
                                    ReferenceBinding superType;
                                    ReferenceBinding declaringClass;
                                    if (OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(method) == OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(method2)) break block22;
                                    MethodBinding original = method.original();
                                    if (method.hasSubstitutedParameters() || original.typeVariables != TypeConstants.NoTypeVariables) {
                                        declaringClass = (ReferenceBinding)OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(method).erasure();
                                        superType = declaringClass.findSuperTypeWithSameErasure(OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(method2).erasure());
                                        if (superType == null) {
                                            if (method.isAbstract() || !method2.isAbstract()) break block22;
                                        } else {
                                            MethodBinding inheritedMethod = method2;
                                            MethodBinding inheritedOriginal = method2.original();
                                            if (method.hasSubstitutedParameters()) {
                                                MethodBinding[] superMethods = superType.getMethods(inheritedMethod.selector);
                                                int m = 0;
                                                int l = superMethods.length;
                                                while (m < l) {
                                                    if (superMethods[m].original() == inheritedOriginal) {
                                                        inheritedMethod = superMethods[m];
                                                        break;
                                                    }
                                                    ++m;
                                                }
                                            }
                                            if (original.typeVariables != TypeConstants.NoTypeVariables) {
                                                inheritedMethod = original.computeSubstitutedMethod(inheritedMethod == method2 ? inheritedOriginal : inheritedMethod, this.environment());
                                            }
                                            if (inheritedMethod == null || !original.areParametersEqual(inheritedMethod)) {
                                                break block2;
                                            }
                                        }
                                    } else if (method.isStatic() && method2.isStatic() && (superType = (declaringClass = (ReferenceBinding)OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(method).erasure()).findSuperTypeWithSameErasure(OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(method2).erasure())) == null) break block22;
                                }
                            }
                            ++j;
                        }
                        this.compilationUnitScope().recordTypeReferences(method.thrownExceptions);
                        return method;
                    }
                }
                ++i2;
            }
            ++level;
        }
        return new ProblemMethodBinding(visible[0].selector, visible[0].parameters, 3);
    }

    public final ClassScope outerMostClassScope() {
        ClassScope lastClassScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof ClassScope)) continue;
            lastClassScope = (ClassScope)scope;
        } while ((scope = scope.parent) != null);
        return lastClassScope;
    }

    public final MethodScope outerMostMethodScope() {
        MethodScope lastMethodScope = null;
        Scope scope = this;
        do {
            if (!(scope instanceof MethodScope)) continue;
            lastMethodScope = (MethodScope)scope;
        } while ((scope = scope.parent) != null);
        return lastMethodScope;
    }

    protected int parameterCompatibilityLevel(MethodBinding method, TypeBinding[] arguments) {
        TypeBinding arg;
        TypeBinding[] parameters = method.parameters;
        int paramLength = parameters.length;
        int argLength = arguments.length;
        if (this.compilerOptions().sourceLevel < 0x310000L) {
            if (paramLength != argLength) {
                return -1;
            }
            int i = 0;
            while (i < argLength) {
                TypeBinding arg2 = arguments[i];
                TypeBinding param = parameters[i];
                if (arg2 != param && !arg2.isCompatibleWith(param)) {
                    return -1;
                }
                ++i;
            }
            return 0;
        }
        int level = 0;
        int lastIndex = argLength;
        if (method.isVarargs()) {
            TypeBinding param;
            lastIndex = paramLength - 1;
            if (paramLength == argLength) {
                param = parameters[lastIndex];
                TypeBinding arg3 = arguments[lastIndex];
                if (param != arg3 && (level = this.parameterCompatibilityLevel(arg3, param, this.environment())) == -1) {
                    if (this.parameterCompatibilityLevel(arg3, param = ((ArrayBinding)param).elementsType(), this.environment()) == -1) {
                        return -1;
                    }
                    level = 2;
                }
            } else {
                if (paramLength < argLength) {
                    param = ((ArrayBinding)parameters[lastIndex]).elementsType();
                    int i = lastIndex;
                    while (i < argLength) {
                        arg = arguments[i];
                        if (param != arg && this.parameterCompatibilityLevel(arg, param, this.environment()) == -1) {
                            return -1;
                        }
                        ++i;
                    }
                } else if (lastIndex != argLength) {
                    return -1;
                }
                level = 2;
            }
        }
        int i = 0;
        while (i < lastIndex) {
            arg = arguments[i];
            TypeBinding param = parameters[i];
            if (arg != param) {
                int newLevel = this.parameterCompatibilityLevel(arg, param, this.environment());
                if (newLevel == -1) {
                    return -1;
                }
                if (newLevel > level) {
                    level = newLevel;
                }
            }
            ++i;
        }
        return level;
    }

    private int parameterCompatibilityLevel(TypeBinding arg, TypeBinding param, LookupEnvironment env) {
        TypeBinding convertedType;
        if (arg.isCompatibleWith(param)) {
            return 0;
        }
        if (arg.isBaseType() != param.isBaseType() && ((convertedType = env.computeBoxingType(arg)) == param || convertedType.isCompatibleWith(param))) {
            return 1;
        }
        return -1;
    }

    public abstract ProblemReporter problemReporter();

    public final CompilationUnitDeclaration referenceCompilationUnit() {
        Scope scope;
        Scope unitScope = this;
        while ((scope = unitScope.parent) != null) {
            unitScope = scope;
        }
        return ((CompilationUnitScope)unitScope).referenceContext;
    }

    public ReferenceContext referenceContext() {
        Scope current = this;
        do {
            switch (current.kind) {
                case 2: {
                    return ((MethodScope)current).referenceContext;
                }
                case 3: {
                    return ((ClassScope)current).referenceContext;
                }
                case 4: {
                    return ((CompilationUnitScope)current).referenceContext;
                }
            }
        } while ((current = current.parent) != null);
        return null;
    }

    int startIndex() {
        return 0;
    }

    public TypeVariableBinding findTypeVariable(char[] name, SourceTypeBinding sourceType) {
        return sourceType.getTypeVariable(name);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody0(Scope scope, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody1$advice(Scope this_, FieldBinding aBinding, OwningClassSupportForFieldBindings ajc_aroundClosure, FieldBinding fieldBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(fieldBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody2(Scope scope, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody3$advice(Scope this_, FieldBinding aBinding, OwningClassSupportForFieldBindings ajc_aroundClosure, FieldBinding fieldBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(fieldBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody4(Scope scope, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody5$advice(Scope this_, FieldBinding aBinding, OwningClassSupportForFieldBindings ajc_aroundClosure, FieldBinding fieldBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(fieldBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody6(Scope scope, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody7$advice(Scope this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody8(Scope scope, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody9$advice(Scope this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody10(Scope scope, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody11$advice(Scope this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody12(Scope scope, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody13$advice(Scope this_, FieldBinding aBinding, OwningClassSupportForFieldBindings ajc_aroundClosure, FieldBinding fieldBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(fieldBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody14(Scope scope, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody15$advice(Scope this_, FieldBinding aBinding, OwningClassSupportForFieldBindings ajc_aroundClosure, FieldBinding fieldBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(fieldBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody16(Scope scope, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody17$advice(Scope this_, FieldBinding aBinding, OwningClassSupportForFieldBindings ajc_aroundClosure, FieldBinding fieldBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(fieldBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody18(Scope scope, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody19$advice(Scope this_, FieldBinding aBinding, OwningClassSupportForFieldBindings ajc_aroundClosure, FieldBinding fieldBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(fieldBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody20(Scope scope, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody21$advice(Scope this_, FieldBinding aBinding, OwningClassSupportForFieldBindings ajc_aroundClosure, FieldBinding fieldBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(fieldBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody22(Scope scope, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody23$advice(Scope this_, FieldBinding aBinding, OwningClassSupportForFieldBindings ajc_aroundClosure, FieldBinding fieldBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(fieldBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody24(Scope scope, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody25$advice(Scope this_, FieldBinding aBinding, OwningClassSupportForFieldBindings ajc_aroundClosure, FieldBinding fieldBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(fieldBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody26(Scope scope, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody27$advice(Scope this_, FieldBinding aBinding, OwningClassSupportForFieldBindings ajc_aroundClosure, FieldBinding fieldBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(fieldBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody28(Scope scope, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody29$advice(Scope this_, FieldBinding aBinding, OwningClassSupportForFieldBindings ajc_aroundClosure, FieldBinding fieldBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(fieldBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody30(Scope scope, FieldBinding fieldBinding) {
        return fieldBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody31$advice(Scope this_, FieldBinding aBinding, OwningClassSupportForFieldBindings ajc_aroundClosure, FieldBinding fieldBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForFieldBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForFieldBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_FieldBinding$getOwningClass(fieldBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody32(Scope scope, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody33$advice(Scope this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody34(Scope scope, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody35$advice(Scope this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody36(Scope scope, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody37$advice(Scope this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody38(Scope scope, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody39$advice(Scope this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody40(Scope scope, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody41$advice(Scope this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody42(Scope scope, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody43$advice(Scope this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }

    private static final /* synthetic */ ReferenceBinding declaringClass_aroundBody44(Scope scope, MethodBinding methodBinding) {
        return methodBinding.declaringClass;
    }

    private static final /* synthetic */ Object declaringClass_aroundBody45$advice(Scope this_, MethodBinding aBinding, OwningClassSupportForMethodBindings ajc_aroundClosure, MethodBinding methodBinding, AroundClosure aroundClosure) {
        return OwningClassSupportForMethodBindings.ajc$interMethodDispatch1$org_aspectj_ajdt_internal_compiler_lookup_OwningClassSupportForMethodBindings$org_aspectj_org_eclipse_jdt_internal_compiler_lookup_MethodBinding$getOwningClass(methodBinding);
    }
}

