/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.policy.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyContainingAssertion;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.model.AbstractSecurityAssertion;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.wss4j.policy.model.Layout;

public abstract class AbstractBinding
extends AbstractSecurityAssertion
implements PolicyContainingAssertion {
    private Policy nestedPolicy;
    private AlgorithmSuite algorithmSuite;
    private Layout layout;
    private boolean includeTimestamp;

    protected AbstractBinding(SPConstants.SPVersion version, Policy nestedPolicy) {
        super(version);
        this.nestedPolicy = nestedPolicy;
        this.parseNestedBindingPolicy(nestedPolicy, this);
        if (this.layout == null) {
            this.layout = new Layout(version, new Policy());
        }
    }

    public Policy getPolicy() {
        return this.nestedPolicy;
    }

    @Override
    public PolicyComponent normalize() {
        return super.normalize(this.getPolicy());
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        super.serialize(writer, this.getPolicy());
    }

    protected void parseNestedBindingPolicy(Policy nestedPolicy, AbstractBinding binding) {
        Iterator alternatives = nestedPolicy.getAlternatives();
        if (alternatives.hasNext()) {
            List assertions = (List)alternatives.next();
            for (int i = 0; i < assertions.size(); ++i) {
                Assertion assertion = (Assertion)assertions.get(i);
                String assertionName = assertion.getName().getLocalPart();
                if ("AlgorithmSuite".equals(assertionName)) {
                    if (binding.getAlgorithmSuite() != null) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    binding.setAlgorithmSuite((AlgorithmSuite)assertion);
                    continue;
                }
                if ("Layout".equals(assertionName)) {
                    if (binding.getLayout() != null) {
                        throw new IllegalArgumentException("Invalid Policy");
                    }
                    Layout layout = (Layout)assertion;
                    binding.setLayout(layout);
                    if (layout.getLayoutType() != Layout.LayoutType.LaxTsFirst && layout.getLayoutType() != Layout.LayoutType.LaxTsLast) continue;
                    binding.setIncludeTimestamp(true);
                    continue;
                }
                if (!"IncludeTimestamp".equals(assertionName)) continue;
                binding.setIncludeTimestamp(true);
            }
        }
        if (binding.getAlgorithmSuite() == null && binding.getVersion() != SPConstants.SPVersion.SP11) {
            throw new IllegalArgumentException("sp:" + this.getName().getLocalPart() + " must have an inner sp:AlgorithmSuite element");
        }
    }

    public AlgorithmSuite getAlgorithmSuite() {
        return this.algorithmSuite;
    }

    protected void setAlgorithmSuite(AlgorithmSuite algorithmSuite) {
        this.algorithmSuite = algorithmSuite;
    }

    public Layout getLayout() {
        return this.layout;
    }

    protected void setLayout(Layout layout) {
        this.layout = layout;
    }

    public boolean isIncludeTimestamp() {
        return this.includeTimestamp;
    }

    protected void setIncludeTimestamp(boolean includeTimestamp) {
        this.includeTimestamp = includeTimestamp;
    }
}

