/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.util.resource;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XSDHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.helper.TypeHelperImpl;
import org.apache.tuscany.sdo.helper.XMLStreamHelperImpl;
import org.apache.tuscany.sdo.util.StreamDeserializer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public class SDODeserializer
extends StreamDeserializer {
    private HelperContext hc;
    XSDHelper xsdHelper;
    protected Property propertyInSequence;
    XMLStreamHelperImpl deserializer;
    TypeHelper typeHelper;
    Map options;
    EObject root;
    ExtendedMetaData extendedMetaData;

    protected final void initialize(XMLStreamReader stream, HelperContext scope, Object rootObject) {
        this.hc = scope;
        this.reader = stream;
        this.xsdHelper = scope.getXSDHelper();
        this.typeHelper = scope.getTypeHelper();
        this.extendedMetaData = ((TypeHelperImpl)this.typeHelper).getExtendedMetaData();
        this.deserializer = (XMLStreamHelperImpl)((HelperContextImpl)scope).getXMLStreamHelper();
        this.root = (EObject)rootObject;
    }

    Property getProperty(Object type) {
        EStructuralFeature containment = (EStructuralFeature)this.propertyInSequence;
        EClass c = (EClass)type;
        EStructuralFeature containing = this.extendedMetaData.getAffiliation(c, containment);
        if (containment == containing && containment.isDerived() && (containing = this.extendedMetaData.getMixedFeature(c)) == null && (containing = this.extendedMetaData.getGroup(containment)) == null) {
            return this.propertyInSequence;
        }
        return (Property)containing;
    }

    protected final Property getProperty(Type type, String nameSpace, String name, boolean element) {
        Iterator iterator = type.getProperties().iterator();
        while (iterator.hasNext()) {
            this.propertyInSequence = (Property)iterator.next();
            if (!name.equals(this.xsdHelper.getLocalName(this.propertyInSequence)) || !nameSpace.equals(this.xsdHelper.getNamespaceURI(this.propertyInSequence))) continue;
            return this.getProperty(type);
        }
        this.propertyInSequence = this.xsdHelper.getGlobalProperty(nameSpace, name, element);
        return this.getProperty(type);
    }

    protected final Property getProperty(Type type, String name) {
        this.propertyInSequence = type.getProperty(name);
        return this.getProperty(type);
    }

    protected final Property getProperty(String nameSpace, String name, Type type) {
        return null == nameSpace ? this.getProperty(type, name) : this.getProperty(type, nameSpace, name, true);
    }

    protected Object load(XMLStreamReader reader, Map options) throws XMLStreamException {
        return this.deserializer.loadObject(reader, options);
    }

    static Object value(Type type, XMLStreamReader reader) throws XMLStreamException {
        return SDODeserializer.value(type, reader.getElementText(), reader.getNamespaceContext());
    }

    protected final Object value(Type type) throws XMLStreamException {
        return "true".equals(this.reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil")) ? null : (type.isDataType() ? SDODeserializer.value(type, this.reader) : this.load(this.reader, null));
    }

    protected final Object value(XMLStreamReader reader) throws XMLStreamException {
        Type propertyType = this.propertyInSequence.getType();
        if (propertyType.isDataType()) {
            return SDODeserializer.value(propertyType, reader);
        }
        if (this.options == null) {
            this.options = new HashMap();
        }
        this.options.put("default root type", propertyType);
        return this.load(reader, this.options);
    }

    private boolean match(String name, String space, EStructuralFeature feature) {
        return name.equals(this.extendedMetaData.getName(feature)) && space.equals(this.extendedMetaData.getNamespace(feature));
    }

    EObject step(String ref, int step, int index, EObject container, String prefix, NamespaceContext nameSpaces) {
        String name = ref.substring(step, index);
        Iterator iterator = container.eContents().iterator();
        if (iterator.hasNext()) {
            if (prefix == null) {
                do {
                    if (!name.equals(this.extendedMetaData.getName((EStructuralFeature)(container = (EObject)iterator.next()).eContainmentFeature()))) continue;
                    return container;
                } while (iterator.hasNext());
            } else {
                prefix = nameSpaces.getNamespaceURI(prefix);
                do {
                    if (!this.match(name, prefix, (EStructuralFeature)(container = (EObject)iterator.next()).eContainmentFeature())) continue;
                    return container;
                } while (iterator.hasNext());
            }
        }
        return null;
    }

    protected final EObject referent(String ref, NamespaceContext nameSpaces) {
        int step;
        EObject container;
        int length = ref.length();
        switch (length) {
            case 0: {
                return null;
            }
            case 1: {
                return this.root;
            }
        }
        if (ref.charAt(1) == '/') {
            container = EcoreUtil.getRootContainer((EObject)this.root);
            if (length == 2) {
                return container;
            }
            if (ref.charAt(2) == '/') {
                Iterator iterator = container.eContents().iterator();
                if (!iterator.hasNext()) {
                    return null;
                }
                container = (EObject)iterator.next();
                step = 3;
            } else {
                step = 2;
            }
        } else {
            container = this.root;
            step = 1;
        }
        String prefix = null;
        int index = step;
        block9: while (++index != length) {
            switch (ref.charAt(index)) {
                case '/': {
                    container = this.step(ref, step, index, container, prefix, nameSpaces);
                    if (container != null) break;
                    return null;
                }
                case ':': {
                    prefix = ref.substring(step, index);
                    if (++index == length) {
                        return container;
                    }
                    step = index;
                }
                default: {
                    continue block9;
                }
                case '[': {
                    EObject content;
                    EReference feature;
                    this.name = ref.substring(step, index);
                    step = ref.indexOf(93, index + 2);
                    if (step == -1) {
                        return container;
                    }
                    ++index;
                    index = Integer.parseInt(ref.substring(index, step));
                    Iterator iterator = container.eContents().iterator();
                    if (prefix == null) {
                        do {
                            if (iterator.hasNext()) continue;
                            return null;
                        } while (!this.name.equals(this.extendedMetaData.getName((EStructuralFeature)(feature = (content = (EObject)iterator.next()).eContainmentFeature()))));
                    } else {
                        prefix = nameSpaces.getNamespaceURI(prefix);
                        do {
                            if (iterator.hasNext()) continue;
                            return null;
                        } while (!this.match(this.name, prefix, (EStructuralFeature)(feature = (content = (EObject)iterator.next()).eContainmentFeature())));
                    }
                    Object value = container.eGet((EStructuralFeature)feature);
                    if (value instanceof List) {
                        List values = (List)value;
                        if (index > values.size()) {
                            return null;
                        }
                        container = (EObject)values.get(--index);
                    } else if (index == 1) {
                        container = (EObject)value;
                    } else {
                        return null;
                    }
                    index = ref.indexOf(47, ++step);
                    if (index != -1) break;
                    return container;
                }
            }
            if (++index == length) {
                return container;
            }
            step = index;
            prefix = null;
        }
        return this.step(ref, step, length, container, prefix, nameSpaces);
    }

    protected final EObject referent(Ref path) {
        return this.referent(path.ref, path.nameSpaces);
    }

    protected final Type typeXSI() {
        return this.typedXSI() ? this.typeHelper.getType(this.nameSpace, this.name) : null;
    }

    protected final Type globalElementType(String nameSpace, String name) {
        return this.xsdHelper.getGlobalProperty(nameSpace, name, true).getType();
    }

    protected static class Ref
    implements EObject {
        final String ref;
        final NamespaceContext nameSpaces;

        protected Ref(String path, NamespaceContext context) {
            this.ref = path;
            this.nameSpaces = context;
        }

        public TreeIterator eAllContents() {
            return null;
        }

        public EClass eClass() {
            return null;
        }

        public EObject eContainer() {
            return null;
        }

        public EStructuralFeature eContainingFeature() {
            return null;
        }

        public EReference eContainmentFeature() {
            return null;
        }

        public EList eContents() {
            return null;
        }

        public EList eCrossReferences() {
            return null;
        }

        public Object eGet(EStructuralFeature feature) {
            return null;
        }

        public Object eGet(EStructuralFeature feature, boolean resolve) {
            return null;
        }

        public boolean eIsProxy() {
            return false;
        }

        public boolean eIsSet(EStructuralFeature feature) {
            return false;
        }

        public Resource eResource() {
            return null;
        }

        public void eSet(EStructuralFeature feature, Object newValue) {
        }

        public void eUnset(EStructuralFeature feature) {
        }

        public EList eAdapters() {
            return null;
        }

        public boolean eDeliver() {
            return false;
        }

        public void eNotify(Notification notification) {
        }

        public void eSetDeliver(boolean deliver) {
        }
    }
}

