/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.util.resource;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sdo.SDOFactory;
import org.apache.tuscany.sdo.impl.ChangeSummaryImpl;
import org.apache.tuscany.sdo.impl.ClassImpl;
import org.apache.tuscany.sdo.util.StreamDeserializer;
import org.apache.tuscany.sdo.util.resource.RecordedEventXMLStreamReader;
import org.apache.tuscany.sdo.util.resource.SDODeserializer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeFactory;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.FeatureMapEntry;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

public class ChangeSummaryStreamDeserializer
extends SDODeserializer {
    protected Collection forwardReferences;
    Collection objectChangesCollection;
    Collection objectMapChanges;
    Collection deletedDataObjects;
    private ChangeFactory changeFactory;
    private SDOFactory changeSettingFactory;
    ChangeSummaryImpl changeSummary;
    protected boolean logging;
    protected PropertyMapChanges propertyMapChanges;
    static /* synthetic */ Class class$org$apache$tuscany$sdo$util$resource$SDODeserializer$Ref;

    protected final ObjectChanges newObjectChanges(Collection featureChanges) {
        ObjectChanges objectChanges = new ObjectChanges();
        objectChanges.featureChanges = featureChanges;
        if (this.objectChangesCollection == null) {
            this.objectChangesCollection = new ArrayList();
        }
        this.objectChangesCollection.add(objectChanges);
        return objectChanges;
    }

    private void logPropertyChange(Collection featureChanges, EStructuralFeature feature, Object value, boolean set) {
        if (this.changeSettingFactory == null) {
            featureChanges.add(this.changeFactory.createFeatureChange(feature, value, set));
        } else {
            featureChanges.add(this.changeSettingFactory.createChangeSummarySetting(feature, value, set));
        }
    }

    void unsetProperty(Collection featureChanges, String unset, int begin, int index, Type type) {
        this.logPropertyChange(featureChanges, (EStructuralFeature)type.getProperty(unset.substring(begin, index)), (Object)null, false);
    }

    static boolean isWhitespace(String unset, int index) {
        return Character.isWhitespace(unset.charAt(index));
    }

    protected final Collection unsetProperties(EObject referent, String unset, Type type) {
        Map.Entry entry = this.changeFactory.createEObjectToChangesMapEntry(referent);
        this.objectMapChanges.add(entry);
        Collection featureChanges = (Collection)entry.getValue();
        if (unset == null) {
            return featureChanges;
        }
        int end = unset.length();
        if (end != 0) {
            int begin = 0;
            int index = 1;
            while (true) {
                if (index == end) {
                    this.unsetProperty(featureChanges, unset, begin, index, type);
                    break;
                }
                if (ChangeSummaryStreamDeserializer.isWhitespace(unset, index)) {
                    this.unsetProperty(featureChanges, unset, begin, index, type);
                    do {
                        if (++index == end) continue;
                        return featureChanges;
                    } while (ChangeSummaryStreamDeserializer.isWhitespace(unset, index));
                    begin = index;
                }
                ++index;
            }
        }
        return featureChanges;
    }

    private Object value(EStructuralFeature containing, Object containment, Object value) {
        return FeatureMapUtil.isFeatureMap((EStructuralFeature)containing) ? this.changeFactory.createFeatureMapEntry((EStructuralFeature)containment, value) : value;
    }

    private void logPropertyChange(Collection featureChanges, Object containing, Object containment, Object value) {
        EStructuralFeature feature = (EStructuralFeature)containing;
        this.logPropertyChange(featureChanges, feature, this.value(feature, containment, value), true);
    }

    private void logPropertyChange(Collection featureChanges, Object property, Object value) {
        this.logPropertyChange(featureChanges, property, (Object)this.propertyInSequence, value);
    }

    void logAttributeChange(Collection featureChanges, Property property, String literal, NamespaceContext nameSpaces) {
        this.logPropertyChange(featureChanges, property, ChangeSummaryStreamDeserializer.value(property.getType(), literal, nameSpaces));
    }

    protected final void logAttributeChange(Collection featureChanges, String property, Type type, String value, NamespaceContext nameSpaces) {
        this.logAttributeChange(featureChanges, this.getProperty(type, property), value, nameSpaces);
    }

    protected final void logAttributeChange(Collection featureChanges, String nameSpace, String name, Type type, String value, NamespaceContext nameSpaces) {
        this.logAttributeChange(featureChanges, this.getProperty(type, nameSpace, name, false), value, nameSpaces);
    }

    protected final String ref() {
        return this.reader.getAttributeValue("commonj.sdo", "ref");
    }

    protected Object load(XMLStreamReader reader, Map options) throws XMLStreamException {
        Object value = super.load(reader, options);
        this.deletedDataObjects.add(value);
        return value;
    }

    protected final void getChangeSummary(DataObject rootObject) {
        this.changeSummary = (ChangeSummaryImpl)rootObject.getChangeSummary();
    }

    protected final void addPropertyChange(Collection list, Object value, Object containing) {
        list.add(this.value((EStructuralFeature)containing, this.propertyInSequence, value));
    }

    public final void begin(DataObject rootObject, HelperContext scope, XMLStreamReader reader) throws XMLStreamException {
        this.initialize(reader, scope, rootObject);
        if (this.typedXSI()) {
            this.changeSummary = (ChangeSummaryImpl)scope.getDataFactory().create(this.nameSpace, this.name);
            if (this.changeSummary == null) {
                this.getChangeSummary(rootObject);
            } else {
                Property csp = ((ClassImpl)rootObject.getType()).getChangeSummaryProperty();
                rootObject.set(csp, (Object)this.changeSummary);
                this.changeSummary.setDataObject(rootObject);
            }
        } else {
            this.getChangeSummary(rootObject);
        }
        ChangeSummaryImpl changeDescription = this.changeSummary;
        this.logging = Boolean.valueOf(reader.getAttributeValue(null, "logging"));
        if (this.forwardReferences != null) {
            this.forwardReferences.clear();
        }
        if (this.objectChangesCollection != null) {
            this.objectChangesCollection.clear();
        }
        if (1 == reader.nextTag()) {
            this.objectMapChanges = changeDescription.getObjectChanges();
            this.deletedDataObjects = changeDescription.getObjectsToAttach();
            EFactory factory = changeDescription.eClass().getEPackage().getEFactoryInstance();
            this.changeFactory = factory instanceof ChangeFactory ? (ChangeFactory)factory : ChangeFactory.eINSTANCE;
            this.changeSettingFactory = factory instanceof SDOFactory ? (SDOFactory)factory : null;
            block0: do {
                String ref = this.ref();
                String unset = reader.getAttributeValue("commonj.sdo", "unset");
                int attributes = reader.getAttributeCount();
                NamespaceContext nameSpaces = reader.getNamespaceContext();
                EObject referent = this.referent(ref, nameSpaces);
                if (referent == null) {
                    ForwardReference forwardReference = new ForwardReference(ref, nameSpaces, unset);
                    if (this.forwardReferences == null) {
                        this.forwardReferences = new ArrayList();
                    }
                    this.forwardReferences.add(forwardReference);
                    do {
                        StreamDeserializer.Attribute attribute;
                        String nameSpace = reader.getAttributeNamespace(--attributes);
                        String name = reader.getAttributeLocalName(attributes);
                        String value = reader.getAttributeValue(attributes);
                        if (nameSpace == null) {
                            attribute = new StreamDeserializer.Attribute();
                            attribute.name = name;
                            attribute.value = value;
                            if (forwardReference.attributes == null) {
                                forwardReference.attributes = new ArrayList();
                            }
                            forwardReference.attributes.add(attribute);
                            continue;
                        }
                        if ("commonj.sdo".equals(nameSpace) && ("ref".equals(name) || "unset".equals(name))) continue;
                        attribute = new StreamDeserializer.QualifiedAttribute();
                        ((StreamDeserializer.QualifiedAttribute)attribute).name = name;
                        ((StreamDeserializer.QualifiedAttribute)attribute).value = value;
                        ((StreamDeserializer.QualifiedAttribute)attribute).nameSpace = nameSpace;
                        if (forwardReference.qualifiedAttributes == null) {
                            forwardReference.qualifiedAttributes = new ArrayList();
                        }
                        forwardReference.qualifiedAttributes.add(attribute);
                    } while (attributes != 0);
                    while (1 == reader.nextTag()) {
                        Tag tag = new Tag(reader);
                        if (forwardReference.tags == null) {
                            forwardReference.tags = new ArrayList();
                        }
                        forwardReference.tags.add(tag);
                        tag.ref = this.ref();
                        if (tag.ref != null) continue;
                        Type xsi = this.typeXSI();
                        if (xsi == null) {
                            if (tag.nameSpace != null) {
                                tag.value = this.value(this.globalElementType(tag.nameSpace, tag.name.getLocalPart()));
                                continue;
                            }
                            if (!tag.record(reader)) continue;
                            continue block0;
                        }
                        tag.value = this.value(xsi);
                    }
                } else {
                    Type type = ((DataObject)referent).getType();
                    Collection featureChanges = this.unsetProperties(referent, unset, type);
                    do {
                        String nameSpace = reader.getAttributeNamespace(--attributes);
                        String name = reader.getAttributeLocalName(attributes);
                        String value = reader.getAttributeValue(attributes);
                        if (nameSpace == null) {
                            this.logAttributeChange(featureChanges, name, type, value, nameSpaces);
                            continue;
                        }
                        if ("commonj.sdo".equals(nameSpace) && ("ref".equals(name) || "unset".equals(name))) continue;
                        this.logAttributeChange(featureChanges, nameSpace, name, type, value, nameSpaces);
                    } while (attributes != 0);
                    if (1 != reader.nextTag()) continue;
                    ObjectChanges objectChanges = null;
                    do {
                        Object value;
                        String nameSpace = reader.getNamespaceURI();
                        String name = reader.getLocalName();
                        Property property = this.getProperty(nameSpace, name, type);
                        boolean many = property.isMany();
                        ref = this.ref();
                        if (ref == null) {
                            Type xsi = this.typeXSI();
                            value = xsi != null ? this.value(xsi) : (nameSpace == null ? this.value(reader) : this.value((xsi = this.globalElementType(nameSpace, name)) == null ? this.propertyInSequence.getType() : xsi));
                        } else {
                            nameSpaces = reader.getNamespaceContext();
                            reader.nextTag();
                            value = this.referent(ref, nameSpaces);
                            if (value == null) {
                                if (!many) {
                                    ElementChange elementChange = new ElementChange(ref, nameSpaces, property, this.propertyInSequence);
                                    if (objectChanges == null) {
                                        objectChanges = this.newObjectChanges(featureChanges);
                                        objectChanges.newElementChanges();
                                    } else if (objectChanges.elementChanges == null) {
                                        objectChanges.newElementChanges();
                                    }
                                    objectChanges.elementChanges.add(elementChange);
                                    continue;
                                }
                                value = new SDODeserializer.Ref(ref, nameSpaces);
                            }
                        }
                        if (many) {
                            Collection list;
                            if (objectChanges == null) {
                                objectChanges = this.newObjectChanges(featureChanges);
                                list = objectChanges.newList(property);
                            } else {
                                list = objectChanges.lists == null ? objectChanges.newList(property) : objectChanges.get(property);
                            }
                            this.addPropertyChange(list, value, property);
                            continue;
                        }
                        this.logPropertyChange(featureChanges, property, value);
                    } while (1 == reader.nextTag());
                }
            } while (1 == reader.nextTag());
        }
    }

    private static boolean sequence(Object listChanges) {
        return FeatureMapUtil.isFeatureMap((EStructuralFeature)((FeatureChange)((EStructuralFeature.Setting)listChanges).getEObject()).getFeature());
    }

    private ListChange createListChange(ChangeKind changeKind, int index, Collection listChanges) {
        ListChange listChange = this.changeFactory.createListChange();
        listChange.setKind(changeKind);
        listChange.setIndex(index);
        listChanges.add(listChange);
        return listChange;
    }

    Collection add(Collection adds, int change, Collection listChanges, Object value) {
        if (adds == null) {
            ListChange listChange = this.createListChange(ChangeKind.ADD_LITERAL, change, listChanges);
            adds = ChangeSummaryStreamDeserializer.sequence(listChanges) ? listChange.getFeatureMapEntryValues() : listChange.getValues();
        }
        adds.add(value);
        return adds;
    }

    private int remove(int change, Collection listChanges, List list, int begin, int end) {
        ListChange listChange = this.createListChange(ChangeKind.REMOVE_LITERAL, change, listChanges);
        if (ChangeSummaryStreamDeserializer.sequence(listChanges)) {
            EList removes = listChange.getFeatureMapEntryValues();
            do {
                FeatureMap.Entry fme = (FeatureMap.Entry)list.get(begin);
                removes.add(this.changeFactory.createFeatureMapEntry(fme.getEStructuralFeature(), fme.getValue()));
            } while (++begin != end);
            return begin;
        }
        EList removes = listChange.getValues();
        do {
            removes.add(list.get(begin));
        } while (++begin != end);
        return begin;
    }

    int remove(int begin, int end, int change, Collection listChanges, List list) {
        return begin == end ? begin : this.remove(change, listChanges, list, begin, end);
    }

    protected final void logManyChanges(PropertyMapChanges propertyMapChanges, EObject referent, Collection featureChanges) {
        Iterator lists = propertyMapChanges.lists.entrySet().iterator();
        while (lists.hasNext()) {
            int end;
            int begin;
            Map.Entry entry = lists.next();
            EStructuralFeature property = (EStructuralFeature)entry.getKey();
            Iterator values = ((Collection)entry.getValue()).iterator();
            Object value = referent.eGet(property);
            List list = value instanceof FeatureMap.Internal.Wrapper ? ((FeatureMap.Internal.Wrapper)value).featureMap() : (List)value;
            int change = 0;
            FeatureChange featureChange = this.changeSettingFactory == null ? this.changeFactory.createFeatureChange() : (FeatureChange)this.changeSettingFactory.createChangeSummarySetting();
            featureChange.setFeature(property);
            EList listChanges = featureChange.getListChanges();
            Collection adds = null;
            featureChanges.add(featureChange);
            if (property.getEType() instanceof EClass) {
                begin = 0;
                end = list.size();
                while (values.hasNext()) {
                    value = values.next();
                    if (value.getClass() == (class$org$apache$tuscany$sdo$util$resource$SDODeserializer$Ref == null ? ChangeSummaryStreamDeserializer.class$("org.apache.tuscany.sdo.util.resource.SDODeserializer$Ref") : class$org$apache$tuscany$sdo$util$resource$SDODeserializer$Ref) && (value = this.referent((SDODeserializer.Ref)value)) == null) continue;
                    int index = begin;
                    while (true) {
                        if (index == end) {
                            adds = this.add(adds, change, (Collection)listChanges, value);
                            break;
                        }
                        if (list.get(index) == value) {
                            begin = this.remove(begin, index, change, (Collection)listChanges, list);
                            ++begin;
                            adds = null;
                            break;
                        }
                        ++index;
                    }
                    ++change;
                }
                this.remove(begin, end, change, (Collection)listChanges, list);
                continue;
            }
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)property)) {
                begin = 0;
                end = list.size();
                while (values.hasNext()) {
                    FeatureMapEntry featureMapEntry = (FeatureMapEntry)values.next();
                    value = featureMapEntry.getValue();
                    if (value.getClass() == (class$org$apache$tuscany$sdo$util$resource$SDODeserializer$Ref == null ? ChangeSummaryStreamDeserializer.class$("org.apache.tuscany.sdo.util.resource.SDODeserializer$Ref") : class$org$apache$tuscany$sdo$util$resource$SDODeserializer$Ref) && (value = this.referent((SDODeserializer.Ref)value)) == null) continue;
                    EStructuralFeature feature = featureMapEntry.getFeature();
                    Comparator equality = ((Type)feature.getEType()).isDataType() ? (value == null ? EQUAL_NULL : EQUAL) : SAME;
                    int index = begin;
                    while (true) {
                        if (index == end) {
                            adds = this.add(adds, change, (Collection)listChanges, featureMapEntry);
                            break;
                        }
                        FeatureMap.Entry fme = (FeatureMap.Entry)list.get(index);
                        if (feature == fme.getEStructuralFeature() && equality.compare(fme.getValue(), value) == 0) {
                            begin = this.remove(begin, index, change, (Collection)listChanges, list);
                            ++begin;
                            adds = null;
                            break;
                        }
                        ++index;
                    }
                    ++change;
                }
                this.remove(begin, end, change, (Collection)listChanges, list);
                continue;
            }
            while (values.hasNext()) {
                value = values.next();
                int index = list.indexOf(value);
                switch (index) {
                    case -1: {
                        adds = this.add(adds, change, (Collection)listChanges, value);
                        break;
                    }
                    default: {
                        this.remove(change, (Collection)listChanges, list, 0, index);
                    }
                    case 0: {
                        list = list.subList(++index, list.size());
                        adds = null;
                    }
                }
                ++change;
            }
            this.remove(0, list.size(), change, (Collection)listChanges, list);
        }
    }

    public final ChangeSummary end() throws XMLStreamException {
        Iterator iterator;
        if (this.forwardReferences != null) {
            iterator = this.forwardReferences.iterator();
            while (iterator.hasNext()) {
                StreamDeserializer.Attribute attribute;
                Iterator attributes;
                ForwardReference forwardReference = (ForwardReference)iterator.next();
                EObject referent = this.referent(forwardReference);
                if (referent == null) continue;
                Type type = ((DataObject)referent).getType();
                Collection featureChanges = this.unsetProperties(referent, forwardReference.unset, type);
                if (forwardReference.attributes != null) {
                    attributes = forwardReference.attributes.iterator();
                    while (attributes.hasNext()) {
                        attribute = (StreamDeserializer.Attribute)attributes.next();
                        this.logAttributeChange(featureChanges, attribute.name, type, attribute.value, forwardReference.nameSpaces);
                    }
                }
                if (forwardReference.qualifiedAttributes != null) {
                    attributes = forwardReference.qualifiedAttributes.iterator();
                    while (attributes.hasNext()) {
                        attribute = (StreamDeserializer.QualifiedAttribute)attributes.next();
                        this.logAttributeChange(featureChanges, ((StreamDeserializer.QualifiedAttribute)attribute).nameSpace, ((StreamDeserializer.QualifiedAttribute)attribute).name, type, ((StreamDeserializer.QualifiedAttribute)attribute).value, forwardReference.nameSpaces);
                    }
                }
                if (forwardReference.tags == null) continue;
                if (this.propertyMapChanges != null) {
                    this.propertyMapChanges.lists.clear();
                }
                Iterator tags = forwardReference.tags.iterator();
                while (tags.hasNext()) {
                    Tag tag = (Tag)tags.next();
                    Property property = this.getProperty(tag.nameSpace, tag.name.getLocalPart(), type);
                    if (tag.ref != null) {
                        tag.value = this.referent(tag.ref, tag.nameSpaceContext);
                    } else if (tag.events != null) {
                        tag.value = this.value(this.play(tag));
                    }
                    if (property.isMany()) {
                        Collection list;
                        if (this.propertyMapChanges == null) {
                            this.propertyMapChanges = new PropertyMapChanges();
                            list = this.propertyMapChanges.newList(property);
                        } else {
                            list = this.propertyMapChanges.get(property);
                        }
                        this.addPropertyChange(list, tag.value, property);
                        continue;
                    }
                    this.logPropertyChange(featureChanges, property, tag.value);
                }
                if (this.propertyMapChanges == null) continue;
                this.logManyChanges(this.propertyMapChanges, referent, featureChanges);
            }
        }
        if (this.objectChangesCollection != null) {
            iterator = this.objectChangesCollection.iterator();
            while (iterator.hasNext()) {
                ObjectChanges objectChanges = (ObjectChanges)iterator.next();
                if (objectChanges.elementChanges != null) {
                    Iterator elementChanges = objectChanges.elementChanges.iterator();
                    while (elementChanges.hasNext()) {
                        ElementChange elementChange = (ElementChange)elementChanges.next();
                        EObject value = this.referent(elementChange);
                        if (value == null) continue;
                        this.logPropertyChange(objectChanges.featureChanges, elementChange.containing, elementChange.containment, value);
                    }
                }
                if (objectChanges.lists == null) continue;
                this.logManyChanges(objectChanges, (EObject)((Map.Entry)((EStructuralFeature.Setting)objectChanges.featureChanges).getEObject()).getKey(), objectChanges.featureChanges);
            }
        }
        if (this.logging) {
            this.changeSummary.resumeLogging();
        }
        return this.changeSummary;
    }

    protected static final class Tag
    extends RecordedEventXMLStreamReader.Tag {
        protected String ref;
        protected Object value;

        protected Tag(XMLStreamReader reader) {
            super(reader);
        }
    }

    static final class ObjectChanges
    extends PropertyMapChanges {
        Collection elementChanges;
        Collection featureChanges;

        ObjectChanges() {
        }

        protected final void newElementChanges() {
            this.elementChanges = new ArrayList();
        }
    }

    private static class PropertyMapChanges {
        Map lists;

        private PropertyMapChanges() {
        }

        Collection put(Object property) {
            ArrayList list = new ArrayList();
            this.lists.put(property, list);
            return list;
        }

        protected final Collection get(Object property) {
            Object list = this.lists.get(property);
            return list == null ? this.put(property) : (Collection)list;
        }

        protected final Collection newList(Object property) {
            this.lists = new HashMap();
            return this.put(property);
        }
    }

    private static final class ElementChange
    extends SDODeserializer.Ref {
        private final Object containing;
        private final Object containment;

        private ElementChange(String ref, NamespaceContext nameSpaces, Object property, Object propertyInSequence) {
            super(ref, nameSpaces);
            this.containing = property;
            this.containment = propertyInSequence;
        }
    }

    static final class ForwardReference
    extends SDODeserializer.Ref {
        final String unset;
        Collection attributes;
        Collection qualifiedAttributes;
        Collection tags;

        ForwardReference(String ref, NamespaceContext nameSpaces, String u) {
            super(ref, nameSpaces);
            this.unset = u;
        }
    }
}

