/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sdo.api.SDOUtil;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.model.ModelFactory;
import org.apache.tuscany.sdo.model.Type;
import org.apache.tuscany.sdo.model.impl.PropertyImpl;
import org.apache.tuscany.sdo.model.internal.InternalFactory;
import org.apache.tuscany.sdo.model.java.JavaFactory;
import org.apache.tuscany.sdo.model.xml.XMLFactory;
import org.apache.tuscany.sdo.util.DataObjectUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public class TypeHelperImpl
implements TypeHelper {
    protected HelperContext helperContext;
    private ExtendedMetaData extendedMetaData;
    protected static Set builtInModels = null;
    public static final String TUSCANY_NO_URI = "http://tuscany-no-uri";

    public static Set getBuiltInModels() {
        if (builtInModels == null) {
            builtInModels = new HashSet();
            builtInModels.add(ModelFactory.INSTANCE);
            builtInModels.add(JavaFactory.INSTANCE);
            builtInModels.add(XMLFactory.INSTANCE);
            builtInModels.add(InternalFactory.INSTANCE);
        }
        return builtInModels;
    }

    public ExtendedMetaData getExtendedMetaData() {
        return this.extendedMetaData;
    }

    public TypeHelperImpl(HelperContext hc) {
        this.helperContext = hc;
        this.extendedMetaData = ((HelperContextImpl)hc).extendedMetaData;
        TypeHelperImpl.getBuiltInModels();
    }

    public commonj.sdo.Type getType(String uri, String typeName) {
        EPackage ePackage = this.extendedMetaData.getPackage(uri);
        if (ePackage != null) {
            EClassifier eClassifier = ePackage.getEClassifier(typeName);
            if (eClassifier == null) {
                eClassifier = this.extendedMetaData.getType(ePackage, typeName);
            }
            return (commonj.sdo.Type)eClassifier;
        }
        return null;
    }

    private Method getGetStaticTypeMethod(Class classObj) {
        try {
            Method method = classObj.getMethod("getStaticType", null);
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }

    public commonj.sdo.Type getType(Class interfaceClass) {
        commonj.sdo.Type type = SDOUtil.getJavaSDOType((Class)interfaceClass);
        if (type != null) {
            return type;
        }
        Class sdoTypeImplClass = interfaceClass;
        Method getStaticTypeMethod = this.getGetStaticTypeMethod(interfaceClass);
        if (getStaticTypeMethod == null) {
            String sdoTypeImplClassName = interfaceClass.getName();
            if (!sdoTypeImplClassName.endsWith("Impl")) {
                sdoTypeImplClass = DataObjectUtil.getImplementationClass(interfaceClass, false);
                if (sdoTypeImplClass == null) {
                    return null;
                }
                getStaticTypeMethod = this.getGetStaticTypeMethod(sdoTypeImplClass);
                if (getStaticTypeMethod == null) {
                    return null;
                }
            } else {
                return null;
            }
        }
        try {
            Object implInstance = sdoTypeImplClass.newInstance();
            return (commonj.sdo.Type)getStaticTypeMethod.invoke(implInstance, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public commonj.sdo.Type define(DataObject type) {
        if (!(type instanceof Type)) {
            throw new IllegalArgumentException();
        }
        Type modeledType = (Type)type;
        boolean isDataType = modeledType.isDataType();
        commonj.sdo.Type definedType = SDOUtil.createType((HelperContext)this.helperContext, (String)modeledType.getUri(), (String)modeledType.getName(), (boolean)isDataType);
        if (definedType == null) {
            return this.getType(modeledType.getUri(), modeledType.getName());
        }
        SDOUtil.setJavaClassName((commonj.sdo.Type)definedType, (String)modeledType.getInstanceClassName());
        if (!isDataType) {
            SDOUtil.setSequenced((commonj.sdo.Type)definedType, (boolean)modeledType.isSequenced());
            SDOUtil.setOpen((commonj.sdo.Type)definedType, (boolean)modeledType.isOpen());
            SDOUtil.setAbstract((commonj.sdo.Type)definedType, (boolean)modeledType.isAbstract());
            Iterator iter = modeledType.getBaseType().iterator();
            while (iter.hasNext()) {
                commonj.sdo.Type baseType = this.getDefinedType((Type)iter.next());
                SDOUtil.addBaseType((commonj.sdo.Type)definedType, (commonj.sdo.Type)baseType);
            }
            iter = modeledType.getAliasName().iterator();
            while (iter.hasNext()) {
                String aliasName = (String)iter.next();
                SDOUtil.addAliasName((commonj.sdo.Type)definedType, (String)aliasName);
            }
            iter = modeledType.getProperty().iterator();
            while (iter.hasNext()) {
                org.apache.tuscany.sdo.model.Property modeledProperty = (org.apache.tuscany.sdo.model.Property)iter.next();
                commonj.sdo.Type propertyType = this.getDefinedType(modeledProperty.getType_());
                Property definedProperty = SDOUtil.createProperty((commonj.sdo.Type)definedType, (String)modeledProperty.getName(), (commonj.sdo.Type)propertyType);
                this.initializeProperty(definedProperty, modeledProperty);
            }
            if (!SDOUtil.isDocumentRoot((commonj.sdo.Type)definedType)) {
                String propertyName = definedType.getName();
                if (!Character.isLowerCase(propertyName.charAt(0))) {
                    propertyName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
                }
                Property globalProperty = SDOUtil.createOpenContentProperty((HelperContext)this.helperContext, (String)definedType.getURI(), (String)propertyName, (commonj.sdo.Type)definedType);
                SDOUtil.setContainment((Property)globalProperty, (boolean)true);
            }
        }
        this.addTypeInstanceProperties(definedType, (DataObject)modeledType);
        return definedType;
    }

    protected void addTypeInstanceProperties(commonj.sdo.Type definedType, DataObject modeledType) {
        List instanceProperties = SDOUtil.getOpenContentProperties((DataObject)modeledType);
        Iterator iter = instanceProperties.iterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            SDOUtil.addTypeInstanceProperty((commonj.sdo.Type)definedType, (Property)property, (Object)modeledType.get(property));
        }
    }

    protected void addPropertyInstanceProperties(Property definedProperty, DataObject modeledProperty) {
        List instanceProperties = SDOUtil.getOpenContentProperties((DataObject)modeledProperty);
        Iterator iter = instanceProperties.iterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            SDOUtil.addPropertyInstanceProperty((Property)definedProperty, (Property)property, (Object)modeledProperty.get(property));
        }
    }

    public List define(List types) {
        int count = types.size();
        ArrayList<commonj.sdo.Type> definedTypes = new ArrayList<commonj.sdo.Type>(count);
        for (int i = 0; i < count; ++i) {
            definedTypes.add(this.define((DataObject)types.get(i)));
        }
        return definedTypes;
    }

    protected commonj.sdo.Type getDefinedType(Type modeledType) {
        if (modeledType instanceof commonj.sdo.Type) {
            return (commonj.sdo.Type)modeledType;
        }
        EClassifier eClassifier = this.extendedMetaData.getType(modeledType.getUri(), modeledType.getName());
        if (eClassifier != null) {
            return (commonj.sdo.Type)eClassifier;
        }
        return this.define((DataObject)modeledType);
    }

    protected Property getDefinedProperty(org.apache.tuscany.sdo.model.Property modeledProperty) {
        if (modeledProperty instanceof Property) {
            return (Property)modeledProperty;
        }
        DataObject modeledContainingType = ((DataObject)modeledProperty).getContainer();
        commonj.sdo.Type definedContainingType = this.getDefinedType((Type)modeledContainingType);
        String propertyName = modeledProperty.getName();
        return definedContainingType.getProperty(propertyName);
    }

    protected void initializeProperty(Property newProperty, org.apache.tuscany.sdo.model.Property modeledProperty) {
        SDOUtil.setMany((Property)newProperty, (boolean)modeledProperty.isMany());
        SDOUtil.setDefault((Property)newProperty, (String)modeledProperty.getDefault_());
        SDOUtil.setReadOnly((Property)newProperty, (boolean)modeledProperty.isReadOnly());
        Iterator iter = modeledProperty.getAliasName().iterator();
        while (iter.hasNext()) {
            String aliasName = (String)iter.next();
            SDOUtil.addAliasName((Property)newProperty, (String)aliasName);
        }
        if (newProperty.getType().isDataType()) {
            Boolean isXmlElement = Boolean.TRUE;
            Sequence anyAttr = modeledProperty.getAnyAttribute();
            for (int i = 0; i < anyAttr.size(); ++i) {
                String propName;
                Property anyProp = anyAttr.getProperty(i);
                if (!"commonj.sdo/xml".equals(anyProp.getContainingType().getURI()) || !"xmlElement".equals(propName = anyProp.getName())) continue;
                isXmlElement = (Boolean)anyAttr.getValue(i);
            }
            if (!isXmlElement.booleanValue()) {
                SDOUtil.setPropertyXMLKind((Property)newProperty, (boolean)false);
            }
        } else {
            SDOUtil.setContainment((Property)newProperty, (boolean)modeledProperty.isContainment());
            if (modeledProperty.getOpposite_() != null) {
                SDOUtil.setOpposite((Property)newProperty, (Property)this.getDefinedProperty(modeledProperty.getOpposite_()));
            }
        }
        this.addPropertyInstanceProperties(newProperty, (DataObject)modeledProperty);
    }

    public Property defineOpenContentProperty(String uri, DataObject property) {
        if (!(property instanceof PropertyImpl)) {
            throw new IllegalArgumentException();
        }
        org.apache.tuscany.sdo.model.Property modeledProperty = (org.apache.tuscany.sdo.model.Property)property;
        commonj.sdo.Type propertyType = this.getDefinedType(modeledProperty.getType_());
        if (uri == null) {
            uri = TUSCANY_NO_URI;
        }
        Property newProperty = SDOUtil.createOpenContentProperty((HelperContext)this.helperContext, (String)uri, (String)modeledProperty.getName(), (commonj.sdo.Type)propertyType);
        this.initializeProperty(newProperty, modeledProperty);
        return newProperty;
    }

    public Property getOpenContentProperty(String uri, String propertyName) {
        EClass documentRoot = (EClass)this.extendedMetaData.getType(uri, "");
        return documentRoot != null ? (Property)documentRoot.getEStructuralFeature(propertyName) : null;
    }

    public HelperContext getHelperContext() {
        return this.helperContext;
    }
}

