/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.DataHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.tuscany.sdo.helper.SDOSimpleDateFormat;
import org.apache.tuscany.sdo.util.DataObjectUtil;

public class DataHelperImpl
implements DataHelper {
    public synchronized Date toDate(String dateString) {
        String durationString;
        SDOSimpleDateFormat format;
        String formatString;
        if (dateString == null) {
            return null;
        }
        Date result = null;
        boolean negative = false;
        if ((dateString = dateString.trim()).length() > 2 && dateString.charAt(0) == '-' && dateString.charAt(1) != '-') {
            negative = true;
            dateString = dateString.substring(1);
        }
        if (dateString.endsWith("Z")) {
            formatString = dateString.indexOf(46) != -1 ? new String("yyyy-MM-dd'T'HH:mm:ss'.'S'Z'") : new String("yyyy-MM-dd'T'HH:mm:ss'Z'");
            format = new SDOSimpleDateFormat(formatString);
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            result = this.checkFormat(dateString, format);
            if (result != null) {
                if (negative) {
                    return this.handleBCE(result);
                }
                return result;
            }
        }
        if (dateString.startsWith("P") && (result = this.checkFormat(durationString = dateString.replaceAll(" ", ""), format = new SDOSimpleDateFormat(formatString = this.obtainDurationFormats(durationString)))) != null) {
            if (negative) {
                return this.handleNegative(result);
            }
            return result;
        }
        formatString = this.obtainSpecificFormat(dateString);
        if (formatString != null && (result = this.checkFormat(dateString, format = new SDOSimpleDateFormat(formatString))) != null) {
            if (negative) {
                return this.handleBCE(result);
            }
            return result;
        }
        return null;
    }

    private synchronized Date checkFormat(String dateString, SDOSimpleDateFormat format) {
        SDOSimpleDateFormat compositeFormat;
        String parseString;
        String fieldsString;
        String formatPattern = format.toPattern();
        StringBuffer addedFields = new StringBuffer();
        if (!formatPattern.startsWith("P")) {
            if (formatPattern.indexOf(121) == -1) {
                addedFields.append("yyyy ");
            }
            if (formatPattern.indexOf(77) == -1) {
                addedFields.append("MM ");
            }
            if (formatPattern.indexOf(100) == -1) {
                addedFields.append("dd ");
            }
        }
        if ((fieldsString = addedFields.toString()).length() == 0) {
            parseString = dateString;
            compositeFormat = format;
        } else {
            compositeFormat = new SDOSimpleDateFormat(fieldsString);
            Date dateValue = new Date(System.currentTimeMillis());
            parseString = compositeFormat.format(dateValue) + dateString;
            compositeFormat.applyPattern(fieldsString + formatPattern);
        }
        try {
            return compositeFormat.parse(parseString);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public synchronized String obtainSpecificFormat(String dateString) {
        StringBuffer formatBuffer = new StringBuffer();
        int colonIndex = dateString.indexOf(58);
        int hyphenIndex = dateString.indexOf(45);
        if (dateString.startsWith("--")) {
            if (dateString.charAt(2) == '-') {
                formatBuffer.append("'---'dd");
            } else if (dateString.substring(2).indexOf(45) == -1) {
                formatBuffer.append("'--'MM");
            } else {
                formatBuffer.append("'--'MM'-'dd");
            }
        } else if (colonIndex == 1 || colonIndex == 2) {
            if (dateString.indexOf(46) != -1) {
                formatBuffer.append("HH:mm:ss'.'S");
            } else if (dateString.substring(colonIndex + 1).indexOf(58) != -1) {
                formatBuffer.append("HH:mm:ss");
            } else {
                formatBuffer.append("HH:mm");
            }
        } else if (hyphenIndex != -1) {
            if (dateString.substring(hyphenIndex + 1).indexOf(45) == -1) {
                formatBuffer.append("yyyy-MM");
            } else if (colonIndex != -1) {
                if (dateString.indexOf(46) != -1) {
                    formatBuffer.append("yyyy-MM-dd'T'HH:mm:ss'.'S");
                } else if (dateString.substring(colonIndex + 1).indexOf(58) != -1) {
                    formatBuffer.append("yyyy-MM-dd'T'HH:mm:ss");
                } else {
                    formatBuffer.append("yyyy-MM-dd'T'HH:mm");
                }
            } else {
                formatBuffer.append("yyyy-MM-dd");
            }
        } else if (colonIndex == -1) {
            formatBuffer.append("yyyy");
        } else {
            return null;
        }
        boolean letterFound = false;
        for (int i = 0; i < dateString.length() && !letterFound; ++i) {
            char currentChar = dateString.charAt(i);
            if (!Character.isLetter(currentChar) || currentChar == 'T') continue;
            letterFound = true;
        }
        if (letterFound) {
            formatBuffer.append(" z");
        }
        return formatBuffer.toString();
    }

    public synchronized String obtainDurationFormats(String dateString) {
        String secondPart;
        String firstPart;
        StringBuffer formatBuffer = new StringBuffer("'P'");
        int time_index = dateString.indexOf(84);
        if (time_index != -1) {
            firstPart = dateString.substring(0, time_index + 1);
            secondPart = dateString.substring(time_index);
        } else {
            firstPart = dateString;
            secondPart = null;
        }
        if (firstPart.indexOf(89) != -1) {
            formatBuffer.append("yyyy'Y'");
        }
        if (firstPart.indexOf(77) != -1) {
            formatBuffer.append("MM'M'");
        }
        if (firstPart.indexOf(68) != -1) {
            formatBuffer.append("dd'D'");
        }
        if (time_index != -1) {
            formatBuffer.append("'T'");
            if (secondPart.indexOf(72) != -1) {
                formatBuffer.append("HH'H'");
            }
            if (secondPart.indexOf(77) != -1) {
                formatBuffer.append("mm'M'");
            }
            if (secondPart.indexOf("S.") != -1) {
                formatBuffer.append("ss'S'.S");
            } else if (secondPart.indexOf(83) != -1) {
                formatBuffer.append("ss'S'");
            }
        }
        return formatBuffer.toString().replaceAll("''", "");
    }

    public synchronized Date handleNegative(Date output) {
        return new Date(0L - output.getTime());
    }

    public synchronized Date handleBCE(Date output) {
        GregorianCalendar temp = new GregorianCalendar();
        temp.setTime(output);
        temp.set(0, 0);
        return temp.getTime();
    }

    public synchronized Calendar toCalendar(String dateString) {
        return this.toCalendar(dateString, null);
    }

    public synchronized Calendar toCalendar(String dateString, Locale locale) {
        if (dateString == null) {
            return null;
        }
        Date date = this.toDate(dateString);
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = locale != null ? new GregorianCalendar(locale) : new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public synchronized String toDateTime(Date date) {
        if (date == null) {
            return null;
        }
        SDOSimpleDateFormat f = new SDOSimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
        f.setTimeZone(TimeZone.getTimeZone("UTC"));
        return f.format(date);
    }

    public synchronized String toDuration(Date date) {
        if (date == null) {
            return null;
        }
        SDOSimpleDateFormat f = new SDOSimpleDateFormat("'P'yyyy'Y' MM'M' dd'D' 'T' HH'H' mm'M' ss'S.'SSS");
        return f.format(date);
    }

    public synchronized String toTime(Date date) {
        if (date == null) {
            return null;
        }
        SDOSimpleDateFormat f = new SDOSimpleDateFormat("HH:mm:ss'.'SSS zz");
        return f.format(date);
    }

    public synchronized String toDay(Date date) {
        if (date == null) {
            return null;
        }
        SDOSimpleDateFormat f = new SDOSimpleDateFormat("---dd zz");
        return f.format(date);
    }

    public synchronized String toMonth(Date date) {
        if (date == null) {
            return null;
        }
        SDOSimpleDateFormat f = new SDOSimpleDateFormat("--MM zz");
        return f.format(date);
    }

    public synchronized String toMonthDay(Date date) {
        if (date == null) {
            return null;
        }
        SDOSimpleDateFormat f = new SDOSimpleDateFormat("--MM-dd zz");
        return f.format(date);
    }

    public synchronized String toYear(Date date) {
        if (date == null) {
            return null;
        }
        SDOSimpleDateFormat f = new SDOSimpleDateFormat("yyyy zz");
        return f.format(date);
    }

    public synchronized String toYearMonth(Date date) {
        if (date == null) {
            return null;
        }
        SDOSimpleDateFormat f = new SDOSimpleDateFormat("yyyy-MM zz");
        return f.format(date);
    }

    public synchronized String toYearMonthDay(Date date) {
        if (date == null) {
            return null;
        }
        SDOSimpleDateFormat f = new SDOSimpleDateFormat("yyyy-MM-dd zz");
        return f.format(date);
    }

    public synchronized String toDateTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toDateTime(calendar.getTime());
    }

    public synchronized String toDuration(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toDuration(calendar.getTime());
    }

    public synchronized String toTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toTime(calendar.getTime());
    }

    public synchronized String toDay(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toDay(calendar.getTime());
    }

    public synchronized String toMonth(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toMonth(calendar.getTime());
    }

    public synchronized String toMonthDay(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toMonthDay(calendar.getTime());
    }

    public synchronized String toYear(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toYear(calendar.getTime());
    }

    public synchronized String toYearMonth(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toYearMonth(calendar.getTime());
    }

    public synchronized String toYearMonthDay(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toYearMonthDay(calendar.getTime());
    }

    public Object convert(Type type, Object value) {
        Class typeClass = type.getInstanceClass();
        if (typeClass.isInstance(value)) {
            return value;
        }
        if (typeClass == BigDecimal.class) {
            return DataObjectUtil.getBigDecimal(value);
        }
        if (typeClass == BigInteger.class) {
            return DataObjectUtil.getBigInteger(value);
        }
        if (typeClass == Boolean.TYPE || typeClass == Boolean.class) {
            return new Boolean(DataObjectUtil.getBoolean(value));
        }
        if (typeClass == Byte.TYPE || typeClass == Byte.class) {
            return new Byte(DataObjectUtil.getByte(value));
        }
        if (typeClass == [B.class) {
            return DataObjectUtil.getBytes(value);
        }
        if (typeClass == Character.TYPE || typeClass == Character.class) {
            return new Character(DataObjectUtil.getChar(value));
        }
        if (typeClass == Date.class) {
            return DataObjectUtil.getDate(value);
        }
        if (typeClass == Double.TYPE || typeClass == Double.class) {
            return new Double(DataObjectUtil.getDouble(value));
        }
        if (typeClass == Float.TYPE || typeClass == Float.class) {
            return new Float(DataObjectUtil.getFloat(value));
        }
        if (typeClass == Integer.TYPE || typeClass == Integer.class) {
            return new Integer(DataObjectUtil.getInt(value));
        }
        if (typeClass == Long.TYPE || typeClass == Long.class) {
            return new Long(DataObjectUtil.getLong(value));
        }
        if (typeClass == Short.TYPE || typeClass == Short.class) {
            return new Short(DataObjectUtil.getShort(value));
        }
        if (typeClass == String.class) {
            return DataObjectUtil.getString(value);
        }
        throw new IllegalArgumentException();
    }

    public Object convert(Property property, Object value) {
        Type type = property.getType();
        if (!property.isMany()) {
            return this.convert(type, value);
        }
        List listValue = (List)value;
        ArrayList<Object> listResult = new ArrayList<Object>();
        Iterator iter = listValue.iterator();
        while (iter.hasNext()) {
            listResult.add(this.convert(type, iter.next()));
        }
        return listResult;
    }
}

