/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.web.javascript;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.web.javascript.ComponentJavaScriptGenerator;
import org.apache.tuscany.sca.web.javascript.ComponentJavaScriptGeneratorExtensionPoint;

public class DefaultComponentJavaScriptGeneratorExtensionPoint
implements ComponentJavaScriptGeneratorExtensionPoint {
    private final List<ComponentJavaScriptGenerator> generators = new ArrayList<ComponentJavaScriptGenerator>();
    private final Map<QName, ComponentJavaScriptGenerator> generatorsByQName = new HashMap<QName, ComponentJavaScriptGenerator>();
    private ExtensionPointRegistry extensionPoints;
    private Monitor monitor = null;
    private boolean loaded = false;

    public DefaultComponentJavaScriptGeneratorExtensionPoint(ExtensionPointRegistry extensionPoints) {
        this.extensionPoints = extensionPoints;
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        MonitorFactory monitorFactory = (MonitorFactory)utilities.getUtility(MonitorFactory.class);
        if (monitorFactory != null) {
            this.monitor = monitorFactory.createMonitor();
        }
    }

    private void error(String message, Object model, Exception ex) {
    }

    @Override
    public void addComponentJavaScriptGenerator(ComponentJavaScriptGenerator componentScriptGenerator) {
        if (componentScriptGenerator.getQName() != null) {
            this.generatorsByQName.put(componentScriptGenerator.getQName(), componentScriptGenerator);
        }
        this.generators.add(componentScriptGenerator);
    }

    @Override
    public void removeComponentJavaScriptGenerator(ComponentJavaScriptGenerator componentScriptGenerator) {
        if (componentScriptGenerator.getQName() != null) {
            this.generatorsByQName.remove(componentScriptGenerator.getQName());
        }
        this.generators.remove(componentScriptGenerator);
    }

    @Override
    public ComponentJavaScriptGenerator getComponentJavaScriptGenerator(QName bindingName) {
        this.loadFactories();
        return this.generatorsByQName.get(bindingName);
    }

    @Override
    public List<ComponentJavaScriptGenerator> getComponentJavaScriptGenerators() {
        this.loadFactories();
        return this.generators;
    }

    private synchronized void loadFactories() {
        if (this.loaded) {
            return;
        }
        Collection factoryDeclarations = null;
        try {
            factoryDeclarations = this.extensionPoints.getServiceDiscovery().getServiceDeclarations(ComponentJavaScriptGenerator.class);
        }
        catch (IOException e) {
            IllegalStateException ie = new IllegalStateException(e);
            this.error("IllegalStateException", factoryDeclarations, ie);
            throw ie;
        }
        for (ServiceDeclaration processorDeclaration : factoryDeclarations) {
            ComponentJavaScriptGenerator generator = null;
            try {
                Class generatorClass = processorDeclaration.loadClass();
                Constructor constructor = generatorClass.getConstructor(ExtensionPointRegistry.class);
                generator = (ComponentJavaScriptGenerator)constructor.newInstance(this.extensionPoints);
            }
            catch (Exception e) {
                IllegalStateException ie = new IllegalStateException(e);
                this.error("IllegalStateException", generator, ie);
                throw ie;
            }
            this.addComponentJavaScriptGenerator(generator);
        }
        this.loaded = true;
    }
}

