/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.wsdl.xml;

import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;

public class WSDLDocumentProcessor
implements URLArtifactProcessor<WSDLDefinition> {
    public static final QName WSDL11 = new QName("http://schemas.xmlsoap.org/wsdl/", "definitions");
    public static final QName WSDL11_IMPORT = new QName("http://schemas.xmlsoap.org/wsdl/", "import");
    public static final QName XSD = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    private XMLInputFactory inputFactory;
    private StAXHelper helper;
    private WSDLFactory factory;
    private XSDFactory xsdFactory;

    public WSDLDocumentProcessor(ExtensionPointRegistry registry, StAXArtifactProcessor processor) {
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.factory = (WSDLFactory)modelFactories.getFactory(WSDLFactory.class);
        this.xsdFactory = (XSDFactory)modelFactories.getFactory(XSDFactory.class);
        this.inputFactory = (XMLInputFactory)modelFactories.getFactory(XMLInputFactory.class);
        this.helper = StAXHelper.getInstance((ExtensionPointRegistry)registry);
    }

    private void error(Monitor monitor, String message, Object model, Exception ex) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "interface-wsdlxml-validation-messages", Problem.Severity.ERROR, model, message, (Throwable)ex);
            monitor.problem(problem);
        }
    }

    public WSDLDefinition read(URL contributionURL, URI artifactURI, URL artifactURL, ProcessorContext context) throws ContributionReadException {
        try {
            WSDLDefinition definition = this.indexRead(artifactURL);
            definition.setURI(artifactURI);
            return definition;
        }
        catch (Exception e) {
            ContributionReadException ce = new ContributionReadException((Throwable)e);
            this.error(context.getMonitor(), "ContributionReadException", artifactURL, (Exception)ce);
            return null;
        }
    }

    public void resolve(WSDLDefinition model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (model == null) {
            return;
        }
        Monitor monitor = context.getMonitor();
        Definition definition = model.getDefinition();
        if (definition != null) {
            for (Object imports : definition.getImports().values()) {
                List importList = (List)imports;
                for (Object i : importList) {
                    URI uri;
                    Import imp = (Import)i;
                    if (imp.getDefinition() != null) continue;
                    if (imp.getLocationURI() == null) {
                        WSDLDefinition proxy = this.factory.createWSDLDefinition();
                        proxy.setUnresolved(true);
                        proxy.setNamespace(imp.getNamespaceURI());
                        WSDLDefinition resolved = (WSDLDefinition)resolver.resolveModel(WSDLDefinition.class, (Object)proxy, context);
                        if (resolved == null || resolved.isUnresolved()) continue;
                        imp.setDefinition(resolved.getDefinition());
                        if (model.getImportedDefinitions().contains(resolved)) continue;
                        model.getImportedDefinitions().add(resolved);
                        continue;
                    }
                    String location = imp.getLocationURI();
                    if (location.indexOf(32) != -1) {
                        location = location.replace(" ", "%20");
                    }
                    if ((uri = URI.create(location)).isAbsolute()) {
                        try {
                            WSDLDefinition resolved = this.read(null, uri, uri.toURL(), context);
                            imp.setDefinition(resolved.getDefinition());
                            if (model.getImportedDefinitions().contains(resolved)) continue;
                            model.getImportedDefinitions().add(resolved);
                        }
                        catch (Exception e) {
                            ContributionResolveException ce = new ContributionResolveException((Throwable)e);
                            this.error(monitor, "ContributionResolveException", resolver, (Exception)ce);
                        }
                        continue;
                    }
                    if (location.startsWith("/")) {
                        location = location.substring(1);
                        continue;
                    }
                    URI baseURI = URI.create(model.getDefinition().getDocumentBaseURI());
                    URI locationURI = baseURI.resolve(location);
                    try {
                        WSDLDefinition resolved = this.read(null, locationURI, locationURI.toURL(), context);
                        imp.setDefinition(resolved.getDefinition());
                        if (model.getImportedDefinitions().contains(resolved)) continue;
                        model.getImportedDefinitions().add(resolved);
                    }
                    catch (Exception e) {
                        ContributionResolveException ce = new ContributionResolveException((Throwable)e);
                        this.error(monitor, "ContributionResolveException", resolver, (Exception)ce);
                    }
                }
            }
        }
    }

    public String getArtifactType() {
        return ".wsdl";
    }

    public Class<WSDLDefinition> getModelType() {
        return WSDLDefinition.class;
    }

    protected WSDLDefinition indexRead(URL doc) throws Exception {
        WSDLDefinition wsdlDefinition = this.factory.createWSDLDefinition();
        wsdlDefinition.setUnresolved(true);
        wsdlDefinition.setLocation(doc.toURI());
        StAXHelper.Attribute attr1 = new StAXHelper.Attribute(WSDL11, "targetNamespace");
        StAXHelper.Attribute attr2 = new StAXHelper.Attribute(XSD, "targetNamespace");
        StAXHelper.Attribute[] attrs = this.helper.readAttributes(doc, new StAXHelper.Attribute[]{attr1, attr2});
        wsdlDefinition.setNamespace((String)attr1.getValues().get(0));
        wsdlDefinition.setUnresolved(false);
        wsdlDefinition.setDefinition(null);
        int index = 0;
        for (String tns : attr2.getValues()) {
            XSDefinition xsd = this.xsdFactory.createXSDefinition();
            xsd.setUnresolved(true);
            xsd.setNamespace(tns);
            xsd.setLocation(URI.create(doc.toURI() + "#" + index));
            ++index;
            xsd.setUnresolved(false);
            xsd.setSchema(null);
            wsdlDefinition.getXmlSchemas().add(xsd);
        }
        if (attr2.getValues().size() == 0) {
            XSDefinition xsd = this.xsdFactory.createXSDefinition();
            xsd.setUnresolved(true);
            xsd.setNamespace("http://www.w3.org/2001/XMLSchema");
            xsd.setUnresolved(false);
            xsd.setSchema(null);
            wsdlDefinition.getXmlSchemas().add(xsd);
        }
        return wsdlDefinition;
    }
}

