/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.http;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletMappingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServletHostExtensionPoint
implements ServletHostExtensionPoint,
LifeCycleListener {
    private List<ServletHost> servletHosts = new ArrayList<ServletHost>();
    private boolean loaded;
    private ExtensionPointRegistry registry;

    public DefaultServletHostExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void addServletHost(ServletHost servletHost) {
        this.servletHosts.add(servletHost);
        if (servletHost instanceof LifeCycleListener) {
            ((LifeCycleListener)servletHost).start();
        }
    }

    @Override
    public void removeServletHost(ServletHost servletHost) {
        this.servletHosts.remove(servletHost);
        if (servletHost instanceof LifeCycleListener) {
            ((LifeCycleListener)servletHost).stop();
        }
    }

    @Override
    public List<ServletHost> getServletHosts() {
        this.loadServletHosts();
        return this.servletHosts;
    }

    private synchronized void loadServletHosts() {
        Collection sds;
        if (this.loaded) {
            return;
        }
        try {
            sds = this.registry.getServiceDiscovery().getServiceDeclarations(ServletHost.class, true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration sd : sds) {
            LazyServletHost servletHost = new LazyServletHost(sd);
            this.addServletHost(servletHost);
        }
        this.loaded = true;
    }

    public void start() {
    }

    public void stop() {
        for (ServletHost host : this.servletHosts) {
            if (!(host instanceof LifeCycleListener)) continue;
            ((LifeCycleListener)host).stop();
        }
        this.servletHosts.clear();
        this.registry = null;
    }

    public class LazyServletHost
    implements ServletHost,
    LifeCycleListener {
        private ServiceDeclaration sd;
        private ServletHost host;

        public LazyServletHost(ServiceDeclaration sd) {
            this.sd = sd;
        }

        public synchronized ServletHost getServletHost() {
            if (this.host == null) {
                try {
                    Class cls = this.sd.loadClass();
                    Constructor ctor = null;
                    try {
                        ctor = cls.getConstructor(ExtensionPointRegistry.class);
                        this.host = (ServletHost)ctor.newInstance(DefaultServletHostExtensionPoint.this.registry);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        ctor = cls.getConstructor(new Class[0]);
                        this.host = (ServletHost)ctor.newInstance(new Object[0]);
                    }
                    if (this.host instanceof LifeCycleListener) {
                        ((LifeCycleListener)this.host).start();
                    }
                }
                catch (Throwable e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.host;
        }

        public void addServletMapping(String uri, Servlet servlet) throws ServletMappingException {
            this.getServletHost().addServletMapping(uri, servlet);
        }

        public String getContextPath() {
            return this.getServletHost().getContextPath();
        }

        public int getDefaultPort() {
            return this.getServletHost().getDefaultPort();
        }

        public RequestDispatcher getRequestDispatcher(String uri) throws ServletMappingException {
            return this.getServletHost().getRequestDispatcher(uri);
        }

        public Servlet getServletMapping(String uri) throws ServletMappingException {
            return this.getServletHost().getServletMapping(uri);
        }

        public URL getURLMapping(String uri) {
            return this.getServletHost().getURLMapping(uri);
        }

        public Servlet removeServletMapping(String uri) throws ServletMappingException {
            return this.getServletHost().removeServletMapping(uri);
        }

        public void setAttribute(String name, Object value) {
            this.getServletHost().setAttribute(name, value);
        }

        public void setContextPath(String path) {
            this.getServletHost().setContextPath(path);
        }

        public void setDefaultPort(int port) {
            this.getServletHost().setDefaultPort(port);
        }

        public String getName() {
            return (String)this.sd.getAttributes().get("name");
        }

        public void start() {
        }

        public void stop() {
            if (this.host instanceof LifeCycleListener) {
                ((LifeCycleListener)this.host).stop();
            }
        }
    }
}

