/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.jaxb.JAXBPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLRootElementUtil {
    private XMLRootElementUtil() {
    }

    public static QName getXmlRootElementQNameFromObject(Object obj) {
        if (obj instanceof JAXBElement) {
            return ((JAXBElement)obj).getName();
        }
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        return XMLRootElementUtil.getXmlRootElementQName(clazz);
    }

    public static QName getXmlRootElementQName(Class<?> clazz) {
        XmlRootElement root = XMLRootElementUtil.getAnnotation(clazz, XmlRootElement.class);
        if (root == null) {
            return null;
        }
        String name = root.name();
        String namespace = root.namespace();
        if (name == null || name.length() == 0 || name.equals("##default")) {
            name = XMLRootElementUtil.getSimpleName(clazz.getCanonicalName());
        }
        if (namespace == null || namespace.length() == 0 || namespace.equals("##default")) {
            Package pkg = clazz.getPackage();
            XmlSchema schema = XMLRootElementUtil.getAnnotation(pkg, XmlSchema.class);
            namespace = schema != null ? schema.namespace() : "";
        }
        return new QName(namespace, name);
    }

    public static String getEnumValue(Enum<?> myEnum) {
        String value;
        try {
            Field f = myEnum.getClass().getField(myEnum.name());
            f.setAccessible(true);
            XmlEnumValue xev = XMLRootElementUtil.getAnnotation(f, XmlEnumValue.class);
            value = xev == null ? f.getName() : xev.value();
        }
        catch (SecurityException e) {
            value = null;
        }
        catch (NoSuchFieldException e) {
            value = null;
        }
        return value;
    }

    private static String getSimpleName(String in) {
        if (in == null || in.length() == 0) {
            return in;
        }
        String out = null;
        StringTokenizer tokenizer = new StringTokenizer(in, ".");
        if (tokenizer.countTokens() == 0) {
            out = in;
        } else {
            while (tokenizer.hasMoreTokens()) {
                out = tokenizer.nextToken();
            }
        }
        return out;
    }

    public static Map<String, JAXBPropertyDescriptor> createPropertyDescriptorMap(Class<?> jaxbClass) throws NoSuchFieldException, IntrospectionException {
        PropertyDescriptor[] pds = Introspector.getBeanInfo(jaxbClass).getPropertyDescriptors();
        HashMap<String, JAXBPropertyDescriptor> map = new HashMap<String, JAXBPropertyDescriptor>();
        List<Field> fields = XMLRootElementUtil.getFields(jaxbClass);
        for (PropertyDescriptor pd : pds) {
            if (pd.getName().equals("class")) continue;
            boolean found = false;
            int index = 0;
            for (Field field : fields) {
                QName xmlName;
                String fieldName = field.getName();
                if (fieldName.equalsIgnoreCase(pd.getDisplayName()) || fieldName.equalsIgnoreCase(pd.getName())) {
                    xmlName = XMLRootElementUtil.getXmlElementRefOrElementQName(field.getDeclaringClass(), field);
                    found = true;
                    map.put(xmlName.getLocalPart(), new JAXBPropertyDescriptor(pd, xmlName, index));
                    ++index;
                    break;
                }
                if (!fieldName.startsWith("_") || !(fieldName = fieldName.substring(1)).equalsIgnoreCase(pd.getDisplayName()) && !fieldName.equalsIgnoreCase(pd.getName())) continue;
                xmlName = XMLRootElementUtil.getXmlElementRefOrElementQName(field.getDeclaringClass(), field);
                found = true;
                map.put(xmlName.getLocalPart(), new JAXBPropertyDescriptor(pd, xmlName, index));
                ++index;
                break;
            }
            if (found) continue;
            String xmlName = pd.getName();
            map.put(xmlName, new JAXBPropertyDescriptor(pd, xmlName, index));
            ++index;
        }
        return map;
    }

    private static List<Field> getFields(final Class<?> beanClass) {
        List<Field> fields = AccessController.doPrivileged(new PrivilegedAction<List<Field>>(){

            @Override
            public List<Field> run() {
                ArrayList<Field> fields = new ArrayList<Field>();
                for (Class cls = beanClass; cls != null; cls = cls.getSuperclass()) {
                    Field[] fieldArray;
                    for (Field field : fieldArray = cls.getDeclaredFields()) {
                        fields.add(field);
                    }
                }
                return fields;
            }
        });
        return fields;
    }

    private static QName getXmlElementRefOrElementQName(Class<?> jaxbClass, Field field) throws NoSuchFieldException {
        XmlElementRef xmlElementRef = XMLRootElementUtil.getAnnotation(field, XmlElementRef.class);
        if (xmlElementRef != null) {
            return new QName(xmlElementRef.namespace(), xmlElementRef.name());
        }
        XmlElement xmlElement = XMLRootElementUtil.getAnnotation(field, XmlElement.class);
        if (xmlElement == null || xmlElement.name().equals("##default")) {
            return new QName("", field.getName());
        }
        return new QName(xmlElement.namespace(), xmlElement.name());
    }

    private static <T extends Annotation> T getAnnotation(final AnnotatedElement element, final Class<T> annotation) {
        return (T)((Annotation)AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                return element.getAnnotation(annotation);
            }
        }));
    }
}

