/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.jaxb.JAXBPropertyDescriptor;
import org.apache.tuscany.sca.databinding.jaxb.JAXBWrapperException;
import org.apache.tuscany.sca.databinding.jaxb.JAXBWrapperHelper;
import org.apache.tuscany.sca.databinding.jaxb.XMLRootElementUtil;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBWrapperHandler
implements WrapperHandler<Object> {
    private JAXBWrapperHelper helper = new JAXBWrapperHelper();

    public Object create(Operation operation, boolean input) {
        WrapperInfo wrapperInfo = operation.getWrapper();
        ElementInfo element = input ? wrapperInfo.getInputWrapperElement() : wrapperInfo.getOutputWrapperElement();
        final Class wrapperClass = input ? wrapperInfo.getInputWrapperClass() : wrapperInfo.getOutputWrapperClass();
        try {
            if (wrapperClass == null) {
                return null;
            }
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return wrapperClass.newInstance();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new TransformationException((Throwable)e);
        }
    }

    public void setChildren(Object wrapper, Object[] childObjects, Operation operation, boolean input) {
        List childElements = input ? operation.getWrapper().getInputChildElements() : operation.getWrapper().getOutputChildElements();
        ArrayList<String> childNames = new ArrayList<String>();
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (int i = 0; i < childElements.size(); ++i) {
            ElementInfo e = (ElementInfo)childElements.get(i);
            String name = e.getQName().getLocalPart();
            childNames.add(name);
            values.put(name, childObjects[i]);
        }
        Map<String, JAXBPropertyDescriptor> pdMap = null;
        try {
            pdMap = XMLRootElementUtil.createPropertyDescriptorMap(wrapper.getClass());
        }
        catch (Throwable t) {
            throw new JAXBWrapperException(t);
        }
        this.helper.wrap(wrapper, childNames, values, pdMap);
    }

    public void setChild(Object wrapper, int i, ElementInfo childElement, Object value) {
        Object wrapperValue = wrapper;
        Class<?> wrapperClass = wrapperValue.getClass();
        try {
            String prop = childElement.getQName().getLocalPart();
            boolean collection = value instanceof Collection;
            Method getter = null;
            for (Method m : wrapperClass.getMethods()) {
                Class<?>[] paramTypes = m.getParameterTypes();
                if (paramTypes.length == 1 && m.getName().equals("set" + JAXBWrapperHandler.capitalize(prop))) {
                    m.invoke(wrapperValue, value);
                    return;
                }
                if (!collection || paramTypes.length != 0 || !m.getName().equals("get" + JAXBWrapperHandler.capitalize(prop))) continue;
                getter = m;
            }
            if (getter != null && Collection.class.isAssignableFrom(getter.getReturnType())) {
                ((Collection)getter.invoke(wrapperValue, new Object[0])).addAll((Collection)value);
            }
        }
        catch (Throwable e) {
            throw new TransformationException(e);
        }
    }

    private static String capitalize(String name) {
        char first = Character.toUpperCase(name.charAt(0));
        return first + name.substring(1);
    }

    public List getChildren(Object wrapper, Operation operation, boolean input) {
        List childElements = input ? operation.getWrapper().getInputChildElements() : operation.getWrapper().getOutputChildElements();
        ArrayList<String> childNames = new ArrayList<String>();
        for (ElementInfo e : childElements) {
            childNames.add(e.getQName().getLocalPart());
        }
        return Arrays.asList(this.helper.unwrap(wrapper, childNames));
    }

    public DataType getWrapperType(Operation operation, boolean input) {
        WrapperInfo wrapper = operation.getWrapper();
        DataType dt = input ? wrapper.getInputWrapperType() : wrapper.getOutputWrapperType();
        return dt;
    }

    public boolean isInstance(Object wrapper, Operation operation, boolean input) {
        Class wrapperClass = input ? operation.getWrapper().getInputWrapperClass() : operation.getWrapper().getOutputWrapperClass();
        return wrapperClass == null ? false : wrapperClass.isInstance(wrapper);
    }
}

