/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.XMLTypeHelper;
import org.apache.tuscany.sca.databinding.impl.BaseDataBinding;
import org.apache.tuscany.sca.databinding.impl.DOMHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBTypeHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBWrapperHandler;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JAXBDataBinding
extends BaseDataBinding {
    public static final String NAME = JAXBElement.class.getName();
    public static final String[] ALIASES = new String[]{"jaxb"};
    public static final String ROOT_NAMESPACE = "http://tuscany.apache.org/xmlns/sca/databinding/jaxb/1.0";
    public static final QName ROOT_ELEMENT = new QName("http://tuscany.apache.org/xmlns/sca/databinding/jaxb/1.0", "root");
    private JAXBWrapperHandler wrapperHandler = new JAXBWrapperHandler();
    private JAXBTypeHelper xmlTypeHelper = new JAXBTypeHelper();

    public JAXBDataBinding() {
        super(NAME, ALIASES, JAXBElement.class);
    }

    public boolean introspect(DataType dataType, Operation operation) {
        Class javaType = dataType.getPhysical();
        if (JAXBElement.class.isAssignableFrom(javaType)) {
            Type actualType;
            ParameterizedType parameterizedType;
            Type rawType;
            Type type = javaType.getGenericSuperclass();
            if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) == JAXBElement.class && (actualType = parameterizedType.getActualTypeArguments()[0]) instanceof Class) {
                XMLType xmlType = JAXBContextHelper.getXmlTypeName((Class)actualType);
                dataType.setLogical((Object)xmlType);
                dataType.setDataBinding(NAME);
                return true;
            }
            if (dataType.getLogical() == null) {
                dataType.setLogical((Object)XMLType.UNKNOWN);
            }
            dataType.setDataBinding(NAME);
            return true;
        }
        XMLType xmlType = JAXBContextHelper.getXmlTypeName(javaType);
        if (xmlType == null) {
            return false;
        }
        dataType.setLogical((Object)xmlType);
        dataType.setDataBinding(NAME);
        return true;
    }

    public Object copy(Object arg, DataType dataType, Operation operation) {
        try {
            boolean isElement = false;
            if (dataType == null) {
                Class cls = arg.getClass();
                if (arg instanceof JAXBElement) {
                    isElement = true;
                    cls = ((JAXBElement)arg).getDeclaredType();
                }
                dataType = new DataTypeImpl(NAME, cls, (Object)XMLType.UNKNOWN);
            }
            JAXBContext context = JAXBContextHelper.createJAXBContext(dataType);
            arg = JAXBContextHelper.createJAXBElement(context, dataType, arg);
            Document doc = DOMHelper.newDocument();
            context.createMarshaller().marshal(arg, (Node)doc);
            JAXBElement value = context.createUnmarshaller().unmarshal((Node)doc, dataType.getPhysical());
            if (isElement && value instanceof JAXBElement) {
                return value;
            }
            return JAXBContextHelper.createReturnValue(context, dataType, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public WrapperHandler getWrapperHandler() {
        return this.wrapperHandler;
    }

    public XMLTypeHelper getXMLTypeHelper() {
        return this.xmlTypeHelper;
    }
}

