/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.awt.Image;
import java.io.File;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.tuscany.sca.databinding.util.LRUCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBContextCache {
    private static final int CACHE_SIZE = 128;
    private static HashMap<String, Class<?>> loadClassMap = new HashMap();
    protected static Class<?>[] JAXB_BUILTIN_CLASSES;
    protected static final Set<Class<?>> BUILTIN_CLASSES_SET;
    protected LRUCache<Object, JAXBContext> cache;
    protected Pool<JAXBContext, Marshaller> mpool;
    protected Pool<JAXBContext, Unmarshaller> upool;
    protected JAXBContext defaultContext;

    public JAXBContextCache() {
        this(128, 128, 128);
    }

    public JAXBContextCache(int contextSize, int marshallerSize, int unmarshallerSize) {
        this.cache = new LRUCache(contextSize);
        this.mpool = new Pool();
        this.upool = new Pool();
        this.defaultContext = JAXBContextCache.getDefaultJAXBContext();
    }

    public static JAXBContext getDefaultJAXBContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[0]);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Class<?> getPrimitiveClass(String text) {
        return loadClassMap.get(text);
    }

    private static Class<?> forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws ClassNotFoundException {
                    Class<?> cls = JAXBContextCache.getPrimitiveClass(className);
                    if (cls == null) {
                        cls = Class.forName(className, initialize, classloader);
                    }
                    return cls;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    public static boolean checkPackage(String p, ClassLoader cl) {
        Class<?> cls;
        try {
            cls = JAXBContextCache.forName(p + ".ObjectFactory", false, cl);
            if (cls != null) {
                return true;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            cls = JAXBContextCache.forName(p + ".package-info", false, cl);
            if (cls != null) {
                return cls.isAnnotationPresent(XmlSchema.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public Marshaller getMarshaller(JAXBContext context) throws JAXBException {
        Marshaller marshaller = this.mpool.get(context);
        if (marshaller == null) {
            marshaller = context.createMarshaller();
        }
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return marshaller;
    }

    public void releaseJAXBMarshaller(JAXBContext context, Marshaller marshaller) {
        if (marshaller != null) {
            marshaller.setAttachmentMarshaller(null);
            this.mpool.put(context, marshaller);
        }
    }

    public Unmarshaller getUnmarshaller(JAXBContext context) throws JAXBException {
        Unmarshaller unmarshaller = this.upool.get(context);
        if (unmarshaller == null) {
            unmarshaller = context.createUnmarshaller();
        }
        return unmarshaller;
    }

    public void releaseJAXBUnmarshaller(JAXBContext context, Unmarshaller unmarshaller) {
        if (unmarshaller != null) {
            unmarshaller.setAttachmentUnmarshaller(null);
            this.upool.put(context, unmarshaller);
        }
    }

    public LRUCache<Object, JAXBContext> getCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getJAXBContext(Class<?> cls) throws JAXBException {
        if (BUILTIN_CLASSES_SET.contains(cls)) {
            return this.defaultContext;
        }
        LRUCache<Object, JAXBContext> lRUCache = this.cache;
        synchronized (lRUCache) {
            JAXBContext context = (JAXBContext)this.cache.get(cls);
            if (context != null) {
                return context;
            }
            Package pkg = cls.getPackage();
            if (pkg != null && (context = (JAXBContext)this.cache.get((Object)pkg)) != null) {
                return context;
            }
            if (pkg != null && JAXBContextCache.checkPackage(pkg.getName(), cls.getClassLoader())) {
                context = JAXBContext.newInstance((String)pkg.getName(), (ClassLoader)cls.getClassLoader());
                this.cache.put((Object)pkg, (Object)context);
            } else {
                context = JAXBContext.newInstance((Class[])new Class[]{cls});
                this.cache.put(cls, (Object)context);
            }
            return context;
        }
    }

    public JAXBContext getJAXBContext(Class<?>[] classes) throws JAXBException {
        HashSet classSet = new HashSet(Arrays.asList(classes));
        return this.getJAXBContext(classSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getJAXBContext(Set<Class<?>> classes) throws JAXBException {
        HashSet classSet = new HashSet(classes);
        classSet.removeAll(BUILTIN_CLASSES_SET);
        if (classSet.contains(Date[].class)) {
            classSet.remove(Calendar[].class);
        }
        if (classSet.contains(URI[].class)) {
            classSet.remove(UUID[].class);
        }
        if (classSet.contains(Source[].class)) {
            classSet.remove(Image[].class);
            classSet.remove(DataHandler[].class);
        }
        if (classSet.isEmpty()) {
            return this.defaultContext;
        }
        if (classSet.size() == 1) {
            return this.getJAXBContext((Class)classSet.iterator().next());
        }
        LRUCache<Object, JAXBContext> lRUCache = this.cache;
        synchronized (lRUCache) {
            JAXBContext context = (JAXBContext)this.cache.get(classSet);
            if (context != null) {
                return context;
            }
            context = JAXBContext.newInstance((Class[])classSet.toArray(new Class[classSet.size()]));
            this.cache.put(classSet, (Object)context);
            return context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LRUCache<Object, JAXBContext> lRUCache = this.cache;
        synchronized (lRUCache) {
            this.cache.clear();
        }
    }

    static {
        loadClassMap.put("byte", Byte.TYPE);
        loadClassMap.put("int", Integer.TYPE);
        loadClassMap.put("short", Short.TYPE);
        loadClassMap.put("long", Long.TYPE);
        loadClassMap.put("float", Float.TYPE);
        loadClassMap.put("double", Double.TYPE);
        loadClassMap.put("boolean", Boolean.TYPE);
        loadClassMap.put("char", Character.TYPE);
        loadClassMap.put("void", Void.TYPE);
        JAXB_BUILTIN_CLASSES = new Class[]{byte[].class, Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE, Image.class, File.class, Boolean.class, Byte.class, Character.class, Class.class, Double.class, Float.class, Integer.class, Long.class, Object.class, Short.class, String.class, Void.class, BigDecimal.class, BigInteger.class, URI.class, URL.class, Calendar.class, Date.class, GregorianCalendar.class, UUID.class, DataHandler.class, JAXBElement.class, Duration.class, XMLGregorianCalendar.class, QName.class, Source.class};
        BUILTIN_CLASSES_SET = new HashSet(Arrays.asList(JAXB_BUILTIN_CLASSES));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pool<K, V> {
        private SoftReference<Map<K, List<V>>> softMap = new SoftReference(new ConcurrentHashMap());
        private static int MAX_LIST_FACTOR = 50;
        private static int MAX_LOAD_FACTOR = 32;

        private Pool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key) {
            List<V> values;
            List<V> list = values = this.getValues(key);
            synchronized (list) {
                if (values.size() > 0) {
                    V v = values.remove(values.size() - 1);
                    return v;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K key, V value) {
            List<V> values;
            this.adjustSize();
            List<V> list = values = this.getValues(key);
            synchronized (list) {
                if (values.size() < MAX_LIST_FACTOR) {
                    values.add(value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<V> getValues(K key) {
            Map<K, List<List<V>>> map = this.softMap.get();
            List<V> values = null;
            if (map != null && (values = map.get(key)) != null) {
                return values;
            }
            Pool pool = this;
            synchronized (pool) {
                if (map != null) {
                    values = map.get(key);
                }
                if (values == null) {
                    if (map == null) {
                        map = new ConcurrentHashMap<K, List<V>>();
                        this.softMap = new SoftReference<Map<K, List<V>>>(map);
                    }
                    values = new ArrayList<V>();
                    map.put(key, values);
                }
                return values;
            }
        }

        private void adjustSize() {
            Map<K, List<V>> map = this.softMap.get();
            if (map != null && map.size() > MAX_LOAD_FACTOR) {
                Iterator<Map.Entry<K, List<V>>> it = map.entrySet().iterator();
                boolean removeIt = false;
                while (it.hasNext()) {
                    it.next();
                    if (removeIt) {
                        it.remove();
                    }
                    removeIt = !removeIt;
                }
            }
        }
    }
}

