/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.databinding.impl.SimpleTypeMapperImpl;
import org.apache.tuscany.sca.databinding.xml.SimpleXmlNodeImpl;
import org.apache.tuscany.sca.databinding.xml.XmlNode;
import org.apache.tuscany.sca.databinding.xml.XmlTreeStreamReaderImpl;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;
import org.jvnet.jaxb.reflection.model.annotation.RuntimeAnnotationReader;
import org.jvnet.jaxb.reflection.model.annotation.RuntimeInlineAnnotationReader;
import org.jvnet.jaxb.reflection.model.core.ErrorHandler;
import org.jvnet.jaxb.reflection.model.core.Ref;
import org.jvnet.jaxb.reflection.model.impl.RuntimeModelBuilder;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeClassInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimePropertyInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeTypeInfoSet;
import org.jvnet.jaxb.reflection.runtime.IllegalAnnotationsException;
import org.jvnet.jaxb.reflection.runtime.JAXBContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanXMLStreamReaderImpl
extends XmlTreeStreamReaderImpl {
    private static final Comparator<Accessor> COMPARATOR = new Comparator<Accessor>(){

        @Override
        public int compare(Accessor o1, Accessor o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final String XSI_PREFIX = "xsi";
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";

    private static XmlNode getXSIType(QName realType) {
        QName xsiType = new QName(XSI_NS, "type", XSI_PREFIX);
        String prefix = realType.getPrefix();
        String typeName = realType.getLocalPart();
        if (prefix != null && !prefix.equals("")) {
            typeName = prefix + ":" + realType.getLocalPart();
        }
        return new SimpleXmlNodeImpl(xsiType, (Object)XmlNode.Type.ATTRIBUTE);
    }

    public BeanXMLStreamReaderImpl(QName name, Object bean) {
        super((XmlNode)BeanXMLStreamReaderImpl.getXmlNode(name, bean));
    }

    private static BeanXmlNodeImpl getXmlNode(QName name, Object bean) {
        BeanXmlNodeImpl root = null;
        root = name != null ? new BeanXmlNodeImpl(name, bean) : new BeanXmlNodeImpl(bean);
        return root;
    }

    private static RuntimeTypeInfoSet create(Class ... classes) throws Exception {
        IllegalAnnotationsException.Builder errorListener = new IllegalAnnotationsException.Builder();
        RuntimeInlineAnnotationReader reader = new RuntimeInlineAnnotationReader();
        JAXBContextImpl context = new JAXBContextImpl(classes, null, Collections.emptyMap(), null, false, (RuntimeAnnotationReader)reader, false, false);
        RuntimeModelBuilder builder = new RuntimeModelBuilder(context, (RuntimeAnnotationReader)reader, Collections.emptyMap(), null);
        builder.setErrorHandler((ErrorHandler)errorListener);
        for (Class c : classes) {
            builder.getTypeInfo(new Ref((Object)c));
        }
        RuntimeTypeInfoSet r = builder.link();
        errorListener.check();
        return r;
    }

    private static Map<String, Accessor> getAccessors(Object target) throws Exception {
        if (target == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Accessor> map = new HashMap<String, Accessor>();
        Class<?> type = target.getClass();
        RuntimeTypeInfoSet set = BeanXMLStreamReaderImpl.create(type);
        RuntimeClassInfo clsInfo = (RuntimeClassInfo)set.getTypeInfo(type);
        for (RuntimePropertyInfo f : clsInfo.getProperties()) {
            map.put(f.getName(), new JAXBAccessor(target, f));
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JAXBAccessor
    implements Accessor {
        private Object target;
        private RuntimePropertyInfo prop;

        public JAXBAccessor(Object target, RuntimePropertyInfo field) {
            this.target = target;
            this.prop = field;
        }

        @Override
        public String getName() {
            return this.prop.getName();
        }

        @Override
        public Object getValue() throws Exception {
            return this.prop.getAccessor().get(this.target);
        }

        @Override
        public void setValue(Object value) throws Exception {
            this.prop.getAccessor().set(this.target, value);
        }

        @Override
        public Class<?> getType() {
            ParameterizedType pType;
            Type type = this.prop.getRawType();
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType && (type = (pType = (ParameterizedType)type).getRawType()) instanceof Class) {
                return (Class)type;
            }
            return Object.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Accessor {
        public String getName();

        public Class<?> getType();

        public Object getValue() throws Exception;

        public void setValue(Object var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BeanXmlNodeImpl
    extends SimpleXmlNodeImpl
    implements XmlNode {
        private static final Object[] NULL = null;
        private static final SimpleTypeMapperImpl MAPPER = new SimpleTypeMapperImpl();

        public BeanXmlNodeImpl(Object bean) {
            super(BeanXmlNodeImpl.getName(bean == null ? null : bean.getClass()), bean);
        }

        public BeanXmlNodeImpl(QName name, Object bean) {
            super(name, bean);
        }

        private static boolean isSimpleType(Class<?> javaType) {
            return SimpleTypeMapperImpl.getXMLType(javaType) != null;
        }

        private static String getStringValue(Object o) {
            if (o == null) {
                return null;
            }
            TypeInfo info = SimpleTypeMapperImpl.getXMLType(o.getClass());
            if (info != null) {
                return MAPPER.toXMLLiteral(info.getQName(), o, null);
            }
            return String.valueOf(o);
        }

        public Iterator<XmlNode> children() {
            if (this.name == null) {
                return null;
            }
            if (this.value == null) {
                return super.children();
            }
            if (BeanXmlNodeImpl.isSimpleType(this.value.getClass())) {
                BeanXmlNodeImpl textNode = new BeanXmlNodeImpl(null, this.value);
                return Arrays.asList(new XmlNode[]{textNode}).iterator();
            }
            if (Map.class.isAssignableFrom(this.value.getClass())) {
                ArrayList<MapEntryXmlNodeImpl> entries = new ArrayList<MapEntryXmlNodeImpl>();
                Map map = (Map)this.value;
                if (map != null) {
                    Iterator i$ = map.entrySet().iterator();
                    while (i$.hasNext()) {
                        Map.Entry e;
                        Map.Entry entry = e = i$.next();
                        entries.add(new MapEntryXmlNodeImpl(entry));
                    }
                }
                return entries.iterator();
            }
            try {
                Map accessorMap = BeanXMLStreamReaderImpl.getAccessors(this.value);
                ArrayList accessorList = new ArrayList(accessorMap.values());
                Collections.sort(accessorList, COMPARATOR);
                ArrayList<BeanXmlNodeImpl> props = new ArrayList<BeanXmlNodeImpl>();
                for (Accessor accessor : accessorList) {
                    Class<?> pType = accessor.getType();
                    QName pName = new QName(this.name.getNamespaceURI(), accessor.getName());
                    Object pValue = accessor.getValue();
                    if (pType.isArray()) {
                        if (pValue == null) continue;
                        int i1 = Array.getLength(pValue);
                        for (int j = 0; j < i1; ++j) {
                            Object o = Array.get(pValue, j);
                            props.add(new BeanXmlNodeImpl(pName, o));
                        }
                        continue;
                    }
                    if (Collection.class.isAssignableFrom(pType)) {
                        Collection objList = (Collection)pValue;
                        if (objList == null || objList.size() <= 0) continue;
                        for (Object o : objList) {
                            props.add(new BeanXmlNodeImpl(pName, o));
                        }
                        continue;
                    }
                    props.add(new BeanXmlNodeImpl(pName, pValue));
                }
                return props.iterator();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        public QName getName() {
            return this.name;
        }

        public String getValue() {
            return BeanXmlNodeImpl.getStringValue(this.value);
        }

        private static String getPackageName(Class<?> cls) {
            String name = cls.getName();
            int index = name.lastIndexOf(46);
            return index == -1 ? "" : name.substring(0, index);
        }

        public static QName getName(Class<?> cls) {
            if (cls == null) {
                return null;
            }
            String packageName = BeanXmlNodeImpl.getPackageName(cls);
            if ("".equals(packageName)) {
                return new QName("", cls.getSimpleName());
            }
            StringBuffer ns = new StringBuffer("http://");
            String[] names = packageName.split("\\.");
            for (int i = names.length - 1; i >= 0; --i) {
                ns.append(names[i]);
                if (i == 0) continue;
                ns.append('.');
            }
            ns.append('/');
            return new QName(ns.toString(), cls.getSimpleName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapEntryXmlNodeImpl
    extends SimpleXmlNodeImpl
    implements XmlNode {
        private Map.Entry entry;

        public MapEntryXmlNodeImpl(Map.Entry entry) {
            super(new QName("", "entry"), (Object)entry);
            this.entry = entry;
        }

        public Iterator<XmlNode> children() {
            ArrayList<BeanXmlNodeImpl> nodes = new ArrayList<BeanXmlNodeImpl>();
            BeanXmlNodeImpl key = new BeanXmlNodeImpl(new QName("", "key"), this.entry.getKey());
            BeanXmlNodeImpl value = new BeanXmlNodeImpl(new QName("", "value"), this.entry.getValue());
            nodes.add(key);
            nodes.add(value);
            return nodes.iterator();
        }
    }
}

