/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.scanner;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tuscany.sca.contribution.scanner.ContributionScanner;
import org.apache.tuscany.sca.contribution.scanner.ContributionScannerExtensionPoint;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

public class DefaultContributionScannerExtensionPoint
implements ContributionScannerExtensionPoint {
    private Map<String, ContributionScanner> scanners = new HashMap<String, ContributionScanner>();
    private boolean loaded;

    public void addContributionScanner(ContributionScanner scanner) {
        this.scanners.put(scanner.getContributionType(), scanner);
    }

    public void removeContributionScanner(ContributionScanner scanner) {
        this.scanners.remove(scanner.getContributionType());
    }

    public ContributionScanner getContributionScanner(String contentType) {
        this.loadScanners();
        return this.scanners.get(contentType);
    }

    private void loadScanners() {
        Set scannerDeclarations;
        if (this.loaded) {
            return;
        }
        try {
            scannerDeclarations = ServiceDiscovery.getInstance().getServiceDeclarations(ContributionScanner.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration scannerDeclaration : scannerDeclarations) {
            Map attributes = scannerDeclaration.getAttributes();
            String contributionType = (String)attributes.get("type");
            LazyContributionScanner scanner = new LazyContributionScanner(contributionType, scannerDeclaration);
            this.addContributionScanner(scanner);
        }
        this.loaded = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyContributionScanner
    implements ContributionScanner {
        private ServiceDeclaration scannerDeclaration;
        private String contributionType;
        private ContributionScanner scanner;

        private LazyContributionScanner(String contributionType, ServiceDeclaration scannerDeclaration) {
            this.scannerDeclaration = scannerDeclaration;
            this.contributionType = contributionType;
        }

        @Override
        public URL getArtifactURL(URL contributionSourceURL, String artifact) throws ContributionReadException {
            return this.getScanner().getArtifactURL(contributionSourceURL, artifact);
        }

        @Override
        public List<String> getArtifacts(URL contributionSourceURL) throws ContributionReadException {
            return this.getScanner().getArtifacts(contributionSourceURL);
        }

        @Override
        public String getContributionType() {
            return this.contributionType;
        }

        private ContributionScanner getScanner() {
            if (this.scanner == null) {
                try {
                    Class scannerClass = this.scannerDeclaration.loadClass();
                    Constructor constructor = scannerClass.getConstructor(new Class[0]);
                    this.scanner = (ContributionScanner)constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.scanner;
        }
    }
}

