/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import javax.xml.validation.ValidatorHandler;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.contribution.processor.TuscanyXMLStreamReader;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

class ValidatingXMLStreamReader
extends TuscanyXMLStreamReader
implements XMLStreamReader {
    private static final Logger logger = Logger.getLogger(ValidatingXMLStreamReader.class.getName());
    private int level;
    private ValidatorHandler handler;
    private final Monitor monitor;

    ValidatingXMLStreamReader(XMLStreamReader reader, Schema schema, Monitor monitor) throws XMLStreamException {
        super(reader);
        this.monitor = monitor;
        if (schema == null) {
            return;
        }
        this.handler = schema.newValidatorHandler();
        this.handler.setDocumentLocator(new LocatorAdapter());
        try {
            this.handler.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (SAXException e) {
            XMLStreamException xse = new XMLStreamException(e);
            this.error("XMLStreamException", this.handler, xse);
            throw xse;
        }
        this.handler.setErrorHandler(new ErrorHandler(){

            private String getMessage(SAXParseException e) {
                return "XMLSchema validation problem in: " + e.getSystemId() + ", line: " + e.getLineNumber() + ", column: " + e.getColumnNumber() + "\n" + e.getMessage();
            }

            public void error(SAXParseException exception) throws SAXException {
                if (ValidatingXMLStreamReader.this.monitor == null) {
                    logger.warning(this.getMessage(exception));
                } else {
                    ValidatingXMLStreamReader.this.error("SchemaError", ValidatingXMLStreamReader.this.getClass(), new Object[]{exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getMessage()});
                }
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                if (ValidatingXMLStreamReader.this.monitor == null) {
                    logger.warning(this.getMessage(exception));
                } else {
                    ValidatingXMLStreamReader.this.error("SchemaFatalError", ValidatingXMLStreamReader.this.getClass(), new Object[]{exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getMessage()});
                }
            }

            public void warning(SAXParseException exception) throws SAXException {
                if (ValidatingXMLStreamReader.this.monitor == null) {
                    logger.warning(this.getMessage(exception));
                } else {
                    ValidatingXMLStreamReader.this.warning("SchemaWarning", ValidatingXMLStreamReader.this.getClass(), new Object[]{exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getMessage()});
                }
            }
        });
    }

    private void warning(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "contribution-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    public int next() throws XMLStreamException {
        if (this.handler == null) {
            return super.next();
        }
        int event = super.next();
        try {
            switch (event) {
                case 7: {
                    ++this.level;
                    this.handler.startDocument();
                    break;
                }
                case 1: {
                    ++this.level;
                    this.handleStartElement();
                    break;
                }
                case 3: {
                    this.handler.processingInstruction(super.getPITarget(), super.getPIData());
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 12: {
                    this.handler.characters(super.getTextCharacters(), super.getTextStart(), super.getTextLength());
                    break;
                }
                case 2: {
                    this.handleEndElement();
                    --this.level;
                    break;
                }
                case 8: {
                    this.handler.endDocument();
                }
            }
        }
        catch (SAXException e) {
            XMLStreamException xse = new XMLStreamException(e.getMessage(), e);
            this.error("XMLStreamException", this.handler, xse);
            throw xse;
        }
        return event;
    }

    public int nextTag() throws XMLStreamException {
        if (this.handler == null) {
            return super.nextTag();
        }
        while (true) {
            int event = super.getEventType();
            try {
                switch (event) {
                    case 7: {
                        ++this.level;
                        this.handler.startDocument();
                        break;
                    }
                    case 1: {
                        ++this.level;
                        this.handleStartElement();
                        return event;
                    }
                    case 3: {
                        this.handler.processingInstruction(super.getPITarget(), super.getPIData());
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 9: 
                    case 12: {
                        this.handler.characters(super.getTextCharacters(), super.getTextStart(), super.getTextLength());
                        break;
                    }
                    case 2: {
                        this.handleEndElement();
                        --this.level;
                        return event;
                    }
                    case 8: {
                        this.handler.endDocument();
                        return event;
                    }
                }
            }
            catch (SAXException e) {
                XMLStreamException xse = new XMLStreamException(e);
                this.error("XMLStreamException", this.handler, xse);
                throw xse;
            }
            super.next();
        }
    }

    public String getElementText() throws XMLStreamException {
        if (this.handler == null) {
            return super.getElementText();
        }
        if (this.getEventType() != 1) {
            return super.getElementText();
        }
        StringBuffer text = new StringBuffer();
        while (true) {
            int event = this.next();
            switch (event) {
                case 2: {
                    return text.toString();
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 12: {
                    text.append(this.getText());
                    break;
                }
            }
        }
    }

    public NamespaceContext getNamespaceContext() {
        return super.getNamespaceContext();
    }

    private void handleStartElement() throws SAXException {
        String prefix;
        int nsCount = super.getNamespaceCount();
        for (int i = 0; i < nsCount; ++i) {
            prefix = super.getNamespacePrefix(i);
            if (prefix == null) {
                prefix = "";
            }
            this.handler.startPrefixMapping(prefix, super.getNamespaceURI(i));
        }
        QName qname = super.getName();
        prefix = qname.getPrefix();
        String rawname = prefix == null || prefix.length() == 0 ? qname.getLocalPart() : prefix + ':' + qname.getLocalPart();
        Attributes attrs = this.getAttributes();
        this.handler.startElement(qname.getNamespaceURI(), qname.getLocalPart(), rawname, attrs);
    }

    private void handleEndElement() throws SAXException {
        QName qname = super.getName();
        this.handler.endElement(qname.getNamespaceURI(), qname.getLocalPart(), qname.toString());
        int nsCount = super.getNamespaceCount();
        for (int i = nsCount - 1; i >= 0; --i) {
            String prefix = super.getNamespacePrefix(i);
            if (prefix == null) {
                prefix = "";
            }
            this.handler.endPrefixMapping(prefix);
        }
    }

    private Attributes getAttributes() {
        int i;
        AttributesImpl attrs = new AttributesImpl();
        for (i = 0; i < super.getNamespaceCount(); ++i) {
            String prefix = super.getNamespacePrefix(i);
            String uri = super.getNamespaceURI(i);
            if (prefix == null) {
                attrs.addAttribute("", "", "xmlns", "CDATA", uri);
                continue;
            }
            attrs.addAttribute("", "", "xmlns:" + prefix, "CDATA", uri);
        }
        for (i = 0; i < super.getAttributeCount(); ++i) {
            String uri = super.getAttributeNamespace(i);
            if (uri == null) {
                uri = "";
            }
            String localName = super.getAttributeLocalName(i);
            String prefix = super.getAttributePrefix(i);
            String qname = prefix == null || prefix.length() == 0 ? localName : prefix + ':' + localName;
            String type = super.getAttributeType(i);
            String value = super.getAttributeValue(i);
            attrs.addAttribute(uri, localName, qname, type, value);
        }
        return attrs;
    }

    private final class LocatorAdapter
    implements Locator {
        private LocatorAdapter() {
        }

        public int getColumnNumber() {
            Location location = ValidatingXMLStreamReader.this.getLocation();
            return location == null ? 0 : location.getColumnNumber();
        }

        public int getLineNumber() {
            Location location = ValidatingXMLStreamReader.this.getLocation();
            return location == null ? 0 : location.getLineNumber();
        }

        public String getPublicId() {
            Location location = ValidatingXMLStreamReader.this.getLocation();
            return location == null ? "" : location.getPublicId();
        }

        public String getSystemId() {
            Location location = ValidatingXMLStreamReader.this.getLocation();
            return location == null ? "" : location.getSystemId();
        }
    }
}

