/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.java.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionHelper {
    public static List<URL> getNestedJarUrls(Contribution contribution) throws IOException {
        boolean isFolderContribution;
        ArrayList<URL> urls = new ArrayList<URL>();
        boolean isZipContribution = contribution.getLocation().endsWith(".zip");
        URI uri = URI.create(contribution.getLocation());
        boolean bl = isFolderContribution = !isZipContribution && uri.getScheme().equals("file") && new File(uri).isDirectory();
        if (isZipContribution || isFolderContribution) {
            for (Artifact a : contribution.getArtifacts()) {
                if (!a.getLocation().endsWith(".jar")) continue;
                if (isZipContribution) {
                    urls.add(ContributionHelper.createTempJar(a, contribution));
                    continue;
                }
                urls.add(new URL(a.getLocation()));
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL createTempJar(Artifact artifact, Contribution contribution) throws IOException {
        FileOutputStream fileOutputStream = null;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(new File(URI.create(contribution.getLocation()))));
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (artifact.getLocation().endsWith(zipEntry.getName())) {
                    int n;
                    String tempName = ("tmp." + artifact.getURI().substring(0, artifact.getURI().length() - 3)).replace('/', '.');
                    File tempFile = File.createTempFile(tempName, ".jar");
                    tempFile.deleteOnExit();
                    fileOutputStream = new FileOutputStream(tempFile);
                    byte[] buf = new byte[2048];
                    while ((n = zipInputStream.read(buf, 0, buf.length)) > -1) {
                        fileOutputStream.write(buf, 0, n);
                    }
                    fileOutputStream.close();
                    zipInputStream.closeEntry();
                    URL uRL = tempFile.toURI().toURL();
                    return uRL;
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            zipInputStream.close();
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        throw new IllegalStateException();
    }
}

