/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.java.impl;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.java.ContributionClassLoaderProvider;
import org.apache.tuscany.sca.contribution.java.ContributionClassloaderProviderExtensionPoint;
import org.apache.tuscany.sca.contribution.java.DefaultContributionClassLoaderProvider;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassReferenceModelResolver
implements ModelResolver {
    private final ExtensionPointRegistry registry;
    private final Contribution contribution;
    private WeakReference<ClassLoader> classLoader;
    private Map<String, ClassReference> map = new HashMap<String, ClassReference>();
    private ModelResolver osgiResolver;

    public ClassReferenceModelResolver(final Contribution contribution, ExtensionPointRegistry registry) {
        ClassLoader cl;
        this.contribution = contribution;
        this.registry = registry;
        if (this.contribution != null) {
            cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return contribution.getClassLoader();
                }
            });
            if (cl == null) {
                ClassLoader contextClassLoader = ServiceDiscovery.getInstance().getServiceDiscoverer().getClass().getClassLoader();
                ContributionClassLoaderProvider provider = null;
                try {
                    ContributionClassloaderProviderExtensionPoint providers = (ContributionClassloaderProviderExtensionPoint)registry.getExtensionPoint(ContributionClassloaderProviderExtensionPoint.class);
                    provider = providers.getProvider(contribution.getType());
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (provider == null) {
                    provider = new DefaultContributionClassLoaderProvider();
                }
                cl = provider.getClassLoader(contribution, contextClassLoader);
                contribution.setClassLoader(cl);
            }
            this.classLoader = new WeakReference<ClassLoader>(cl);
        } else {
            cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return this.getClass().getClassLoader();
                }
            });
            this.classLoader = new WeakReference<ClassLoader>(cl);
        }
        try {
            Class<?> osgiResolverClass = Class.forName("org.apache.tuscany.sca.contribution.osgi.impl.OSGiClassReferenceModelResolver");
            if (osgiResolverClass != null) {
                Constructor<?> constructor = osgiResolverClass.getConstructor(Contribution.class, ExtensionPointRegistry.class);
                this.osgiResolver = (ModelResolver)constructor.newInstance(contribution, registry);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addModel(Object resolved) {
        ClassReference clazz = (ClassReference)resolved;
        this.map.put(clazz.getClassName(), clazz);
    }

    public Object removeModel(Object resolved) {
        return this.map.remove(((ClassReference)resolved).getClassName());
    }

    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        if (!(unresolved instanceof ClassReference)) {
            return unresolved;
        }
        Object resolved = this.map.get(((ClassReference)unresolved).getClassName());
        if (resolved != null) {
            return modelClass.cast(resolved);
        }
        Class<?> clazz = null;
        if (this.osgiResolver != null) {
            resolved = this.osgiResolver.resolveModel(modelClass, unresolved);
            clazz = resolved.getJavaClass();
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(((ClassReference)unresolved).getClassName(), true, (ClassLoader)this.classLoader.get());
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
        }
        if (clazz != null) {
            ClassReference classReference = new ClassReference(clazz);
            this.map.put(clazz.getName(), classReference);
            return modelClass.cast(classReference);
        }
        return unresolved;
    }

    private String getPackageName(ClassReference clazz) {
        int pos = clazz.getClassName().lastIndexOf(".");
        return clazz.getClassName().substring(0, pos);
    }
}

