/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.wsdlgen;

import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.wsdlgen.Interface2WSDLGenerator;
import org.apache.tuscany.sca.binding.ws.wsdlgen.WSDLGenerationException;
import org.apache.tuscany.sca.binding.ws.wsdlgen.WSDLServiceGenerator;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ResolverExtension;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.interfacedef.wsdl.impl.InvalidWSDLException;
import org.apache.tuscany.sca.interfacedef.wsdl.impl.WSDLInterfaceIntrospectorImpl;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPoint;
import org.apache.tuscany.sca.xsd.XSDFactory;

public class BindingWSDLGenerator {
    private static final Logger logger = Logger.getLogger(BindingWSDLGenerator.class.getName());
    private static final QName SOAP12_INTENT = new QName("http://www.osoa.org/xmlns/sca/1.0", "SOAP.1_2");
    public static boolean printWSDL;

    private BindingWSDLGenerator() {
    }

    private static void logWarning(Problem problem) {
        Logger problemLogger = Logger.getLogger(problem.getSourceClassName(), problem.getBundleName());
        if (problemLogger != null) {
            problemLogger.logp(Level.WARNING, problem.getSourceClassName(), (String)null, problem.getMessageId(), problem.getMessageParams());
        } else {
            logger.severe("Can't get logger " + problem.getSourceClassName() + " with bundle " + problem.getBundleName());
        }
    }

    private static void warning(Monitor monitor, String message, WebServiceBinding wsBinding, String ... messageParameters) {
        ProblemImpl problem = new ProblemImpl(BindingWSDLGenerator.class.getName(), "wsdlgen-validation-messages", Problem.Severity.WARNING, (Object)wsBinding, message, (Object[])messageParameters);
        if (monitor != null) {
            monitor.problem((Problem)problem);
        } else {
            BindingWSDLGenerator.logWarning((Problem)problem);
        }
    }

    private static void error(Monitor monitor, String message, WebServiceBinding wsBinding, String ... messageParameters) {
        ProblemImpl problem = new ProblemImpl(BindingWSDLGenerator.class.getName(), "wsdlgen-validation-messages", Problem.Severity.ERROR, (Object)wsBinding, message, (Object[])messageParameters);
        if (monitor == null) {
            throw new WSDLGenerationException(problem.toString(), null, (Problem)problem);
        }
        monitor.problem((Problem)problem);
    }

    private static void error(Monitor monitor, String message, WebServiceBinding wsBinding, Exception ex) {
        ProblemImpl problem = new ProblemImpl(BindingWSDLGenerator.class.getName(), "wsdlgen-validation-messages", Problem.Severity.ERROR, (Object)wsBinding, message, ex);
        if (monitor == null) {
            throw new WSDLGenerationException(problem.toString(), ex, (Problem)problem);
        }
        monitor.problem((Problem)problem);
    }

    private static void fatal(Monitor monitor, String message, WebServiceBinding wsBinding, String ... messageParameters) {
        ProblemImpl problem = new ProblemImpl(BindingWSDLGenerator.class.getName(), "wsdlgen-validation-messages", Problem.Severity.ERROR, (Object)wsBinding, message, (Object[])messageParameters);
        throw new WSDLGenerationException(problem.toString(), null, (Problem)problem);
    }

    private static void fatal(Monitor monitor, String message, WebServiceBinding wsBinding, Exception ex) {
        ProblemImpl problem = new ProblemImpl(BindingWSDLGenerator.class.getName(), "wsdlgen-validation-messages", Problem.Severity.ERROR, (Object)wsBinding, message, ex);
        throw new WSDLGenerationException(problem.toString(), ex, (Problem)problem);
    }

    public static void generateWSDL(Component component, AbstractContract contract, WebServiceBinding wsBinding, ExtensionPointRegistry extensionPoints, Monitor monitor) {
        try {
            BindingWSDLGenerator.createWSDLDocument(component, contract, wsBinding, extensionPoints, monitor);
        }
        catch (WSDLGenerationException ex) {
            if (ex.getProblem() != null) {
                BindingWSDLGenerator.warning(monitor, "WsdlGenProblem", wsBinding, component.getName(), contract.getName());
                if (monitor != null) {
                    monitor.problem(ex.getProblem());
                }
                throw ex;
            }
            if (ex.getCause() instanceof Exception) {
                BindingWSDLGenerator.warning(monitor, "WsdlGenException", wsBinding, component.getName(), contract.getName());
                BindingWSDLGenerator.error(monitor, "UnexpectedException", wsBinding, (Exception)ex.getCause());
            }
            throw new IllegalStateException((Throwable)((Object)ex));
        }
        catch (RuntimeException ex) {
            BindingWSDLGenerator.warning(monitor, "WsdlGenException", wsBinding, component.getName(), contract.getName());
            BindingWSDLGenerator.error(monitor, "UnexpectedException", wsBinding, ex);
        }
    }

    private static void createWSDLDocument(Component component, AbstractContract contract, WebServiceBinding wsBinding, ExtensionPointRegistry extensionPoints, Monitor monitor) {
        Definition definition;
        InterfaceContract icontract;
        ModelFactoryExtensionPoint modelFactories = (ModelFactoryExtensionPoint)extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        DataBindingExtensionPoint dataBindings = (DataBindingExtensionPoint)extensionPoints.getExtensionPoint(DataBindingExtensionPoint.class);
        org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory wsdlFactory = (org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory)modelFactories.getFactory(org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory.class);
        XSDFactory xsdFactory = (XSDFactory)modelFactories.getFactory(XSDFactory.class);
        if (((Contract)contract).getInterfaceContract((Binding)wsBinding) == null) {
            BindingWSDLGenerator.fatal(monitor, "MissingInterfaceContract", wsBinding, component.getName(), contract.getName());
        }
        if ((icontract = wsBinding.getBindingInterfaceContract()) == null) {
            icontract = ((Contract)contract).getInterfaceContract((Binding)wsBinding).makeUnidirectional(false);
            if (icontract instanceof JavaInterfaceContract) {
                ModelResolver resolver = component instanceof ResolverExtension ? ((ResolverExtension)component).getModelResolver() : null;
                icontract = BindingWSDLGenerator.createWSDLInterfaceContract((JavaInterfaceContract)icontract, BindingWSDLGenerator.requiresSOAP12(wsBinding), resolver, dataBindings, wsdlFactory, xsdFactory, monitor);
            } else {
                try {
                    icontract = (InterfaceContract)icontract.clone();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            wsBinding.setBindingInterfaceContract(icontract);
        }
        if (contract.getInterfaceContract().getInterface() != null) {
            icontract.getInterface().setConversational(contract.getInterfaceContract().getInterface().isConversational());
            for (Operation operation : icontract.getInterface().getOperations()) {
                Operation serviceOperation = null;
                for (Operation tmpOp : contract.getInterfaceContract().getInterface().getOperations()) {
                    if (!operation.getName().equals(tmpOp.getName())) continue;
                    serviceOperation = tmpOp;
                    break;
                }
                if (serviceOperation == null) continue;
                operation.setConversationSequence(serviceOperation.getConversationSequence());
            }
        }
        if ((definition = wsBinding.getWSDLDocument()) == null) {
            definition = WSDLServiceGenerator.configureWSDLDefinition(wsBinding, component, contract, monitor);
            wsBinding.setWSDLDocument(definition);
        }
    }

    protected static boolean requiresSOAP12(WebServiceBinding wsBinding) {
        if (wsBinding instanceof IntentAttachPoint) {
            List intents = ((IntentAttachPoint)wsBinding).getRequiredIntents();
            for (Intent intent : intents) {
                if (!SOAP12_INTENT.equals(intent.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected static WSDLInterfaceContract createWSDLInterfaceContract(JavaInterfaceContract contract, boolean requiresSOAP12, ModelResolver resolver, DataBindingExtensionPoint dataBindings, org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory wsdlFactory, XSDFactory xsdFactory, Monitor monitor) {
        WSDLInterfaceContract wsdlContract = wsdlFactory.createWSDLInterfaceContract();
        WSDLInterface wsdlInterface = wsdlFactory.createWSDLInterface();
        wsdlContract.setInterface((Interface)wsdlInterface);
        WSDLDefinition wsdlDefinition = wsdlFactory.createWSDLDefinition();
        JavaInterface iface = (JavaInterface)contract.getInterface();
        Definition def = null;
        try {
            Interface2WSDLGenerator wsdlGenerator = new Interface2WSDLGenerator(requiresSOAP12, resolver, dataBindings, xsdFactory, monitor);
            def = wsdlGenerator.generate((Interface)iface, wsdlDefinition);
        }
        catch (WSDLException e) {
            throw new WSDLGenerationException(e);
        }
        if (printWSDL) {
            try {
                System.out.println("Generated WSDL for Java interface " + iface.getName() + " class " + iface.getJavaClass().getName());
                WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
                writer.writeWSDL(def, (OutputStream)System.out);
            }
            catch (WSDLException e) {
                throw new WSDLGenerationException(e);
            }
        }
        wsdlDefinition.setDefinition(def);
        wsdlInterface.setWsdlDefinition(wsdlDefinition);
        wsdlInterface.setRemotable(true);
        wsdlInterface.setConversational(contract.getInterface().isConversational());
        wsdlInterface.setUnresolved(false);
        wsdlInterface.setRemotable(true);
        PortType portType = (PortType)def.getAllPortTypes().values().iterator().next();
        wsdlInterface.setPortType(portType);
        try {
            for (Operation op : iface.getOperations()) {
                javax.wsdl.Operation wsdlOp = portType.getOperation(op.getName(), null, null);
                wsdlInterface.getOperations().add(WSDLInterfaceIntrospectorImpl.getOperation((javax.wsdl.Operation)wsdlOp, (WSDLDefinition)wsdlDefinition, (ModelResolver)resolver, (XSDFactory)xsdFactory));
            }
        }
        catch (InvalidWSDLException e) {
            throw new WSDLGenerationException(e);
        }
        return wsdlContract;
    }
}

