/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;

public class AxisPolicyHelper {
    public static final String XMLNS_SCA_11 = "http://docs.oasis-open.org/ns/opencsa/sca/200903";
    public static final QName AUTHENTICATION_INTENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200903", "authentication");
    public static final QName CONFIDENTIALITY_INTENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200903", "confidentiality");
    public static final QName INTEGRITY_INTENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200903", "integrity");
    public static final QName MTOM_INTENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200903", "MTOM");
    public static final QName SOAP12_INTENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200903", "SOAP12");

    public static PolicySet getPolicySet(Binding wsBinding, QName intentName) {
        PolicySet returnPolicySet = null;
        if (wsBinding instanceof PolicySubject) {
            PolicySubject policiedBinding = (PolicySubject)wsBinding;
            block0: for (PolicySet policySet : policiedBinding.getPolicySets()) {
                for (Intent intent : policySet.getProvidedIntents()) {
                    if (!intent.getName().equals(intentName)) continue;
                    returnPolicySet = policySet;
                    continue block0;
                }
            }
        }
        return returnPolicySet;
    }

    public static boolean isIntentRequired(Binding wsBinding, QName intent) {
        if (wsBinding instanceof PolicySubject) {
            List intents = ((PolicySubject)wsBinding).getRequiredIntents();
            for (Intent i : intents) {
                if (!intent.equals(i.getName())) continue;
                return true;
            }
        }
        return AxisPolicyHelper.getPolicySet(wsBinding, intent) != null;
    }

    public static boolean isRampartRequired(Binding wsBinding) {
        return AxisPolicyHelper.isIntentRequired(wsBinding, AUTHENTICATION_INTENT) || AxisPolicyHelper.isIntentRequired(wsBinding, INTEGRITY_INTENT) || AxisPolicyHelper.isIntentRequired(wsBinding, CONFIDENTIALITY_INTENT);
    }
}

