/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import org.apache.axiom.om.OMElement;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ServiceProvider;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.oasisopen.sca.ServiceRuntimeException;

public class Axis2ServiceBindingProvider
implements ServiceBindingProvider {
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private WebServiceBinding wsBinding;
    private Axis2ServiceProvider axisProvider;

    public Axis2ServiceBindingProvider(Endpoint endpoint, ServletHost servletHost, FactoryExtensionPoint modelFactories, DataBindingExtensionPoint dataBindings) {
        if (servletHost == null) {
            throw new ServiceRuntimeException("No Servlet host is avaible for HTTP web services");
        }
        MessageFactory messageFactory = (MessageFactory)modelFactories.getFactory(MessageFactory.class);
        this.wsBinding = (WebServiceBinding)endpoint.getBinding();
        this.component = (RuntimeComponent)endpoint.getComponent();
        this.service = (RuntimeComponentService)endpoint.getService();
        if (this.wsBinding.getWSDLDocument() == null) {
            throw new ServiceRuntimeException("No WSDL document for " + this.component.getName() + "/" + this.service.getName());
        }
        InterfaceContract contract = this.wsBinding.getBindingInterfaceContract();
        contract.getInterface().resetDataBinding(OMElement.class.getName());
        this.axisProvider = new Axis2ServiceProvider(this.component, (AbstractContract)this.service, this.wsBinding, servletHost, messageFactory, modelFactories);
    }

    public void start() {
        this.axisProvider.start();
    }

    public void stop() {
        this.axisProvider.stop();
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.wsBinding.getBindingInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return true;
    }
}

