/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.URLBasedAxisConfigurator;
import org.apache.tuscany.sca.binding.ws.axis2.TuscanyAxisConfigurator;
import org.apache.tuscany.sca.extensibility.ClassLoaderContext;
import org.oasisopen.sca.ServiceRuntimeException;

public class Axis2ConfiguratorHelper {
    public static ConfigurationContext getAxis2ConfigurationContext(final boolean isRampartRequired) {
        try {
            ConfigurationContext configContext = AccessController.doPrivileged(new PrivilegedExceptionAction<ConfigurationContext>(){

                @Override
                public ConfigurationContext run() throws AxisFault {
                    ClassLoader cl0 = this.getClass().getClassLoader();
                    ClassLoader cl1 = URLBasedAxisConfigurator.class.getClassLoader();
                    ClassLoader tccl = ClassLoaderContext.setContextClassLoader((ClassLoader)cl0, (ClassLoader[])new ClassLoader[]{cl1});
                    try {
                        ConfigurationContext configurationContext = new TuscanyAxisConfigurator(isRampartRequired).getConfigurationContext();
                        return configurationContext;
                    }
                    finally {
                        if (tccl != null) {
                            Thread.currentThread().setContextClassLoader(tccl);
                        }
                    }
                }
            });
            return configContext;
        }
        catch (PrivilegedActionException e) {
            throw new ServiceRuntimeException((Throwable)e.getException());
        }
    }
}

