/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.assembly.OperationSelector;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.assembly.xml.ConfiguredOperationProcessor;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.assembly.xml.PolicySubjectProcessor;
import org.apache.tuscany.sca.binding.jms.BindingProperty;
import org.apache.tuscany.sca.binding.jms.JMSBinding;
import org.apache.tuscany.sca.binding.jms.JMSBindingConstants;
import org.apache.tuscany.sca.binding.jms.operationselector.OperationSelectorJMSDefault;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSDefault;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSObject;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSText;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSTextXML;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.PolicyFactory;

public class JMSBindingProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<JMSBinding> {
    private PolicyFactory policyFactory;
    private PolicySubjectProcessor policyProcessor;
    private AssemblyFactory assemblyFactory;
    private ConfiguredOperationProcessor configuredOperationProcessor;
    protected StAXArtifactProcessor<Object> extensionProcessor;
    private StAXAttributeProcessor<Object> extensionAttributeProcessor;
    private ProcessorContext processorContext;

    public JMSBindingProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor<Object> extensionProcessor) {
        this.extensionProcessor = extensionProcessor;
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = (AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
        this.policyFactory = (PolicyFactory)modelFactories.getFactory(PolicyFactory.class);
        this.policyProcessor = new PolicySubjectProcessor(this.policyFactory);
        this.configuredOperationProcessor = new ConfiguredOperationProcessor(modelFactories);
        XMLInputFactory inputFactory = (XMLInputFactory)extensionPoints.getExtensionPoint(XMLInputFactory.class);
        XMLOutputFactory outputFactory = (XMLOutputFactory)extensionPoints.getExtensionPoint(XMLOutputFactory.class);
        StAXAttributeProcessorExtensionPoint attributeExtensionPoint = (StAXAttributeProcessorExtensionPoint)extensionPoints.getExtensionPoint(StAXAttributeProcessorExtensionPoint.class);
        this.extensionAttributeProcessor = new ExtensibleStAXAttributeProcessor(attributeExtensionPoint, inputFactory, outputFactory);
        this.processorContext = new ProcessorContext(extensionPoints);
    }

    private void warning(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(((Object)((Object)this)).getClass().getName(), "binding-jms-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(((Object)((Object)this)).getClass().getName(), "binding-jms-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    public QName getArtifactType() {
        return JMSBindingConstants.BINDING_JMS_QNAME;
    }

    public Class<JMSBinding> getModelType() {
        return JMSBinding.class;
    }

    public JMSBinding read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        String operationPropertiesName;
        String responseConnectionName;
        String requestConnectionName;
        String messageProcessorName;
        String jndiURL;
        String initialContextFactory;
        QName correlationScheme;
        String uri;
        Monitor monitor = context.getMonitor();
        JMSBinding jmsBinding = new JMSBinding();
        this.policyProcessor.readPolicies((Object)jmsBinding, reader);
        String name = reader.getAttributeValue(null, "name");
        if (name != null) {
            jmsBinding.setName(name);
        }
        if ((uri = reader.getAttributeValue(null, "uri")) != null && uri.length() > 0) {
            this.parseURI(uri, jmsBinding, monitor);
        }
        if ((correlationScheme = StAXHelper.getAttributeAsQName((XMLStreamReader)reader, (String)"correlationScheme")) != null) {
            if ("http://docs.oasis-open.org/ns/opencsa/sca/200912".equals(correlationScheme.getNamespaceURI()) && JMSBindingConstants.VALID_CORRELATION_SCHEMES.contains(correlationScheme.getLocalPart())) {
                jmsBinding.setCorrelationScheme(correlationScheme.getLocalPart());
            } else {
                this.error(monitor, "InvalidCorrelationScheme", reader, correlationScheme);
            }
        }
        if ((initialContextFactory = this.getURIString(reader, "initialContextFactory")) != null && initialContextFactory.length() > 0) {
            jmsBinding.setInitialContextFactoryName(initialContextFactory);
        }
        if ((jndiURL = this.getURIString(reader, "jndiURL")) != null && jndiURL.length() > 0) {
            jmsBinding.setJndiURL(jndiURL);
        }
        if ((messageProcessorName = reader.getAttributeValue(null, "messageProcessor")) != null && messageProcessorName.length() > 0) {
            if ("XMLTextMessage".equalsIgnoreCase(messageProcessorName)) {
                jmsBinding.setRequestWireFormat(new WireFormatJMSTextXML());
                jmsBinding.setResponseWireFormat(jmsBinding.getRequestWireFormat());
                jmsBinding.setResponseWireFormatIsDefault(true);
            } else if ("TextMessage".equalsIgnoreCase(messageProcessorName)) {
                jmsBinding.setRequestWireFormat(new WireFormatJMSText());
                jmsBinding.setResponseWireFormat(jmsBinding.getRequestWireFormat());
                jmsBinding.setResponseWireFormatIsDefault(true);
            } else if ("ObjectMessage".equalsIgnoreCase(messageProcessorName)) {
                jmsBinding.setRequestWireFormat(new WireFormatJMSObject());
                jmsBinding.setResponseWireFormat(jmsBinding.getRequestWireFormat());
                jmsBinding.setResponseWireFormatIsDefault(true);
            } else {
                jmsBinding.setRequestMessageProcessorName(messageProcessorName);
                jmsBinding.setResponseMessageProcessorName(messageProcessorName);
                jmsBinding.setRequestWireFormat(new WireFormatJMSText());
                jmsBinding.setResponseWireFormat(jmsBinding.getRequestWireFormat());
                jmsBinding.setResponseWireFormatIsDefault(true);
            }
        }
        if ((requestConnectionName = reader.getAttributeValue(null, "requestConnection")) != null && requestConnectionName.length() > 0) {
            jmsBinding.setRequestConnectionName(this.getQNameValue(reader, requestConnectionName));
        }
        if ((responseConnectionName = reader.getAttributeValue(null, "responseConnection")) != null && responseConnectionName.length() > 0) {
            jmsBinding.setResponseConnectionName(this.getQNameValue(reader, responseConnectionName));
        }
        if ((operationPropertiesName = reader.getAttributeValue(null, "operationProperties")) != null && operationPropertiesName.length() > 0) {
            jmsBinding.setOperationPropertiesName(this.getQNameValue(reader, operationPropertiesName));
        }
        QName elementQName = reader.getName();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Extension attributeExtension;
            QName attributeName = reader.getAttributeName(i);
            if (attributeName.getNamespaceURI() == null || attributeName.getNamespaceURI().length() <= 0 || elementQName.getNamespaceURI().equals(attributeName.getNamespaceURI())) continue;
            Object attributeValue = this.extensionAttributeProcessor.read(attributeName, reader, this.processorContext);
            if (attributeValue instanceof Extension) {
                attributeExtension = (Extension)attributeValue;
            } else {
                attributeExtension = this.assemblyFactory.createExtension();
                attributeExtension.setQName(attributeName);
                attributeExtension.setValue(attributeValue);
                attributeExtension.setAttribute(true);
            }
            jmsBinding.getAttributeExtensions().add(attributeExtension);
        }
        boolean endFound = false;
        block5: while (!endFound) {
            int fg = reader.next();
            switch (fg) {
                case 1: {
                    String elementName = reader.getName().getLocalPart();
                    if ("destination".equals(elementName)) {
                        this.parseDestination(reader, jmsBinding, monitor);
                        break;
                    }
                    if ("connectionFactory".equals(elementName)) {
                        this.parseConnectionFactory(reader, jmsBinding, monitor);
                        break;
                    }
                    if ("activationSpec".equals(elementName)) {
                        this.parseActivationSpec(reader, jmsBinding, monitor);
                        break;
                    }
                    if ("response".equals(elementName)) {
                        this.parseResponse(reader, jmsBinding, context);
                        break;
                    }
                    if ("resourceAdapter".equals(elementName)) {
                        this.parseResourceAdapter(reader, jmsBinding, monitor);
                        break;
                    }
                    if ("headers".equals(elementName)) {
                        this.parseHeaders(reader, jmsBinding, monitor);
                        break;
                    }
                    if ("operationProperties".equals(elementName)) {
                        this.parseOperationProperties(reader, jmsBinding, monitor);
                        break;
                    }
                    if ("messageSelection".equals(elementName)) {
                        this.parseSubscriptionHeaders(reader, jmsBinding);
                        break;
                    }
                    if (Constants.OPERATION_QNAME.equals(reader.getName())) {
                        ConfiguredOperation confOp = this.configuredOperationProcessor.read(reader, context);
                        if (confOp == null) continue block5;
                        jmsBinding.getConfiguredOperations().add(confOp);
                        break;
                    }
                    Object extension = this.extensionProcessor.read(reader, context);
                    if (extension == null) continue block5;
                    if (extension instanceof WireFormat) {
                        if (jmsBinding.getRequestWireFormat() == null) {
                            jmsBinding.setRequestWireFormat((WireFormat)extension);
                            break;
                        }
                        this.error(monitor, "WireFormatAlreadyDefined", reader, extension.toString());
                        break;
                    }
                    if (extension instanceof OperationSelector) {
                        if (jmsBinding.getOperationSelector() == null) {
                            jmsBinding.setOperationSelector((OperationSelector)extension);
                            break;
                        }
                        this.error(monitor, "OpSelectorAlreadyDefined", reader, extension.toString());
                        break;
                    }
                    String t = extension instanceof Extension ? ((Extension)extension).getQName().toString() : extension.toString();
                    this.error(monitor, "UnexpectedElement", reader, t);
                    break;
                }
                case 2: {
                    QName x = reader.getName();
                    if ("operation".equals(x.getLocalPart()) || x.getLocalPart().startsWith("wireFormat.") || x.getLocalPart().startsWith("operationSelector.")) break;
                    if (x.equals(JMSBindingConstants.BINDING_JMS_QNAME)) {
                        endFound = true;
                        break;
                    }
                    String t = x instanceof Extension ? ((Extension)x).getQName().toString() : x.toString();
                    this.error(monitor, "UnexpectedElement: expected " + JMSBindingConstants.BINDING_JMS_QNAME + ", found " + t, reader, t);
                }
            }
        }
        if (jmsBinding.getOperationSelector() == null) {
            jmsBinding.setOperationSelector(new OperationSelectorJMSDefault());
        }
        if (jmsBinding.getRequestWireFormat() == null) {
            jmsBinding.setRequestWireFormat(new WireFormatJMSDefault());
        }
        if (jmsBinding.getResponseWireFormat() == null) {
            jmsBinding.setResponseWireFormat(jmsBinding.getRequestWireFormat());
            jmsBinding.setResponseWireFormatIsDefault(true);
        }
        this.validate(jmsBinding, monitor);
        return jmsBinding;
    }

    protected void parseURI(String uri, JMSBinding jmsBinding, Monitor monitor) {
        if (!(uri.startsWith("jms:jndi:") || uri.startsWith("jms:queue:") || uri.startsWith("jms:topic:"))) {
            this.error(monitor, "MustStartWithSchema", jmsBinding, uri);
            return;
        }
        jmsBinding.setDestinationCreate("never");
        jmsBinding.setResponseDestinationCreate("never");
        jmsBinding.setConnectionFactoryCreate("never");
        jmsBinding.setResponseConnectionFactoryCreate("never");
        int i = uri.indexOf(63);
        if (i >= 0) {
            StringTokenizer st = new StringTokenizer(uri.substring(i + 1), "&");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.startsWith("jndiConnectionFactoryName=")) {
                    jmsBinding.setConnectionFactoryName(s.substring(26));
                    continue;
                }
                if (s.startsWith("deliveryMode=")) {
                    jmsBinding.setURIJMSDeliveryMode("persistent".equals(s.substring(13)));
                    continue;
                }
                if (s.startsWith("priority=")) {
                    jmsBinding.setURIJMSPriority(Integer.parseInt(s.substring(9)));
                    continue;
                }
                if (s.startsWith("timeToLive=")) {
                    jmsBinding.setURIJMSTimeToLive(Long.parseLong(s.substring(11)));
                    continue;
                }
                if (s.startsWith("selector='")) {
                    String selector = s.substring(10);
                    if (selector.startsWith("\"") || selector.startsWith("'")) {
                        selector = selector.substring(1, selector.length());
                    }
                    if (selector.endsWith("\"") || selector.endsWith("'")) {
                        selector = selector.substring(0, selector.length() - 1);
                    }
                    jmsBinding.setURIJMSSelector(selector);
                    continue;
                }
                if (s.startsWith("type")) {
                    String type = s.substring(5);
                    jmsBinding.setJMSURIType(type);
                    continue;
                }
                this.error(monitor, "UnknownTokenInURI", jmsBinding, s, uri);
                return;
            }
            int j = uri.indexOf(58, 4);
            jmsBinding.setDestinationName(uri.substring(j + 1, i));
            jmsBinding.setDestinationType(uri.substring(4, j));
        } else {
            int j = uri.indexOf(58, 4);
            jmsBinding.setDestinationName(uri.substring(j + 1));
            jmsBinding.setDestinationType(uri.substring(4, j));
        }
        jmsBinding.setJMSURI(uri);
    }

    public void resolve(JMSBinding model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        OperationSelector operationSelector;
        WireFormat responseWireFormat;
        WireFormat requestWireFormat;
        if (model.getRequestConnectionName() != null) {
            model.setRequestConnectionBinding(this.getConnectionBinding(model, "requestConnection", model.getRequestConnectionName(), resolver, context));
        }
        if (model.getResponseConnectionName() != null) {
            model.setResponseConnectionBinding(this.getConnectionBinding(model, "responseConnection", model.getResponseConnectionName(), resolver, context));
        }
        if (model.getOperationPropertiesName() != null) {
            model.setOperationPropertiesBinding(this.getConnectionBinding(model, "operationProperties", model.getOperationPropertiesName(), resolver, context));
        }
        if ((requestWireFormat = model.getRequestWireFormat()) != null) {
            this.extensionProcessor.resolve((Object)requestWireFormat, resolver, context);
        }
        if ((responseWireFormat = model.getResponseWireFormat()) != null) {
            this.extensionProcessor.resolve((Object)responseWireFormat, resolver, context);
        }
        if ((operationSelector = model.getOperationSelector()) != null) {
            this.extensionProcessor.resolve((Object)operationSelector, resolver, context);
        }
    }

    private JMSBinding getConnectionBinding(JMSBinding model, String attrName, QName bindingName, ModelResolver resolver, ProcessorContext context) {
        JMSBinding binding = new JMSBinding();
        binding.setTargetNamespace(bindingName.getNamespaceURI());
        binding.setName(bindingName.getLocalPart());
        binding.setUnresolved(true);
        binding = (JMSBinding)resolver.resolveModel(JMSBinding.class, (Object)binding, context);
        if (binding.isUnresolved()) {
            this.error(context.getMonitor(), "BindingNotFound", model, attrName, bindingName);
        }
        return binding;
    }

    private void parseDestination(XMLStreamReader reader, JMSBinding jmsBinding, Monitor monitor) throws XMLStreamException {
        String create;
        String type;
        jmsBinding.setIsDestinationSpecified(true);
        String name = this.getURIString(reader, "jndiName");
        if (name != null && name.length() > 0) {
            jmsBinding.setDestinationName(name);
        }
        if ((type = reader.getAttributeValue(null, "type")) != null && type.length() > 0) {
            if ("queue".equalsIgnoreCase(type)) {
                jmsBinding.setDestinationType("queue");
            } else if ("topic".equalsIgnoreCase(type)) {
                jmsBinding.setDestinationType("topic");
            } else {
                this.error(monitor, "InvalidDestinationType", reader, type);
            }
        }
        if ((create = reader.getAttributeValue(null, "create")) != null && create.length() > 0) {
            this.validateCreate(create, reader, monitor);
            jmsBinding.setDestinationCreate(create);
        }
        jmsBinding.getDestinationProperties().putAll(this.parseBindingProperties(reader, monitor));
        if (jmsBinding.getDestinationCreate().equals("ifNotExist") && (name == null || name.length() < 1)) {
            this.error(monitor, "MissingNameForCREATE_IF_NOT_EXIST", reader, new Object[0]);
        }
        if (jmsBinding.getDestinationCreate().equals("never") && (name == null || name.length() < 1)) {
            this.error(monitor, "MissingNameForCREATE_NEVER", reader, new Object[0]);
        }
    }

    private void parseConnectionFactory(XMLStreamReader reader, JMSBinding jmsBinding, Monitor monitor) throws XMLStreamException {
        String name = this.getURIString(reader, "jndiName");
        if (name != null && name.length() > 0) {
            jmsBinding.setConnectionFactoryName(name);
        } else {
            this.error(monitor, "MissingConnectionFactoryName", reader, new Object[0]);
        }
        String create = reader.getAttributeValue(null, "create");
        if (create != null && create.length() > 0) {
            this.validateCreate(create, reader, monitor);
            jmsBinding.setConnectionFactoryCreate(create);
        }
        if (jmsBinding.getConnectionFactoryCreate().equals("ifNotExist") && (name == null || name.length() < 1)) {
            this.error(monitor, "MissingNameForCREATE_IF_NOT_EXIST", reader, new Object[0]);
        }
        if (jmsBinding.getConnectionFactoryCreate().equals("never") && (name == null || name.length() < 1)) {
            this.error(monitor, "MissingNameForCREATE_NEVER", reader, new Object[0]);
        }
        jmsBinding.getConnectionFactoryProperties().putAll(this.parseBindingProperties(reader, monitor));
    }

    private void parseActivationSpec(XMLStreamReader reader, JMSBinding jmsBinding, Monitor monitor) throws XMLStreamException {
        String create;
        String name = reader.getAttributeValue(null, "jndiName");
        if (name != null && name.length() > 0) {
            jmsBinding.setActivationSpecName(name);
        }
        if ((create = reader.getAttributeValue(null, "create")) != null && create.length() > 0) {
            this.validateCreate(create, reader, monitor);
            jmsBinding.setActivationSpecCreate(create);
        }
        if (jmsBinding.getActivationSpecCreate().equals("ifNotExist") && (name == null || name.length() < 1)) {
            this.error(monitor, "MissingNameForCREATE_IF_NOT_EXIST", reader, new Object[0]);
        }
        if (jmsBinding.getActivationSpecCreate().equals("never") && (name == null || name.length() < 1)) {
            this.error(monitor, "MissingNameForCREATE_NEVER", reader, new Object[0]);
        }
        jmsBinding.getActivationSpecProperties().putAll(this.parseBindingProperties(reader, monitor));
    }

    private void parseResponseDestination(XMLStreamReader reader, JMSBinding jmsBinding, Monitor monitor) throws XMLStreamException {
        String create;
        String type;
        String name = this.getURIString(reader, "jndiName");
        if (name != null && name.length() > 0) {
            jmsBinding.setResponseDestinationName(name);
        }
        if ((type = reader.getAttributeValue(null, "type")) != null && type.length() > 0) {
            this.warning(monitor, "DoesntProcessResponseDestinationType", jmsBinding, new Object[0]);
            if ("queue".equalsIgnoreCase(type)) {
                jmsBinding.setResponseDestinationType("queue");
            } else if ("topic".equalsIgnoreCase(type)) {
                jmsBinding.setResponseDestinationType("topic");
            } else {
                this.error(monitor, "InvalidResponseDestinationType", reader, type);
            }
        }
        if ((create = reader.getAttributeValue(null, "create")) != null && create.length() > 0) {
            this.validateCreate(create, reader, monitor);
            jmsBinding.setResponseDestinationCreate(create);
        }
        if (jmsBinding.getResponseDestinationCreate().equals("ifNotExist") && (name == null || name.length() < 1)) {
            this.error(monitor, "MissingNameForCREATE_IF_NOT_EXIST", reader, new Object[0]);
        }
        if (jmsBinding.getResponseDestinationCreate().equals("never") && (name == null || name.length() < 1)) {
            this.error(monitor, "MissingNameForCREATE_NEVER", reader, new Object[0]);
        }
        jmsBinding.getResponseDestinationProperties().putAll(this.parseBindingProperties(reader, monitor));
    }

    private void parseResponseConnectionFactory(XMLStreamReader reader, JMSBinding jmsBinding, Monitor monitor) throws XMLStreamException {
        String name = this.getURIString(reader, "jndiName");
        if (name != null && name.length() > 0) {
            jmsBinding.setResponseConnectionFactoryName(name);
        } else {
            this.warning(monitor, "MissingResponseConnectionFactory", reader, new Object[0]);
        }
        String create = reader.getAttributeValue(null, "create");
        if (create != null && create.length() > 0) {
            this.validateCreate(create, reader, monitor);
            jmsBinding.setResponseConnectionFactoryCreate(create);
        }
        if (jmsBinding.getResponseConnectionFactoryCreate().equals("ifNotExist") && (name == null || name.length() < 1)) {
            this.error(monitor, "MissingNameForCREATE_IF_NOT_EXIST", reader, new Object[0]);
        }
        if (jmsBinding.getResponseConnectionFactoryCreate().equals("never") && (name == null || name.length() < 1)) {
            this.error(monitor, "MissingNameForCREATE_NEVER", reader, new Object[0]);
        }
        jmsBinding.getResponseConnectionFactoryProperties().putAll(this.parseBindingProperties(reader, monitor));
    }

    private void parseResponseActivationSpec(XMLStreamReader reader, JMSBinding jmsBinding, Monitor monitor) throws XMLStreamException {
        String create;
        String name = reader.getAttributeValue(null, "jndiName");
        if (name != null && name.length() > 0) {
            jmsBinding.setResponseActivationSpecName(name);
        }
        if ((create = reader.getAttributeValue(null, "create")) != null && create.length() > 0) {
            this.validateCreate(create, reader, monitor);
            jmsBinding.setResponseActivationSpecCreate(create);
        }
        if (jmsBinding.getResponseActivationSpecCreate().equals("ifNotExist") && (name == null || name.length() < 1)) {
            this.error(monitor, "MissingNameForCREATE_IF_NOT_EXIST", reader, new Object[0]);
        }
        if (jmsBinding.getResponseActivationSpecCreate().equals("never") && (name == null || name.length() < 1)) {
            this.error(monitor, "MissingNameForCREATE_NEVER", reader, new Object[0]);
        }
        jmsBinding.getResponseActivationSpecProperties().putAll(this.parseBindingProperties(reader, monitor));
    }

    private void validateCreate(String create, XMLStreamReader reader, Monitor monitor) {
        if ("always".equals(create)) {
            return;
        }
        if ("never".equals(create)) {
            return;
        }
        if ("ifNotExist".equals(create)) {
            return;
        }
        this.error(monitor, "InvalidCreate", reader, create);
    }

    private void parseResponse(XMLStreamReader reader, JMSBinding jmsBinding, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        Monitor monitor = context.getMonitor();
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String elementName = reader.getName().getLocalPart();
                    if ("destination".equals(elementName)) {
                        this.parseResponseDestination(reader, jmsBinding, context.getMonitor());
                        break;
                    }
                    if ("connectionFactory".equals(elementName)) {
                        this.parseResponseConnectionFactory(reader, jmsBinding, monitor);
                        break;
                    }
                    if ("activationSpec".equals(elementName)) {
                        this.parseResponseActivationSpec(reader, jmsBinding, monitor);
                        break;
                    }
                    Object extension = this.extensionProcessor.read(reader, context);
                    if (extension != null) {
                        if (extension instanceof WireFormat) {
                            if (jmsBinding.getResponseWireFormat() == null) {
                                jmsBinding.setResponseWireFormat((WireFormat)extension);
                            } else {
                                this.error(context.getMonitor(), "ResponseWireformatAlreadyDefined", reader, extension.toString());
                            }
                        } else {
                            String t = extension instanceof Extension ? ((Extension)extension).getQName().toString() : extension.toString();
                            this.error(context.getMonitor(), "UnexpectedElement", reader, t);
                        }
                    }
                    reader.next();
                    break;
                }
                case 2: {
                    QName x = reader.getName();
                    if (x.getLocalPart().equals("response")) {
                        return;
                    }
                    this.error(context.getMonitor(), "UnexpectedResponseElement", reader, x.toString());
                }
            }
        }
    }

    private void parseResourceAdapter(XMLStreamReader reader, JMSBinding jmsBinding, Monitor monitor) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "name");
        if (name != null && name.length() > 0) {
            jmsBinding.setResourceAdapterName(name);
        } else {
            this.error(monitor, "MissingResourceAdapterName", reader, new Object[0]);
        }
        jmsBinding.getResourceAdapterProperties().putAll(this.parseBindingProperties(reader, monitor));
    }

    private void parseHeaders(XMLStreamReader reader, JMSBinding jmsBinding, Monitor monitor) throws XMLStreamException {
        String jmsPriority;
        String jmsTimeToLive;
        String jmsDeliveryMode;
        String jmsType = reader.getAttributeValue(null, "type");
        if (jmsType != null && jmsType.length() > 0) {
            jmsBinding.setJMSHeaderType(jmsType);
        }
        if ((jmsDeliveryMode = reader.getAttributeValue(null, "deliveryMode")) != null && jmsDeliveryMode.length() > 0) {
            if ("persistent".equalsIgnoreCase(jmsDeliveryMode)) {
                jmsBinding.setJMSHeaderDeliveryMode(true);
            } else if ("nonpersistent".equalsIgnoreCase(jmsDeliveryMode)) {
                jmsBinding.setJMSHeaderDeliveryMode(false);
            } else {
                this.error(monitor, "InvalidJMSDeliveryMode", jmsBinding, jmsDeliveryMode);
            }
        }
        if ((jmsTimeToLive = reader.getAttributeValue(null, "timeToLive")) != null && jmsTimeToLive.length() > 0) {
            jmsBinding.setJMSHeaderTimeToLive(Long.parseLong(jmsTimeToLive));
        }
        if ((jmsPriority = reader.getAttributeValue(null, "priority")) != null && jmsPriority.length() > 0) {
            try {
                int p = Integer.parseInt(jmsPriority);
                if (p >= 0 && p <= 9) {
                    jmsBinding.setJMSHeaderPriority(p);
                } else {
                    this.warning(monitor, "InvalidJMSPriority", jmsBinding, jmsPriority);
                }
            }
            catch (NumberFormatException ex) {
                this.error(monitor, "InvalidJMSPriority", jmsBinding, jmsPriority);
            }
        }
        while (true) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getName().getLocalPart().equals("property")) break;
                    this.parseProperty(reader, jmsBinding);
                    break;
                }
                case 2: {
                    QName x = reader.getName();
                    if (x.getLocalPart().equals("headers")) {
                        return;
                    }
                    this.error(monitor, "UnexpectedResponseElement", reader, x.toString());
                }
            }
        }
    }

    private void parseProperty(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String type;
        jmsBinding.setHeaders(true);
        String name = reader.getAttributeValue(null, "name");
        QName typeName = StAXHelper.getAttributeAsQName((XMLStreamReader)reader, (String)"type");
        String string = type = typeName == null ? null : typeName.getLocalPart();
        if (name != null && name.length() > 0) {
            Object value = reader.getElementText();
            if ("boolean".equalsIgnoreCase(type)) {
                value = Boolean.parseBoolean((String)value);
            } else if ("byte".equalsIgnoreCase(type)) {
                value = Byte.parseByte((String)value);
            } else if ("short".equalsIgnoreCase(type)) {
                value = Short.parseShort((String)value);
            } else if ("int".equalsIgnoreCase(type)) {
                value = Integer.parseInt((String)value);
            } else if ("long".equalsIgnoreCase(type)) {
                value = Long.parseLong((String)value);
            } else if ("float".equalsIgnoreCase(type)) {
                value = Float.valueOf(Float.parseFloat((String)value));
            } else if ("double".equalsIgnoreCase(type)) {
                value = Double.parseDouble((String)value);
            } else if ("String".equalsIgnoreCase(type)) {
                // empty if block
            }
            jmsBinding.setProperty(name, value);
        }
    }

    private void parseOperationProperties(XMLStreamReader reader, JMSBinding jmsBinding, Monitor monitor) throws XMLStreamException {
        String opName;
        if (jmsBinding.getOperationPropertiesName() != null) {
            this.error(monitor, "DuplicateOperationProperties", jmsBinding, new Object[0]);
        }
        if ((opName = reader.getAttributeValue(null, "name")) == null || opName.length() < 1) {
            this.error(monitor, "MissingJMSOperationPropertyName", jmsBinding, new Object[0]);
            return;
        }
        jmsBinding.addOperationName(opName);
        String nativeOpName = reader.getAttributeValue(null, "selectedOperation");
        if (nativeOpName != null && nativeOpName.length() > 0) {
            jmsBinding.setNativeOperationName(opName, nativeOpName);
            jmsBinding.setNativeOperationNameToOpName(nativeOpName, opName);
        }
        HashMap<String, BindingProperty> props = new HashMap<String, BindingProperty>();
        block4: while (true) {
            switch (reader.next()) {
                case 1: {
                    if (reader.getName().getLocalPart().equals("headers")) {
                        this.parseOperationHeaders(reader, jmsBinding, opName, monitor);
                        break;
                    }
                    if (!reader.getName().getLocalPart().equals("property")) break;
                    this.processProperty(reader, props, monitor);
                    break;
                }
                case 2: {
                    QName x;
                    if (!reader.isEndElement() || (x = reader.getName()).getLocalPart().equals("headers") || x.getLocalPart().equals("property")) continue block4;
                    if (x.getLocalPart().equals("operationProperties")) {
                        jmsBinding.getOperationPropertiesProperties(opName).putAll(props);
                        return;
                    }
                    this.error(monitor, "UnexpectedResponseElement", reader, x.toString());
                }
            }
        }
    }

    private void parseOperationHeaders(XMLStreamReader reader, JMSBinding jmsBinding, String opName, Monitor monitor) throws XMLStreamException {
        String jmsPriority;
        String jmsTimeToLive;
        String jmsDeliveryMode;
        String jmsType = reader.getAttributeValue(null, "type");
        if (jmsType != null && jmsType.length() > 0) {
            jmsBinding.setOperationJMSType(opName, jmsType);
        }
        if ((jmsDeliveryMode = reader.getAttributeValue(null, "deliveryMode")) != null && jmsDeliveryMode.length() > 0) {
            if ("persistent".equalsIgnoreCase(jmsDeliveryMode)) {
                jmsBinding.setOperationJMSDeliveryMode(opName, true);
            } else if ("nonpersistent".equalsIgnoreCase(jmsDeliveryMode)) {
                jmsBinding.setOperationJMSDeliveryMode(opName, false);
            } else {
                this.error(monitor, "InvalidOPJMSDeliveryMode", jmsBinding, jmsDeliveryMode);
            }
        }
        if ((jmsTimeToLive = reader.getAttributeValue(null, "timeToLive")) != null && jmsTimeToLive.length() > 0) {
            jmsBinding.setOperationJMSTimeToLive(opName, Long.parseLong(jmsTimeToLive));
        }
        if ((jmsPriority = reader.getAttributeValue(null, "priority")) != null && jmsPriority.length() > 0) {
            try {
                int p = Integer.parseInt(jmsPriority);
                if (p >= 0 && p <= 9) {
                    jmsBinding.setOperationJMSPriority(opName, p);
                } else {
                    this.warning(monitor, "InvalidOPJMSPriority", jmsBinding, jmsPriority);
                }
            }
            catch (NumberFormatException ex) {
                this.error(monitor, "InvalidOPJMSPriority", jmsBinding, jmsPriority);
            }
        }
        while (true) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getName().getLocalPart().equals("property")) break;
                    this.parseOperationPropertyProperties(reader, jmsBinding, opName);
                    break;
                }
                case 2: {
                    QName x = reader.getName();
                    if (x.getLocalPart().equals("headers")) {
                        return;
                    }
                    this.error(monitor, "UnexpectedResponseElement", reader, x.toString());
                }
            }
        }
    }

    private void parseOperationPropertyProperties(XMLStreamReader reader, JMSBinding jmsBinding, String opName) throws XMLStreamException {
        String type;
        String propName = reader.getAttributeValue(null, "name");
        QName typeName = StAXHelper.getAttributeAsQName((XMLStreamReader)reader, (String)"type");
        String string = type = typeName == null ? null : typeName.getLocalPart();
        if (propName != null && propName.length() > 0) {
            Object value = reader.getElementText();
            if ("boolean".equalsIgnoreCase(type)) {
                value = Boolean.parseBoolean((String)value);
            } else if ("byte".equalsIgnoreCase(type)) {
                value = Byte.parseByte((String)value);
            } else if ("short".equalsIgnoreCase(type)) {
                value = Short.parseShort((String)value);
            } else if ("int".equalsIgnoreCase(type)) {
                value = Integer.parseInt((String)value);
            } else if ("long".equalsIgnoreCase(type)) {
                value = Long.parseLong((String)value);
            } else if ("float".equalsIgnoreCase(type)) {
                value = Float.valueOf(Float.parseFloat((String)value));
            } else if ("double".equalsIgnoreCase(type)) {
                value = Double.parseDouble((String)value);
            } else if ("String".equalsIgnoreCase(type)) {
                // empty if block
            }
            jmsBinding.setOperationProperty(opName, propName, value);
        }
    }

    private void parseSubscriptionHeaders(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String jmsSelector = reader.getAttributeValue(null, "selector");
        if (jmsSelector != null && jmsSelector.length() > 0 && jmsBinding.getJMSSelector() == null) {
            jmsBinding.setJMSSelector(jmsSelector);
        }
        while (reader.hasNext() && (reader.next() != 2 || !"messageSelection".equals(reader.getName().getLocalPart()))) {
        }
    }

    private Map<String, BindingProperty> parseBindingProperties(XMLStreamReader reader, Monitor monitor) throws XMLStreamException {
        HashMap<String, BindingProperty> props = new HashMap<String, BindingProperty>();
        String parentName = reader.getName().getLocalPart();
        boolean completed = false;
        while (!completed) {
            switch (reader.next()) {
                case 1: {
                    String elementName = reader.getName().getLocalPart();
                    if (!"property".equals(elementName)) break;
                    this.processProperty(reader, props, monitor);
                    break;
                }
                case 2: {
                    String endName = reader.getName().getLocalPart();
                    if (!parentName.equals(endName)) break;
                    completed = true;
                }
            }
        }
        return props;
    }

    private void processProperty(XMLStreamReader reader, Map<String, BindingProperty> props, Monitor monitor) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "name");
        if (name == null || name.length() < 1) {
            this.error(monitor, "InvalidPropertyElement", reader, new Object[0]);
        }
        String type = reader.getAttributeValue(null, "type");
        String value = reader.getElementText();
        props.put(name, new BindingProperty(name, type, value));
    }

    public void validate() {
        this.validate(null, null);
    }

    protected void validate(JMSBinding jmsBinding, Monitor monitor) {
        HashSet<String> ops;
        String responseDestinationName;
        QName responseConnectionName;
        String destinationName;
        String activationSpecName;
        if (jmsBinding == null) {
            return;
        }
        String connectionFactoryName = jmsBinding.getConnectionFactoryName();
        if (connectionFactoryName != null && connectionFactoryName.length() > 0) {
            if ("queue" == jmsBinding.getDestinationType() && connectionFactoryName.contains("topic")) {
                this.error(monitor, "DestinationQueueContradiction", jmsBinding, connectionFactoryName);
            }
            if ("topic" == jmsBinding.getDestinationType() && connectionFactoryName.contains("queue")) {
                this.error(monitor, "DestinationTopicContradiction", jmsBinding, connectionFactoryName);
            }
        }
        if (connectionFactoryName != null && connectionFactoryName.length() > 0 && (activationSpecName = jmsBinding.getActivationSpecName()) != null && activationSpecName.length() > 0) {
            this.error(monitor, "ConnectionFactoryActivationSpecContradiction", jmsBinding, connectionFactoryName, activationSpecName);
        }
        if (jmsBinding.getJMSURI() != null && jmsBinding.getJMSURI().length() > 0 && jmsBinding.isDestinationSpecified()) {
            this.error(monitor, "DestinationURIContradiction", jmsBinding, jmsBinding.getJMSURI(), jmsBinding.getDestinationName());
        }
        if ("always".equals(jmsBinding.getActivationSpecCreate()) && jmsBinding.getActivationSpecName() == null) {
            this.error(monitor, "ActivationSpecNameRequiredForCreateAlways", jmsBinding, new Object[0]);
        }
        if (connectionFactoryName != null && connectionFactoryName.length() > 0 && ((destinationName = jmsBinding.getDestinationName()) == null || destinationName.length() < 1)) {
            this.error(monitor, "ConnectionFactoryDestinationContradiction", jmsBinding, connectionFactoryName);
        }
        if ((responseConnectionName = jmsBinding.getResponseConnectionName()) != null && responseConnectionName.getLocalPart().length() > 0 && (responseDestinationName = jmsBinding.getResponseDestinationName()) != null && responseDestinationName.length() > 0) {
            this.error(monitor, "ResponseAttrElement", jmsBinding, responseConnectionName, responseDestinationName);
        }
        if ((ops = new HashSet<String>(jmsBinding.getNativeOperationNames().values())).size() != jmsBinding.getNativeOperationNames().values().size()) {
            this.error(monitor, "BJM30029", jmsBinding, new Object[0]);
        }
    }

    public void write(JMSBinding jmsBinding, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, "http://docs.oasis-open.org/ns/opencsa/sca/200912", "binding.jms", new BaseStAXArtifactProcessor.XAttr[]{new BaseStAXArtifactProcessor.XAttr("requestConnection", jmsBinding.getRequestConnectionName()), new BaseStAXArtifactProcessor.XAttr("responseConnection", jmsBinding.getResponseConnectionName()), new BaseStAXArtifactProcessor.XAttr("operationProperties", jmsBinding.getOperationPropertiesName())});
        if (jmsBinding.getName() != null) {
            writer.writeAttribute("name", jmsBinding.getName());
        }
        if (jmsBinding.getJMSURI() != null) {
            writer.writeAttribute("uri", jmsBinding.getJMSURI());
            this.writeEnd(writer);
            return;
        }
        String correlationScheme = jmsBinding.getCorrelationScheme();
        if (correlationScheme != null && !correlationScheme.equals("messageID")) {
            writer.writeAttribute("correlationScheme", jmsBinding.getCorrelationScheme());
        }
        if (jmsBinding.getInitialContextFactoryName() != null) {
            writer.writeAttribute("initialContextFactory", jmsBinding.getInitialContextFactoryName());
        }
        if (jmsBinding.getJndiURL() != null) {
            writer.writeAttribute("jndiURL", jmsBinding.getJndiURL());
        }
        for (Extension extension : jmsBinding.getAttributeExtensions()) {
            if (!extension.isAttribute()) continue;
            this.extensionAttributeProcessor.write((Object)extension, writer, this.processorContext);
        }
        if (jmsBinding.getRequestWireFormat() != null && !(jmsBinding.getRequestWireFormat() instanceof WireFormatJMSDefault)) {
            this.writeWireFormat(jmsBinding.getRequestWireFormat(), writer, context);
        }
        if (jmsBinding.getOperationSelector() != null && !(jmsBinding.getOperationSelector() instanceof OperationSelectorJMSDefault)) {
            this.writeOperationSelector(jmsBinding.getOperationSelector(), writer, context);
        }
        if (jmsBinding.containsHeaders()) {
            this.writeHeaders(jmsBinding, writer);
        }
        this.writeOperationProperties(jmsBinding, writer);
        this.writeSubscriptionHeaders(jmsBinding, writer);
        this.writeDestinationProperties(jmsBinding, writer);
        this.writeConnectionFactoryProperties(jmsBinding, writer);
        this.writeActivationSpecProperties(jmsBinding, writer);
        String responseDestName = jmsBinding.getResponseDestinationName();
        String responseCFName = jmsBinding.getResponseConnectionFactoryName();
        String responseASName = jmsBinding.getResponseActivationSpecName();
        if (responseDestName != null || responseCFName != null || responseASName != null) {
            writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "response");
            if (!jmsBinding.isResponseWireFormatDefault() && jmsBinding.getResponseWireFormat() != null && !(jmsBinding.getResponseWireFormat() instanceof WireFormatJMSDefault)) {
                this.writeWireFormat(jmsBinding.getResponseWireFormat(), writer, context);
            }
            this.writeResponseDestinationProperties(jmsBinding, writer);
            this.writeResponseConnectionFactoryProperties(jmsBinding, writer);
            this.writeResponseActivationSpecProperties(jmsBinding, writer);
            writer.writeEndElement();
            writer.writeCharacters(" ");
        }
        this.writeResourceAdapterProperties(jmsBinding, writer);
        this.writeConfiguredOperations(jmsBinding, writer, context);
        this.writeEnd(writer);
    }

    private void writeHeaders(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        Integer jmsPriority;
        Long jmsTimeToLive;
        Boolean jmsDeliveryMode;
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "headers");
        String jmsType = jmsBinding.getJMSHeaderType();
        if (jmsType != null && jmsType.length() > 0) {
            writer.writeAttribute("type", jmsType);
        }
        if ((jmsDeliveryMode = jmsBinding.isHeaderDeliveryModePersistent()) != null) {
            if (jmsDeliveryMode.booleanValue()) {
                writer.writeAttribute("deliveryMode", "persistent");
            } else {
                writer.writeAttribute("deliveryMode", "nonpersistent");
            }
        }
        if ((jmsTimeToLive = jmsBinding.getJMSHeaderTimeToLive()) != null) {
            writer.writeAttribute("timeToLive", jmsTimeToLive.toString());
        }
        if ((jmsPriority = jmsBinding.getJMSHeaderPriority()) != null) {
            writer.writeAttribute("priority", jmsPriority.toString());
        }
        Map<String, Object> properties = jmsBinding.getProperties();
        this.writeProperties(properties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeProperties(Map<String, Object> properties, XMLStreamWriter writer) throws XMLStreamException {
        if (properties == null || properties.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "property");
            writer.writeAttribute("name", key.toString());
            if (value instanceof String) {
                writer.writeCharacters(value.toString());
            } else if (value instanceof BindingProperty) {
                BindingProperty property = (BindingProperty)value;
                String type = property.getType();
                if (type != null) {
                    writer.writeAttribute("type", type);
                }
                writer.writeCharacters(property.getValue().toString());
            } else if (value instanceof Boolean) {
                writer.writeAttribute("type", "boolean");
                writer.writeCharacters(value.toString());
            } else if (value instanceof Byte) {
                writer.writeAttribute("type", "byte");
                writer.writeCharacters(value.toString());
            } else if (value instanceof Short) {
                writer.writeAttribute("type", "short");
                writer.writeCharacters(value.toString());
            } else if (value instanceof Integer) {
                writer.writeAttribute("type", "int");
                writer.writeCharacters(value.toString());
            } else if (value instanceof Long) {
                writer.writeAttribute("type", "long");
                writer.writeCharacters(value.toString());
            } else if (value instanceof Float) {
                writer.writeAttribute("type", "float");
                writer.writeCharacters(value.toString());
            } else if (value instanceof Double) {
                writer.writeAttribute("type", "double");
                writer.writeCharacters(value.toString());
            } else {
                writer.writeCharacters(value.toString());
            }
            writer.writeEndElement();
        }
    }

    private void writeOperationProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        if (jmsBinding.getOperationPropertiesBinding() != null) {
            return;
        }
        Set<String> operationNames = jmsBinding.getOperationNames();
        if (operationNames == null || operationNames.size() < 1) {
            return;
        }
        for (String opName : operationNames) {
            writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "operationProperties");
            writer.writeAttribute("name", opName);
            String nativeOperation = jmsBinding.getNativeOperationName(opName);
            if (nativeOperation != null && nativeOperation.length() > 0 && !nativeOperation.equals(opName)) {
                writer.writeAttribute("selectedOperation", nativeOperation);
            }
            Map<String, BindingProperty> operationPropertiesProperties = jmsBinding.getOperationPropertiesProperties(opName);
            this.writeBindingProperties(operationPropertiesProperties, writer);
            String jmsType = jmsBinding.getOperationJMSType(opName);
            String jmsCorrelationId = jmsBinding.getOperationJMSCorrelationId(opName);
            Boolean jmsDeliveryMode = jmsBinding.getOperationJMSDeliveryMode(opName);
            Long jmsTimeToLive = jmsBinding.getOperationJMSTimeToLive(opName);
            Integer jmsPriority = jmsBinding.getOperationJMSPriority(opName);
            Map<String, Object> operationProperties = jmsBinding.getOperationProperties(opName);
            if (operationProperties != null && !operationProperties.isEmpty() || jmsType != null && jmsType.trim().length() > 0 || jmsDeliveryMode != null || jmsTimeToLive != null || jmsPriority != null) {
                writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "headers");
                if (jmsType != null && jmsType.trim().length() > 0) {
                    writer.writeAttribute("type", jmsType.trim());
                }
                if (jmsDeliveryMode != null) {
                    if (jmsDeliveryMode.booleanValue()) {
                        writer.writeAttribute("deliveryMode", "persistent");
                    } else {
                        writer.writeAttribute("deliveryMode", "nonpersistent");
                    }
                }
                if (jmsTimeToLive != null) {
                    writer.writeAttribute("timeToLive", jmsTimeToLive.toString());
                }
                if (jmsPriority != null) {
                    writer.writeAttribute("priority", jmsPriority.toString());
                }
                this.writeProperties(operationProperties, writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeCharacters(" ");
        }
    }

    private void writeBindingProperties(Map<String, BindingProperty> properties, XMLStreamWriter writer) throws XMLStreamException {
        if (properties == null || properties.size() == 0) {
            return;
        }
        for (Map.Entry<String, BindingProperty> entry : properties.entrySet()) {
            String key = entry.getKey();
            BindingProperty value = entry.getValue();
            writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "property");
            if (key != null) {
                writer.writeAttribute("name", key.toString());
            }
            if (value instanceof String) {
                writer.writeCharacters(value.toString());
            } else if (value instanceof BindingProperty) {
                BindingProperty property = value;
                String type = property.getType();
                if (type != null) {
                    writer.writeAttribute("type", type);
                }
                writer.writeCharacters(property.getValue().toString());
            } else {
                writer.writeCharacters(value.toString());
            }
            writer.writeEndElement();
        }
    }

    private void writeSubscriptionHeaders(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String jmsSubscriptionHeaders = jmsBinding.getJMSSelector();
        if (jmsSubscriptionHeaders != null && jmsSubscriptionHeaders.length() > 0) {
            writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "messageSelection");
            writer.writeAttribute("selector", jmsSubscriptionHeaders);
            writer.writeEndElement();
        }
    }

    private void writeDestinationProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String destinationCreate;
        String destinationType;
        String destinationName = jmsBinding.getDestinationName();
        if (destinationName == null || destinationName.length() < 1) {
            return;
        }
        if (destinationName == null) {
            return;
        }
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "destination");
        if (destinationName != null && destinationName.length() > 0) {
            writer.writeAttribute("jndiName", destinationName);
        }
        if ((destinationType = jmsBinding.getDestinationType()) != null && destinationType.length() > 0) {
            writer.writeAttribute("type", destinationType);
        }
        if ((destinationCreate = jmsBinding.getDestinationCreate()) != null && destinationCreate.length() > 0 && !destinationCreate.equals("ifNotExist")) {
            writer.writeAttribute("create", destinationCreate);
        }
        Map<String, BindingProperty> destinationProperties = jmsBinding.getDestinationProperties();
        this.writeBindingProperties(destinationProperties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeConnectionFactoryProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String destinationCreate;
        String cfName = jmsBinding.getConnectionFactoryName();
        if (cfName == null || cfName.length() < 1) {
            return;
        }
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "connectionFactory");
        if (cfName != null && cfName.length() > 0) {
            writer.writeAttribute("jndiName", cfName);
        }
        if ((destinationCreate = jmsBinding.getConnectionFactoryCreate()) != null && destinationCreate.length() > 0 && !destinationCreate.equals("ifNotExist")) {
            writer.writeAttribute("create", destinationCreate);
        }
        Map<String, BindingProperty> cfProperties = jmsBinding.getConnectionFactoryProperties();
        this.writeBindingProperties(cfProperties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeActivationSpecProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String destinationCreate;
        String asName = jmsBinding.getActivationSpecName();
        if (asName == null || asName.length() < 1) {
            return;
        }
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "activationSpec");
        if (asName != null && asName.length() > 0) {
            writer.writeAttribute("jndiName", asName);
        }
        if ((destinationCreate = jmsBinding.getActivationSpecCreate()) != null && destinationCreate.length() > 0) {
            writer.writeAttribute("create", destinationCreate);
        }
        Map<String, BindingProperty> cfProperties = jmsBinding.getActivationSpecProperties();
        this.writeBindingProperties(cfProperties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeResponseDestinationProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String destinationCreate;
        String destinationName = jmsBinding.getResponseDestinationName();
        if (destinationName == null || destinationName.length() < 1) {
            return;
        }
        if (destinationName == null) {
            return;
        }
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "destination");
        if (destinationName != null && destinationName.length() > 0) {
            writer.writeAttribute("jndiName", destinationName);
        }
        if ((destinationCreate = jmsBinding.getResponseDestinationCreate()) != null && destinationCreate.length() > 0) {
            writer.writeAttribute("create", destinationCreate);
        }
        Map<String, BindingProperty> destinationProperties = jmsBinding.getResponseDestinationProperties();
        this.writeBindingProperties(destinationProperties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeResponseConnectionFactoryProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String destinationCreate;
        String cfName = jmsBinding.getResponseConnectionFactoryName();
        if (cfName == null || cfName.length() < 1) {
            return;
        }
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "connectionFactory");
        if (cfName != null && cfName.length() > 0) {
            writer.writeAttribute("jndiName", cfName);
        }
        if ((destinationCreate = jmsBinding.getResponseConnectionFactoryCreate()) != null && destinationCreate.length() > 0) {
            writer.writeAttribute("create", destinationCreate);
        }
        Map<String, BindingProperty> cfProperties = jmsBinding.getResponseConnectionFactoryProperties();
        this.writeBindingProperties(cfProperties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeResponseActivationSpecProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String destinationCreate;
        String asName = jmsBinding.getResponseActivationSpecName();
        if (asName == null || asName.length() < 1) {
            return;
        }
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "activationSpec");
        if (asName != null && asName.length() > 0) {
            writer.writeAttribute("name", asName);
        }
        if ((destinationCreate = jmsBinding.getResponseActivationSpecCreate()) != null && destinationCreate.length() > 0) {
            writer.writeAttribute("create", destinationCreate);
        }
        Map<String, BindingProperty> cfProperties = jmsBinding.getResponseActivationSpecProperties();
        this.writeBindingProperties(cfProperties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeResourceAdapterProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String asName = jmsBinding.getResourceAdapterName();
        if (asName == null || asName.length() < 1) {
            return;
        }
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "resourceAdapter");
        if (asName != null && asName.length() > 0) {
            writer.writeAttribute("name", asName);
        }
        Map<String, BindingProperty> cfProperties = jmsBinding.getResourceAdapterProperties();
        this.writeBindingProperties(cfProperties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeConfiguredOperations(JMSBinding jmsBinding, XMLStreamWriter writer, ProcessorContext context) throws XMLStreamException, ContributionWriteException {
        List<ConfiguredOperation> configOps = jmsBinding.getConfiguredOperations();
        if (configOps == null || configOps.size() < 1) {
            return;
        }
        Iterator<ConfiguredOperation> it = configOps.iterator();
        while (it.hasNext()) {
            this.configuredOperationProcessor.write(it.next(), writer, context);
        }
        writer.writeCharacters(" ");
    }

    private void writeWireFormat(WireFormat wireFormat, XMLStreamWriter writer, ProcessorContext context) throws XMLStreamException, ContributionWriteException {
        this.extensionProcessor.write((Object)wireFormat, writer, context);
    }

    private void writeOperationSelector(OperationSelector operationSeletor, XMLStreamWriter writer, ProcessorContext context) throws XMLStreamException, ContributionWriteException {
        this.extensionProcessor.write((Object)operationSeletor, writer, context);
    }
}

