/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.provider;

import javax.servlet.Servlet;
import org.apache.tuscany.sca.assembly.OperationSelector;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.binding.http.HTTPBinding;
import org.apache.tuscany.sca.binding.http.operationselector.HTTPDefaultOperationSelector;
import org.apache.tuscany.sca.binding.http.provider.HTTPBindingServiceServlet;
import org.apache.tuscany.sca.binding.http.wireformat.HTTPDefaultWireFormat;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.EndpointProvider;
import org.apache.tuscany.sca.provider.OperationSelectorProvider;
import org.apache.tuscany.sca.provider.OperationSelectorProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.provider.WireFormatProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class HTTPServiceBindingProvider
implements EndpointProvider {
    private ExtensionPointRegistry extensionPoints;
    private RuntimeEndpoint endpoint;
    private HTTPBinding binding;
    private MessageFactory messageFactory;
    private OperationSelectorProvider osProvider;
    private WireFormatProvider wfProvider;
    private ServletHost servletHost;
    private String servletMapping;
    private InterfaceContract interfaceContract;

    public HTTPServiceBindingProvider(RuntimeEndpoint endpoint, ExtensionPointRegistry extensionPoints, MessageFactory messageFactory, ServletHost servletHost) {
        WireFormatProviderFactory wfProviderFactory;
        OperationSelectorProviderFactory osProviderFactory;
        this.endpoint = endpoint;
        this.binding = (HTTPBinding)endpoint.getBinding();
        this.extensionPoints = extensionPoints;
        this.messageFactory = messageFactory;
        this.servletHost = servletHost;
        if (this.binding.getOperationSelector() == null) {
            this.binding.setOperationSelector((OperationSelector)new HTTPDefaultOperationSelector());
        }
        if (this.binding.getRequestWireFormat() == null) {
            this.binding.setRequestWireFormat((WireFormat)new HTTPDefaultWireFormat());
        }
        if (this.binding.getResponseWireFormat() == null) {
            this.binding.setResponseWireFormat((WireFormat)new HTTPDefaultWireFormat());
        }
        ProviderFactoryExtensionPoint providerFactories = (ProviderFactoryExtensionPoint)extensionPoints.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        if (this.binding.getOperationSelector() != null && (osProviderFactory = (OperationSelectorProviderFactory)providerFactories.getProviderFactory(this.binding.getOperationSelector().getClass())) != null) {
            this.osProvider = osProviderFactory.createServiceOperationSelectorProvider(endpoint);
        }
        if (this.binding.getRequestWireFormat() != null && this.binding.getResponseWireFormat() != null && (wfProviderFactory = (WireFormatProviderFactory)providerFactories.getProviderFactory(this.binding.getRequestWireFormat().getClass())) != null) {
            this.wfProvider = wfProviderFactory.createServiceWireFormatProvider(endpoint);
        }
        try {
            this.interfaceContract = (InterfaceContract)endpoint.getComponentServiceInterfaceContract().clone();
            if (this.wfProvider != null) {
                this.wfProvider.configureWireFormatInterfaceContract(this.interfaceContract);
            }
        }
        catch (CloneNotSupportedException e) {
            // empty catch block
        }
        this.servletMapping = this.binding.getURI();
        if (!this.servletMapping.endsWith("/")) {
            this.servletMapping = this.servletMapping + "/";
        }
        if (!this.servletMapping.endsWith("*")) {
            this.servletMapping = this.servletMapping + "*";
        }
    }

    public void start() {
        if (this.binding.getOperationSelector() == null || this.binding.getRequestWireFormat() == null || this.binding.getResponseWireFormat() == null) {
            throw new IllegalStateException("Binding operation selector and/or wire formats not properly setup.");
        }
        HTTPBindingServiceServlet servlet = new HTTPBindingServiceServlet(this.endpoint, this.messageFactory);
        this.servletMapping = this.binding.getURI();
        if (!this.servletMapping.endsWith("/")) {
            this.servletMapping = this.servletMapping + "/";
        }
        if (!this.servletMapping.endsWith("*")) {
            this.servletMapping = this.servletMapping + "*";
        }
        String deployedURI = this.servletHost.addServletMapping(this.servletMapping, (Servlet)servlet);
        this.endpoint.setDeployedURI(deployedURI);
    }

    public void stop() {
        this.servletHost.removeServletMapping(this.servletMapping);
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.interfaceContract;
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public void configure() {
        InvocationChain bindingChain = this.endpoint.getBindingInvocationChain();
        if (this.osProvider != null) {
            bindingChain.addInterceptor("service.binding.operationselector", this.osProvider.createInterceptor());
        }
        if (this.wfProvider != null) {
            bindingChain.addInterceptor("service.binding.wireformat", this.wfProvider.createInterceptor());
        }
    }
}

