/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ejb.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.xml.PolicySubjectProcessor;
import org.apache.tuscany.sca.binding.ejb.EJBBinding;
import org.apache.tuscany.sca.binding.ejb.EJBBindingFactory;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.PolicyFactory;

public class EJBBindingProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<EJBBinding> {
    private PolicyFactory policyFactory;
    private PolicySubjectProcessor policyProcessor;
    private EJBBindingFactory ejbBindingFactory;

    public EJBBindingProcessor(FactoryExtensionPoint modelFactories) {
        this.policyFactory = (PolicyFactory)modelFactories.getFactory(PolicyFactory.class);
        this.ejbBindingFactory = (EJBBindingFactory)modelFactories.getFactory(EJBBindingFactory.class);
        this.policyProcessor = new PolicySubjectProcessor(this.policyFactory);
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(((Object)((Object)this)).getClass().getName(), "binding-ejb-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }

    public QName getArtifactType() {
        return EJBBinding.BINDING_EJB_QNAME;
    }

    public EJBBinding read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        String requires;
        String ejbVersion;
        String ejbLinkName;
        String homeInterface;
        String uri;
        EJBBinding ejbBinding = this.ejbBindingFactory.createEJBBinding();
        this.policyProcessor.readPolicies((Object)ejbBinding, reader);
        String name = reader.getAttributeValue(null, "name");
        if (name != null) {
            ejbBinding.setName(name);
        }
        if ((uri = this.getURIString(reader, "uri")) != null) {
            ejbBinding.setURI(uri);
        }
        if ((homeInterface = reader.getAttributeValue(null, "homeInterface")) != null) {
            ejbBinding.setHomeInterface(homeInterface);
        }
        if ((ejbLinkName = reader.getAttributeValue(null, "ejb-link-name")) != null) {
            ejbBinding.setEjbLinkName(ejbLinkName);
        }
        if ((ejbVersion = reader.getAttributeValue(null, "ejb-version")) != null) {
            if (ejbVersion.equals("EJB2")) {
                ejbBinding.setEjbVersion(EJBBinding.EJBVersion.EJB2);
            } else if (ejbVersion.equals("EJB3")) {
                ejbBinding.setEjbVersion(EJBBinding.EJBVersion.EJB3);
            } else {
                this.error(context.getMonitor(), "UnknownEJBVersion", reader, ejbVersion, name);
            }
        }
        if ((requires = reader.getAttributeValue(null, "requires")) != null) {
            ejbBinding.setRequires(requires);
        }
        return ejbBinding;
    }

    public void write(EJBBinding ejbBinding, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "binding.ejb");
        if (ejbBinding.getName() != null) {
            writer.writeAttribute("name", ejbBinding.getName());
        }
        if (ejbBinding.getURI() != null) {
            writer.writeAttribute("uri", ejbBinding.getURI());
        }
        writer.writeEndElement();
    }

    public Class<EJBBinding> getModelType() {
        return EJBBinding.class;
    }

    public void resolve(EJBBinding ejbBinding, ModelResolver modelResolver, ProcessorContext context) throws ContributionResolveException {
    }
}

