/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PolicyXPathFunction
implements XPathFunction {
    private static Logger logger = Logger.getLogger(PolicyXPathFunction.class.getName());
    static final QName InterfaceRef = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "InterfaceRef");
    static final QName OperationRef = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "OperationRef");
    static final QName MessageRef = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "MessageRef");
    static final QName IntentRefs = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "IntentRefs");
    static final QName URIRef = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "URIRef");
    static final Set<QName> functions = new HashSet<QName>(Arrays.asList(InterfaceRef, OperationRef, MessageRef, IntentRefs, URIRef));
    private NamespaceContext namespaceContext;
    private final QName functionName;
    private static Pattern FUNCTION;

    public PolicyXPathFunction(NamespaceContext namespaceContext, QName functionName) {
        this.namespaceContext = namespaceContext;
        this.functionName = functionName;
    }

    private Node getContextNode(List args) {
        NodeList nodeList;
        if (args.size() >= 2 && (nodeList = (NodeList)args.get(1)).getLength() > 0) {
            return nodeList.item(0);
        }
        return null;
    }

    public Object evaluate(List args) throws XPathFunctionException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.functionName + "(" + args + ")");
        }
        String arg = (String)args.get(0);
        Node node = this.getContextNode(args);
        if (node instanceof Document) {
            return this.evaluateDocument(arg, (Document)node);
        }
        return this.evaluateNode(arg, node);
    }

    public Object evaluateNode(String arg, Node node) {
        if (InterfaceRef.equals(this.functionName)) {
            return this.evaluateInterface(arg, node);
        }
        if (OperationRef.equals(this.functionName)) {
            String[] params = arg.split("/");
            if (params.length != 2) {
                throw new IllegalArgumentException("Invalid argument: " + arg);
            }
            String interfaceName = params[0];
            String operationName = params[1];
            return this.evaluateOperation(interfaceName, operationName, node);
        }
        if (MessageRef.equals(this.functionName)) {
            String[] params = arg.split("/");
            if (params.length != 3) {
                throw new IllegalArgumentException("Invalid argument: " + arg);
            }
            String interfaceName = params[0];
            String operationName = params[1];
            String messageName = params[2];
            return this.evaluateMessage(interfaceName, operationName, messageName, node);
        }
        if (URIRef.equals(this.functionName)) {
            return this.evaluateURI(arg, node);
        }
        if (IntentRefs.equals(this.functionName)) {
            String[] intents = arg.split("(\\s)+");
            return this.evaluateIntents(intents, node);
        }
        return Boolean.FALSE;
    }

    private Object evaluateDocument(String arg, Document doc) {
        NodeListImpl retList = new NodeListImpl();
        NodeList elements = doc.getElementsByTagName("*");
        for (int i = 0; i < elements.getLength(); ++i) {
            Object node = this.evaluateNode(arg, elements.item(i));
            if (node == null) continue;
            retList.add((Node)node);
        }
        return retList;
    }

    private Boolean evaluateInterface(String interfaceName, Node node) {
        return Boolean.FALSE;
    }

    private Boolean evaluateOperation(String interfaceName, String operationName, Node node) {
        return Boolean.FALSE;
    }

    private Boolean evaluateMessage(String interfaceName, String operationName, String messageName, Node node) {
        return Boolean.FALSE;
    }

    private Boolean evaluateURI(String uri, Node node) {
        return Boolean.FALSE;
    }

    private Object evaluateIntents(String[] intents, Node node) {
        if (node == null) {
            return false;
        }
        if (node.getAttributes() != null) {
            for (int i = 0; i < node.getAttributes().getLength(); ++i) {
                Node attr = node.getAttributes().item(i);
                if (!"requires".equalsIgnoreCase(attr.getNodeName())) continue;
                for (int j = 0; j < intents.length; ++j) {
                    if (!(intents[j].startsWith("!") ? this.matchIntent(intents[j].substring(1), attr, node.getNamespaceURI()) : !this.matchIntent(intents[j], attr, node.getNamespaceURI()))) continue;
                    return null;
                }
                return node;
            }
        }
        return null;
    }

    private boolean matchIntent(String intent, Node node, String namespaceURI) {
        String[] requires = node.getNodeValue().split("(\\s)+");
        QName intentName = this.getStringAsQName(intent);
        for (int i = 0; i < requires.length; ++i) {
            QName nodeName = null;
            int idx = requires[i].indexOf(58);
            if (idx == -1) {
                nodeName = new QName(namespaceURI, requires[i]);
            } else {
                String prefix = requires[i].substring(0, idx);
                String name = requires[i].substring(idx + 1);
                String ns = node.lookupNamespaceURI(prefix);
                nodeName = new QName(ns, name, prefix);
            }
            if (!intentName.equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    private QName getStringAsQName(String intent) {
        int idx = intent.indexOf(58);
        if (idx == -1) {
            return new QName(this.namespaceContext.getNamespaceURI(""), intent);
        }
        String prefix = intent.substring(0, idx);
        intent = intent.substring(idx + 1);
        return new QName(this.namespaceContext.getNamespaceURI(prefix), intent, prefix);
    }

    public static String normalize(String attachTo, String scaPrefix) {
        Matcher matcher = FUNCTION.matcher(attachTo = attachTo.trim());
        boolean result = matcher.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                String function = matcher.group(1);
                String args = matcher.group(2);
                if (matcher.start() == 0 || attachTo.charAt(matcher.start() - 1) != ':') {
                    function = scaPrefix + ":" + function;
                }
                String replacement = null;
                replacement = args.trim().length() > 0 ? function + "(" + args + "," + "self::node())" : function + "(self::node())";
                matcher.appendReplacement(sb, replacement);
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return attachTo;
    }

    static {
        String functionPattern = "(URIRef|InterfaceRef|OperationRef|MessageRef|IntentRefs)\\s*\\(([^\\)]*)\\)";
        FUNCTION = Pattern.compile(functionPattern);
    }

    private class NodeListImpl
    implements NodeList {
        private ArrayList<Node> list = new ArrayList();

        @Override
        public int getLength() {
            return this.list.size();
        }

        @Override
        public Node item(int index) {
            return this.list.get(index);
        }

        public boolean add(Node node) {
            return this.list.add(node);
        }
    }
}

