/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.definitions.xml;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.definitions.xml.DefinitionsExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.monitor.MonitorFactory;

public class DefaultDefinitionsExtensionPoint
implements DefinitionsExtensionPoint {
    private static final Logger logger = Logger.getLogger(DefaultDefinitionsExtensionPoint.class.getName());
    private static final URI DEFINITIONS_URI = URI.create("META-INF/definitions.xml");
    private ExtensionPointRegistry registry;
    private MonitorFactory monitorFactory;
    private Set<URL> documents = new HashSet<URL>();
    private List<Definitions> definitions = new ArrayList<Definitions>();
    private boolean documentsLoaded;
    private boolean loaded;

    public DefaultDefinitionsExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
        this.monitorFactory = (MonitorFactory)((UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(MonitorFactory.class);
    }

    @Override
    public void addDefinitionsDocument(URL url) {
        this.documents.add(url);
    }

    @Override
    public void removeDefinitionsDocument(URL url) {
        this.documents.remove(url);
    }

    private synchronized void loadDefinitionsDocuments() {
        Collection definitionsDeclarations;
        if (this.documentsLoaded) {
            return;
        }
        try {
            definitionsDeclarations = this.registry.getServiceDiscovery().getServiceDeclarations("org.apache.tuscany.sca.definitions.xml.Definitions", true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        HashSet<String> definitionResources = new HashSet<String>();
        for (ServiceDeclaration definitionsDeclaration : definitionsDeclarations) {
            String resourceName = definitionsDeclaration.getClassName();
            if (definitionResources.contains(resourceName)) continue;
            definitionResources.add(resourceName);
            URL url = definitionsDeclaration.getResource(resourceName);
            if (url == null) {
                throw new IllegalArgumentException(definitionsDeclaration.getClassName() + " cannot be found");
            }
            this.documents.add(url);
        }
        this.documentsLoaded = true;
    }

    @Override
    public synchronized List<Definitions> getDefinitions() {
        if (!this.loaded) {
            this.loadDefinitionsDocuments();
            URLArtifactProcessorExtensionPoint processors = (URLArtifactProcessorExtensionPoint)this.registry.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
            URLArtifactProcessor processor = processors.getProcessor(Definitions.class);
            ProcessorContext context = new ProcessorContext(this.monitorFactory.createMonitor());
            for (URL url : this.documents) {
                try {
                    Definitions def = (Definitions)processor.read(null, DEFINITIONS_URI, url, context);
                    this.definitions.add(def);
                }
                catch (ContributionReadException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            this.loaded = true;
        }
        return this.definitions;
    }

    @Override
    public void addDefinitions(Definitions def) {
        this.definitions.add(def);
    }

    @Override
    public void removeDefinitions(Definitions def) {
        this.definitions.remove(def);
    }
}

