/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.yarn.YarnSparkHadoopUtil;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.launcher.YarnCommandBuilderUtils$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class YarnSparkHadoopUtil$ {
    public static final YarnSparkHadoopUtil$ MODULE$;
    private final double MEMORY_OVERHEAD_FACTOR;
    private final long MEMORY_OVERHEAD_MIN;
    private final String ANY_HOST;
    private final int DEFAULT_NUMBER_EXECUTORS;
    private final Priority RM_REQUEST_PRIORITY;
    private final String environmentVariableRegex;

    static {
        new YarnSparkHadoopUtil$();
    }

    public double MEMORY_OVERHEAD_FACTOR() {
        return this.MEMORY_OVERHEAD_FACTOR;
    }

    public long MEMORY_OVERHEAD_MIN() {
        return this.MEMORY_OVERHEAD_MIN;
    }

    public String ANY_HOST() {
        return this.ANY_HOST;
    }

    public int DEFAULT_NUMBER_EXECUTORS() {
        return this.DEFAULT_NUMBER_EXECUTORS;
    }

    public Priority RM_REQUEST_PRIORITY() {
        return this.RM_REQUEST_PRIORITY;
    }

    public YarnSparkHadoopUtil get() {
        boolean yarnMode = Boolean.parseBoolean(System.getProperty("SPARK_YARN_MODE", System.getenv("SPARK_YARN_MODE")));
        if (yarnMode) {
            return (YarnSparkHadoopUtil)SparkHadoopUtil$.MODULE$.get();
        }
        throw new SparkException("YarnSparkHadoopUtil is not available in non-YARN mode!");
    }

    public void addPathToEnvironment(HashMap<String, String> env, String key, String value) {
        String newValue = env.contains((Object)key) ? new StringBuilder().append((Object)((String)env.apply((Object)key))).append((Object)"<CPS>").append((Object)value).toString() : value;
        env.put((Object)key, (Object)newValue);
    }

    public void setEnvFromInputString(HashMap<String, String> env, String inputString) {
        if (inputString != null && inputString.length() > 0) {
            String[] childEnvs = inputString.split(",");
            Pattern p = Pattern.compile(this.environmentVariableRegex());
            Predef$.MODULE$.refArrayOps((Object[])childEnvs).foreach((Function1)new Serializable(env, p){
                public static final long serialVersionUID = 0L;
                private final HashMap env$1;
                private final Pattern p$1;

                public final void apply(String cEnv) {
                    String[] parts = cEnv.split("=");
                    Matcher m = this.p$1.matcher(parts[1]);
                    StringBuffer sb = new StringBuffer();
                    while (m.find()) {
                        String variable = m.group(1);
                        String replace = "";
                        if (this.env$1.contains((Object)variable)) {
                            replace = (String)this.env$1.apply((Object)variable);
                        } else {
                            replace = System.getenv(variable);
                            if (replace == null) {
                                replace = "";
                            }
                        }
                        m.appendReplacement(sb, Matcher.quoteReplacement(replace));
                    }
                    m.appendTail(sb);
                    YarnSparkHadoopUtil$.MODULE$.addPathToEnvironment((HashMap<String, String>)this.env$1, parts[0], sb.toString());
                }
                {
                    this.env$1 = env$1;
                    this.p$1 = p$1;
                }
            });
        }
    }

    private String environmentVariableRegex() {
        return this.environmentVariableRegex;
    }

    public void addOutOfMemoryErrorArgument(ListBuffer<String> javaOpts) {
        if (!javaOpts.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.contains("-XX:OnOutOfMemoryError");
            }
        })) {
            if (Utils$.MODULE$.isWindows()) {
                javaOpts.$plus$eq((Object)this.escapeForShell("-XX:OnOutOfMemoryError=taskkill /F /PID %%%%p"));
            } else {
                javaOpts.$plus$eq((Object)"-XX:OnOutOfMemoryError='kill %p'");
            }
        }
    }

    public String escapeForShell(String arg) {
        String string;
        if (arg == null) {
            string = arg;
        } else if (Utils$.MODULE$.isWindows()) {
            string = YarnCommandBuilderUtils$.MODULE$.quoteForBatchScript(arg);
        } else {
            StringBuilder escaped = new StringBuilder("'");
            new StringOps(Predef$.MODULE$.augmentString(arg)).foreach((Function1)new Serializable(escaped){
                public static final long serialVersionUID = 0L;
                private final StringBuilder escaped$1;

                public final StringBuilder apply(char x0$1) {
                    StringBuilder stringBuilder;
                    char c = x0$1;
                    switch (c) {
                        default: {
                            stringBuilder = this.escaped$1.append(c);
                            break;
                        }
                        case '\'': {
                            stringBuilder = this.escaped$1.append("'\\''");
                            break;
                        }
                        case '\"': {
                            stringBuilder = this.escaped$1.append("\\\"");
                            break;
                        }
                        case '$': {
                            stringBuilder = this.escaped$1.append("\\$");
                        }
                    }
                    return stringBuilder;
                }
                {
                    this.escaped$1 = escaped$1;
                }
            });
            string = escaped.append("'").toString();
        }
        return string;
    }

    public Map<ApplicationAccessType, String> getApplicationAclsForYarn(SecurityManager securityMgr) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ApplicationAccessType.VIEW_APP), (Object)new StringBuilder().append((Object)securityMgr.getViewAcls()).append((Object)" ").append((Object)securityMgr.getViewAclsGroups()).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)ApplicationAccessType.MODIFY_APP), (Object)new StringBuilder().append((Object)securityMgr.getModifyAcls()).append((Object)" ").append((Object)securityMgr.getModifyAclsGroups()).toString())}));
    }

    public int getInitialTargetExecutorNumber(SparkConf conf, int numExecutors) {
        int n;
        if (Utils$.MODULE$.isDynamicAllocationEnabled(conf)) {
            int minNumExecutors = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.DYN_ALLOCATION_MIN_EXECUTORS()));
            int initialNumExecutors = Utils$.MODULE$.getDynamicAllocationInitialExecutors(conf);
            int maxNumExecutors = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.DYN_ALLOCATION_MAX_EXECUTORS()));
            Predef$.MODULE$.require(initialNumExecutors >= minNumExecutors && initialNumExecutors <= maxNumExecutors, (Function0)new Serializable(minNumExecutors, initialNumExecutors, maxNumExecutors){
                public static final long serialVersionUID = 0L;
                private final int minNumExecutors$1;
                private final int initialNumExecutors$1;
                private final int maxNumExecutors$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"initial executor number ", " must between min executor number "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.initialNumExecutors$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " and max executor number ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.minNumExecutors$1), BoxesRunTime.boxToInteger((int)this.maxNumExecutors$1)}))).toString();
                }
                {
                    this.minNumExecutors$1 = minNumExecutors$1;
                    this.initialNumExecutors$1 = initialNumExecutors$1;
                    this.maxNumExecutors$1 = maxNumExecutors$1;
                }
            });
            n = initialNumExecutors;
        } else {
            n = BoxesRunTime.unboxToInt((Object)((Option)conf.get((ConfigEntry)package$.MODULE$.EXECUTOR_INSTANCES())).getOrElse((Function0)new Serializable(numExecutors){
                public static final long serialVersionUID = 0L;
                private final int numExecutors$1;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return this.numExecutors$1;
                }
                {
                    this.numExecutors$1 = numExecutors$1;
                }
            }));
        }
        return n;
    }

    public int getInitialTargetExecutorNumber$default$2() {
        return this.DEFAULT_NUMBER_EXECUTORS();
    }

    private YarnSparkHadoopUtil$() {
        MODULE$ = this;
        this.MEMORY_OVERHEAD_FACTOR = 0.1;
        this.MEMORY_OVERHEAD_MIN = 384L;
        this.ANY_HOST = "*";
        this.DEFAULT_NUMBER_EXECUTORS = 2;
        this.RM_REQUEST_PRIORITY = Priority.newInstance((int)1);
        this.environmentVariableRegex = Utils$.MODULE$.isWindows() ? "%([A-Za-z_][A-Za-z0-9_]*?)%" : "\\$([A-Za-z_][A-Za-z0-9_]*)";
    }
}

