/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.BufferedOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.maven.surefire.report.AbstractTextReporter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;

public abstract class AbstractConsoleReporter
extends AbstractTextReporter {
    protected static final int BUFFER_SIZE = 4096;

    protected AbstractConsoleReporter(String format, Boolean trimStackTrace) {
        super(new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(System.out, 4096))), format, trimStackTrace);
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        super.testSetStarting(report);
        String message = "Running " + report.getName();
        if (report.getGroup() != null && !report.getName().equals(report.getGroup())) {
            message = message + " (of " + report.getGroup() + ")";
        }
        this.writeMessage(message);
    }

    public void runStarting(int testCount) {
        this.writeHeading("");
        this.writeHeading("-------------------------------------------------------");
        this.writeHeading(" T E S T S");
        this.writeHeading("-------------------------------------------------------");
    }

    public void writeHeading(String message) {
        this.writer.println(message);
        this.writer.flush();
    }

    public void runAborted(ReportEntry report) {
        this.printAbortionError("RUN ABORTED", report);
    }

    public void testSetAborted(ReportEntry report) {
        this.printAbortionError("TEST SET ABORTED", report);
    }

    private void printAbortionError(String msg, ReportEntry report) {
        this.writer.println(msg);
        this.writer.println(report.getSource().getClass().getName());
        this.writer.println(report.getName());
        this.writer.println(report.getMessage());
        this.writer.println(this.getStackTrace(report));
        this.writer.flush();
    }
}

