/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractReleasePomsPhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.util.ReleaseUtil;

public class RemoveReleasePomsPhase
extends AbstractReleasePomsPhase {
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseFailureException, ReleaseExecutionException {
        return this.execute(releaseDescriptor, settings, reactorProjects, false);
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseFailureException, ReleaseExecutionException {
        return this.execute(releaseDescriptor, settings, reactorProjects, true);
    }

    private ReleaseResult execute(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, boolean simulate) throws ReleaseFailureException, ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        if (releaseDescriptor.isGenerateReleasePoms()) {
            this.logInfo(result, "Removing release POMs...");
            this.removeReleasePoms(releaseDescriptor, settings, simulate, result, reactorProjects);
        } else {
            this.logInfo(result, "Not removing release POMs");
        }
        result.setResultCode(0);
        return result;
    }

    private void removeReleasePoms(ReleaseDescriptor releaseDescriptor, Settings settings, boolean simulate, ReleaseResult result, List projects) throws ReleaseFailureException, ReleaseExecutionException {
        ArrayList<File> releasePoms = new ArrayList<File>();
        Iterator iterator = projects.iterator();
        while (iterator.hasNext()) {
            MavenProject project = (MavenProject)iterator.next();
            this.logInfo(result, "Removing release POM for '" + project.getName() + "'...");
            releasePoms.add(ReleaseUtil.getReleasePom(project));
        }
        this.removeReleasePomsFromScm(releaseDescriptor, settings, simulate, result, releasePoms);
    }

    private void removeReleasePomsFromScm(ReleaseDescriptor releaseDescriptor, Settings settings, boolean simulate, ReleaseResult result, List releasePoms) throws ReleaseFailureException, ReleaseExecutionException {
        if (simulate) {
            this.logInfo(result, "Full run would be removing " + releasePoms);
        } else {
            ScmRepository scmRepository = this.getScmRepository(releaseDescriptor, settings);
            ScmProvider scmProvider = this.getScmProvider(scmRepository);
            ScmFileSet scmFileSet = new ScmFileSet(new File(releaseDescriptor.getWorkingDirectory()), releasePoms);
            try {
                RemoveScmResult scmResult = scmProvider.remove(scmRepository, scmFileSet, "Removing for next development iteration.");
                if (!scmResult.isSuccess()) {
                    throw new ReleaseScmCommandException("Cannot remove release POMs from SCM", (ScmResult)scmResult);
                }
            }
            catch (ScmException exception) {
                throw new ReleaseExecutionException("Cannot remove release POMs from SCM: " + exception.getMessage(), exception);
            }
        }
    }
}

