/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.assembly.archive.ArchiveExpansionException;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.IOUtil;

public final class AssemblyFileUtils {
    public static final String LINE_ENDING_KEEP = "keep";
    public static final String LINE_ENDING_DOS = "dos";
    public static final String LINE_ENDING_WINDOWS = "windows";
    public static final String LINE_ENDING_UNIX = "unix";
    public static final String LINE_ENDING_CRLF = "crlf";
    public static final String LINE_ENDING_LF = "lf";

    private AssemblyFileUtils() {
    }

    public static String makePathRelativeTo(String path, File basedir) {
        String base;
        if (basedir == null) {
            return path;
        }
        if (path == null) {
            return null;
        }
        if ((path = path.trim()).startsWith(base = basedir.getAbsolutePath())) {
            if ((path = path.substring(base.length())).length() > 0 && (path.startsWith("/") || path.startsWith("\\"))) {
                path = path.substring(1);
            }
            if (path.length() == 0) {
                path = ".";
            }
        }
        if (!new File(path).isAbsolute()) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static void verifyTempDirectoryAvailability(@Nonnull File tempDir) {
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
    }

    public static void unpack(File source, File destDir, ArchiverManager archiverManager) throws ArchiveExpansionException, NoSuchArchiverException {
        try {
            UnArchiver unArchiver = archiverManager.getUnArchiver(source);
            unArchiver.setSourceFile(source);
            unArchiver.setDestDirectory(destDir);
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new ArchiveExpansionException("Error unpacking file: " + source + "to: " + destDir, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void convertLineEndings(@Nonnull File source, @Nonnull File dest, String lineEndings, Boolean atEndOfFile, String encoding) throws IOException {
        eofChars = "";
        if (atEndOfFile == null) {
            raf = null;
            try {
                if (source.length() < 1L) ** GOTO lbl21
                raf = new RandomAccessFile(source, "r");
                raf.seek(source.length() - 1L);
                last = raf.readByte();
                if (last != 10) ** GOTO lbl21
                eofChars = lineEndings;
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException ex) {}
                }
            }
        } else if (atEndOfFile.booleanValue()) {
            eofChars = lineEndings;
        }
lbl21:
        // 6 sources

        in = null;
        out = null;
        try {
            if (encoding == null) {
                in = new BufferedReader(new InputStreamReader(new FileInputStream(source)));
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(dest)));
            } else {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), encoding));
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dest), encoding));
            }
            line = in.readLine();
            while (line != null) {
                out.write(line);
                line = in.readLine();
                if (line != null) {
                    out.write(lineEndings);
                    continue;
                }
                out.write(eofChars);
            }
            out.flush();
        }
        catch (Throwable var10_13) {
            IOUtil.close(in);
            IOUtil.close(out);
            throw var10_13;
        }
        IOUtil.close((Reader)in);
        IOUtil.close((Writer)out);
    }

    @Nullable
    public static String getLineEndingCharacters(@Nullable String lineEnding) throws AssemblyFormattingException {
        String value = lineEnding;
        if (lineEnding != null) {
            if (LINE_ENDING_KEEP.equals(lineEnding)) {
                value = null;
            } else if (LINE_ENDING_DOS.equals(lineEnding) || LINE_ENDING_WINDOWS.equals(lineEnding) || LINE_ENDING_CRLF.equals(lineEnding)) {
                value = "\r\n";
            } else if (LINE_ENDING_UNIX.equals(lineEnding) || LINE_ENDING_LF.equals(lineEnding)) {
                value = "\n";
            } else {
                throw new AssemblyFormattingException("Illegal lineEnding specified: '" + lineEnding + "'");
            }
        }
        return value;
    }

    public static void copyFile(File src, File dst) throws IOException {
        FileChannel c1 = new RandomAccessFile(src, "r").getChannel();
        FileChannel c2 = new RandomAccessFile(dst, "rw").getChannel();
        long tCount = 0L;
        long size = c1.size();
        while ((tCount += c2.transferFrom(c1, 0L, size - tCount)) < size) {
        }
        c1.close();
        c2.force(true);
        c2.close();
    }

    @Nonnull
    public static String normalizePath(@Nonnull String path) {
        return path.replace('\\', '/');
    }
}

