/*
 * $Id$
 */

package org.apache.maven.model;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class ReportPlugin implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field groupId
     */
    private String groupId = "org.apache.maven.plugins";

    /**
     * Field artifactId
     */
    private String artifactId;

    /**
     * Field version
     */
    private String version;

    /**
     * Field inherited
     */
    private String inherited;

    /**
     * Field configuration
     */
    private Object configuration;

    /**
     * Field reportSets
     */
    private java.util.List reportSets;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addReportSet
     * 
     * @param reportSet
     */
    public void addReportSet(ReportSet reportSet)
    {
        getReportSets().add( reportSet );
    } //-- void addReportSet(ReportSet) 

    /**
     * Get The artifact ID of the reporting plugin in the repository
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get The configuration of the reporting plugin.
     */
    public Object getConfiguration()
    {
        return this.configuration;
    } //-- Object getConfiguration() 

    /**
     * Get The group ID of the reporting plugin in the repository.
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Get Whether the configuration in this plugin should be made
     * available to projects that
     *             inherit from this one.
     */
    public String getInherited()
    {
        return this.inherited;
    } //-- String getInherited() 

    /**
     * Method getReportSets
     */
    public java.util.List getReportSets()
    {
        if ( this.reportSets == null )
        {
            this.reportSets = new java.util.ArrayList();
        }
        
        return this.reportSets;
    } //-- java.util.List getReportSets() 

    /**
     * Get The version of the reporting plugin to be used.
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Method removeReportSet
     * 
     * @param reportSet
     */
    public void removeReportSet(ReportSet reportSet)
    {
        getReportSets().remove( reportSet );
    } //-- void removeReportSet(ReportSet) 

    /**
     * Set The artifact ID of the reporting plugin in the
     * repository.
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set The configuration of the reporting plugin.
     * 
     * @param configuration
     */
    public void setConfiguration(Object configuration)
    {
        this.configuration = configuration;
    } //-- void setConfiguration(Object) 

    /**
     * Set The group ID of the reporting plugin in the repository.
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set Whether the configuration in this plugin should be made
     * available to projects that
     *             inherit from this one.
     * 
     * @param inherited
     */
    public void setInherited(String inherited)
    {
        this.inherited = inherited;
    } //-- void setInherited(String) 

    /**
     * Set Multiple specifications of a set of reports, each having
     * (possibly) different
     *             configuration. This is the reporting parallel to
     * an <code>execution</code> in the build.
     * 
     * @param reportSets
     */
    public void setReportSets(java.util.List reportSets)
    {
        this.reportSets = reportSets;
    } //-- void setReportSets(java.util.List) 

    /**
     * Set The version of the reporting plugin to be used.
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 


    private java.util.Map reportSetMap = null;
    
    public void flushReportSetMap()
    {
        this.reportSetMap = null;
    }

    public java.util.Map getReportSetsAsMap()
    {
        if ( reportSetMap == null )
        {
            reportSetMap = new java.util.HashMap();
            if ( getReportSets() != null )
            {
                for ( java.util.Iterator i = getReportSets().iterator(); i.hasNext(); )
                {
                    ReportSet reportSet = (ReportSet) i.next();
                    reportSetMap.put( reportSet.getId(), reportSet );
                }
            }
        }
        
        return reportSetMap;
    }
    
    public String getKey()
    {
        return constructKey( groupId, artifactId );
    }

    public static String constructKey( String groupId, String artifactId )
    {
        return groupId + ":" + artifactId;
    }
    
    private boolean inheritanceApplied = true;
    
    public void unsetInheritanceApplied()
    {
        this.inheritanceApplied = false;
    }
    
    public boolean isInheritanceApplied()
    {
        return inheritanceApplied;
    }
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
