/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.user.webservices;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.marmotta.commons.sesame.repository.ResourceUtils;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.core.api.triplestore.SesameService;
import org.apache.marmotta.platform.core.api.user.UserService;
import org.apache.marmotta.platform.core.exception.security.AccessDeniedException;
import org.apache.marmotta.platform.user.api.AccountService;
import org.apache.marmotta.platform.user.model.UserAccount;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

@Path(value="/user")
public class UserWebService {
    private static final Pattern PROFILE_URI_PATTERN = Pattern.compile("^<([^>]+)>$");
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private UserService userService;
    @Inject
    private AccountService accountService;
    @Inject
    private SesameService sesameService;
    private List<String> acceptedFoafProperties;

    @PostConstruct
    public void initialize() {
        this.acceptedFoafProperties = this.configurationService.getListConfiguration("user.account.foaf.properties", Arrays.asList("firstName", "nick", "lastName", "familyName", "givenName", "name", "title", "age", "mbox", "homepage"));
    }

    @GET
    @Path(value="/me")
    @Produces(value={"application/json"})
    public Response get() {
        return this.get(this.userService.getCurrentUser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response get(org.openrdf.model.URI user) {
        if (this.userService.isAnonymous(user)) {
            AccountPoJo apj = new AccountPoJo("anonymous", user.stringValue());
            return Response.ok((Object)apj, (String)"application/json").location(URI.create(user.stringValue())).build();
        }
        try {
            UserAccount a;
            RepositoryConnection conn;
            block11: {
                conn = this.sesameService.getConnection();
                a = this.accountService.getAccount(user);
                if (a == null) {
                    Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find account data of " + user)).build();
                    return response;
                }
                break block11;
                finally {
                    conn.commit();
                    conn.close();
                }
            }
            AccountPoJo apj = new AccountPoJo(a.getLogin(), a.getWebId());
            apj.setRoles(a.getRoles());
            Iterator i$ = ResourceUtils.listOutgoing((RepositoryConnection)conn, (Resource)conn.getValueFactory().createURI(a.getWebId())).iterator();
            while (true) {
                if (!i$.hasNext()) {
                    Response response = Response.ok((Object)apj, (String)"application/json").location(URI.create(user.stringValue())).build();
                    return response;
                }
                Statement t = (Statement)i$.next();
                String prop = t.getPredicate().stringValue();
                if (!prop.startsWith("http://xmlns.com/foaf/0.1/")) continue;
                Value object = t.getObject();
                if (object instanceof org.openrdf.model.URI) {
                    apj.setFoaf(prop, String.format("<%s>", object));
                    continue;
                }
                if (!(object instanceof Literal)) continue;
                apj.setFoaf(prop, object.toString());
            }
        }
        catch (RepositoryException e) {
            return Response.serverError().entity((Object)e).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/me")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response post(MultivaluedMap<String, String> formParams) {
        Response response;
        org.openrdf.model.URI currentUser = this.userService.getCurrentUser();
        if (this.userService.isAnonymous(currentUser)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"anonymous is read-only").build();
        }
        RepositoryConnection conn = this.sesameService.getConnection();
        try {
            for (String prop : formParams.keySet()) {
                Literal o;
                if (!this.acceptedFoafProperties.contains(prop)) continue;
                org.openrdf.model.URI p = conn.getValueFactory().createURI("http://xmlns.com/foaf/0.1/" + prop);
                conn.remove((Resource)currentUser, p, null, new Resource[0]);
                String val = (String)formParams.getFirst((Object)prop);
                if (val == null || val.length() <= 0) continue;
                Matcher m = PROFILE_URI_PATTERN.matcher(val);
                if (m.matches()) {
                    o = conn.getValueFactory().createURI(m.group(1));
                    conn.add((Resource)currentUser, p, (Value)o, new Resource[]{currentUser});
                    continue;
                }
                o = conn.getValueFactory().createLiteral(val.trim());
                conn.add((Resource)currentUser, p, (Value)o, new Resource[]{currentUser});
            }
            response = this.get(currentUser);
        }
        catch (Throwable throwable) {
            try {
                conn.commit();
                conn.close();
                throw throwable;
            }
            catch (RepositoryException e) {
                return Response.serverError().entity((Object)e).build();
            }
        }
        conn.commit();
        conn.close();
        return response;
    }

    @POST
    @Path(value="/me")
    public Response post() {
        return this.get();
    }

    @POST
    @Path(value="/me/passwd")
    public Response passwd(@FormParam(value="oldPasswd") String oldPwd, @FormParam(value="newPasswd") String newPwd) {
        org.openrdf.model.URI currentUser = this.userService.getCurrentUser();
        UserAccount a = this.accountService.getAccount(currentUser);
        if (a == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("No account found for <%s>", currentUser)).build();
        }
        if (this.accountService.checkPassword(a, oldPwd)) {
            this.accountService.setPassword(a, newPwd);
            return Response.ok((Object)"Password changed").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"password check failed").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/{login:[^#?]+}")
    public Response getUser(@PathParam(value="login") String login, @HeaderParam(value="Accept") String types) {
        try {
            RepositoryConnection conn = this.sesameService.getConnection();
            try {
                org.openrdf.model.URI user = this.userService.getUser(login);
                if (user == null) {
                    Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("User %s not found", login)).build();
                    return response;
                }
                URI u = new URI(this.configurationService.getServerUri() + "resource?uri=" + URLEncoder.encode(user.stringValue(), "utf-8"));
                Response response = Response.seeOther((URI)u).header("Accept", (Object)types).build();
                return response;
            }
            finally {
                conn.commit();
                conn.commit();
            }
        }
        catch (URISyntaxException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Invalid URI: %s", e.getMessage())).build();
        }
        catch (UnsupportedEncodingException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
        catch (RepositoryException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/login")
    public Response login(@HeaderParam(value="Referer") String ref, @QueryParam(value="logout") @DefaultValue(value="false") boolean logout, @QueryParam(value="user") String login) {
        if (logout) {
            this.userService.setCurrentUser(this.userService.getAnonymousUser());
            throw new AccessDeniedException();
        }
        if (this.userService.isAnonymous(this.userService.getCurrentUser())) {
            throw new AccessDeniedException();
        }
        if (login != null && !this.userService.getCurrentUser().equals(this.userService.getUser(login))) {
            throw new AccessDeniedException();
        }
        if (ref == null || "".equals(ref)) {
            ref = this.configurationService.getServerUri() + this.configurationService.getStringConfiguration("kiwi.pages.startup");
        }
        return Response.seeOther((URI)URI.create(ref)).build();
    }

    static class AccountPoJo {
        private String login;
        private String uri;
        private String[] roles;
        private Map<String, String> foaf;

        public AccountPoJo(String login, String uri) {
            this.login = login;
            this.uri = uri != null ? uri : null;
            this.roles = new String[0];
            this.foaf = new HashMap<String, String>();
        }

        public void setRoles(Set<String> roles) {
            this.roles = roles != null ? roles.toArray(new String[roles.size()]) : new String[0];
        }

        public void setFoaf(String prop, String value) {
            this.foaf.put(prop, value);
        }

        public void setFoaf(Map<String, String> foaf) {
            this.foaf = foaf;
        }

        public String getLogin() {
            return this.login;
        }

        public String getUri() {
            return this.uri;
        }

        public String[] getRoles() {
            return this.roles;
        }

        public Map<String, String> getFoaf() {
            return this.foaf;
        }
    }
}

