/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.user.webservices;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.marmotta.commons.sesame.repository.ResourceUtils;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.core.api.triplestore.SesameService;
import org.apache.marmotta.platform.user.api.AccountService;
import org.apache.marmotta.platform.user.model.UserAccount;
import org.apache.marmotta.platform.user.webservices.UserWebService;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.slf4j.Logger;

@Path(value="/users")
public class UserManagementWebService {
    private static final Pattern PROFILE_URI_PATTERN = Pattern.compile("^<([^>]+)>$");
    @Inject
    private Logger log;
    @Inject
    private AccountService accountService;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private SesameService sesameService;
    private List<String> acceptedFoafProperties;
    private static final List<String> RESERVED_LOGINS = Arrays.asList("me", "login", "anonymous");

    @PostConstruct
    public void initialize() {
        this.acceptedFoafProperties = this.configurationService.getListConfiguration("user.account.foaf.properties", Arrays.asList("firstName", "nick", "lastName", "familyName", "givenName", "name", "title", "age", "mbox", "homepage"));
    }

    @GET
    @Produces(value={"application/json"})
    public Response listUsers(@QueryParam(value="role") String role) {
        List<UserAccount> accounts = role == null ? this.accountService.listAccounts() : this.accountService.listAccounts(role);
        ArrayList<UserWebService.AccountPoJo> resp = new ArrayList<UserWebService.AccountPoJo>();
        for (UserAccount userAccount : accounts) {
            UserWebService.AccountPoJo apj = new UserWebService.AccountPoJo(userAccount.getLogin(), userAccount.getWebId());
            apj.setRoles(userAccount.getRoles());
            resp.add(apj);
        }
        return Response.ok(resp, (String)"application/json").build();
    }

    @POST
    @Path(value="/{login}")
    public Response createUser(@PathParam(value="login") String login) {
        if (this.accountService.getAccount(login) != null) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)String.format("'%s' already exists!", login)).build();
        }
        if (StringUtils.isBlank((String)login)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Provide a username").build();
        }
        if (RESERVED_LOGINS.contains(login)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("The following usernames are not allowed: %s", RESERVED_LOGINS)).build();
        }
        UserAccount a = this.accountService.createAccount(login);
        if (a != null) {
            return this.getUser(login);
        }
        this.log.error("Creating an account for {} failed", (Object)login);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Sorry, don't know why").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{login}")
    @Produces(value={"application/json"})
    public Response getUser(@PathParam(value="login") String login) {
        Response response;
        UserAccount account = this.accountService.getAccount(login);
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("No login for '%s' found!", login)).build();
        }
        RepositoryConnection conn = this.sesameService.getConnection();
        try {
            UserWebService.AccountPoJo apj = new UserWebService.AccountPoJo(account.getLogin(), account.getWebId());
            apj.setRoles(account.getRoles());
            RepositoryResult triples = conn.getStatements((Resource)conn.getValueFactory().createURI(account.getWebId()), null, null, true, new Resource[0]);
            while (triples.hasNext()) {
                Statement t = (Statement)triples.next();
                String prop = t.getPredicate().stringValue();
                if (!prop.startsWith("http://xmlns.com/foaf/0.1/")) continue;
                Value object = t.getObject();
                if (object instanceof URI) {
                    apj.setFoaf(prop, String.format("<%s>", object));
                    continue;
                }
                if (!(object instanceof Literal)) continue;
                apj.setFoaf(prop, object.toString());
            }
            response = Response.ok((Object)apj, (String)"application/json").build();
        }
        catch (Throwable throwable) {
            try {
                conn.commit();
                conn.close();
                throw throwable;
            }
            catch (RepositoryException ex) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build();
            }
        }
        conn.commit();
        conn.close();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{login}")
    public Response deleteUser(@PathParam(value="login") String login, @QueryParam(value="deleteFoaf") @DefaultValue(value="false") boolean delFoaf) {
        Response response;
        UserAccount account = this.accountService.getAccount(login);
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("No login for '%s' found!", login)).build();
        }
        RepositoryConnection conn = this.sesameService.getConnection();
        try {
            if (delFoaf && account.getWebId() != null) {
                conn.remove((Resource)conn.getValueFactory().createURI(account.getWebId()), null, null, new Resource[0]);
            }
            this.accountService.deleteAccount(account);
            response = Response.status((Response.Status)Response.Status.OK).entity((Object)String.format("login removed", new Object[0])).build();
        }
        catch (Throwable throwable) {
            try {
                conn.commit();
                conn.close();
                throw throwable;
            }
            catch (RepositoryException ex) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build();
            }
        }
        conn.commit();
        conn.close();
        return response;
    }

    @POST
    @Path(value="/{login}/roles")
    public Response setUserRoles(@PathParam(value="login") String login, @QueryParam(value="role") String[] roles, @QueryParam(value="role[]") String[] roles2) {
        UserAccount account = this.accountService.getAccount(login);
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("No login for '%s' found!", login)).build();
        }
        HashSet<String> roleSet = new HashSet<String>();
        for (String role : roles) {
            roleSet.add(role);
        }
        for (String role : roles2) {
            roleSet.add(role);
        }
        this.accountService.setRoles(account, roleSet);
        return this.getUser(login);
    }

    @POST
    @Path(value="/{login}/password")
    public Response setUserPassword(@PathParam(value="login") String login, @FormParam(value="password") String passwd) {
        UserAccount account = this.accountService.getAccount(login);
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("No login for '%s' found!", login)).build();
        }
        this.accountService.setPassword(account, passwd);
        return Response.ok((Object)"Password updated").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{login}/profile")
    public Response setUserProfile(@PathParam(value="login") String login, MultivaluedMap<String, String> formParams) {
        UserAccount account = this.accountService.getAccount(login);
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("No login for '%s' found!", login)).build();
        }
        try {
            RepositoryConnection conn = this.sesameService.getConnection();
            try {
                String currentUser = account.getWebId();
                for (String prop : formParams.keySet()) {
                    Literal o;
                    if (!this.acceptedFoafProperties.contains(prop)) continue;
                    String property = "http://xmlns.com/foaf/0.1/" + prop;
                    URI p = conn.getValueFactory().createURI(property);
                    URI u = conn.getValueFactory().createURI(currentUser);
                    ResourceUtils.removeProperty((RepositoryConnection)conn, (Resource)u, (String)property);
                    String val = (String)formParams.getFirst((Object)prop);
                    if (val == null || val.length() <= 0) continue;
                    Matcher m = PROFILE_URI_PATTERN.matcher(val);
                    if (m.matches()) {
                        o = conn.getValueFactory().createURI(m.group(1));
                        conn.add((Resource)u, p, (Value)o, new Resource[]{u});
                        continue;
                    }
                    o = conn.getValueFactory().createLiteral(val.trim());
                    conn.add((Resource)u, p, (Value)o, new Resource[]{u});
                }
            }
            finally {
                conn.commit();
                conn.close();
            }
        }
        catch (RepositoryException e) {
            return Response.serverError().entity((Object)e).build();
        }
        return this.getUser(login);
    }
}

