/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.user.services.auth;

import java.util.Hashtable;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.user.api.AuthenticationProvider;
import org.apache.marmotta.platform.user.model.UserAccount;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="ldap")
public class LdapAuthProvider
implements AuthenticationProvider {
    static final String QUALIFIER = "ldap";
    static final String CONF_SERVER = "user.auth.ldap.server";
    static final String CONF_PORT = "user.auth.ldap.port";
    static final String CONF_DN = "user.auth.ldap.dn";
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private Logger log;

    @Override
    public boolean checkPassword(UserAccount login, String passwd) {
        return login != null && this.login(login.getLogin(), passwd);
    }

    @Override
    public boolean updatePassword(UserAccount login, String newPasswd) {
        if (login == null) {
            return false;
        }
        String username = login.getLogin();
        this.log.trace("changePassword called for account: {}", (Object)username);
        ModificationItem[] mod = new ModificationItem[1];
        BasicAttribute attr = new BasicAttribute("userpassword", newPasswd);
        mod[0] = new ModificationItem(2, attr);
        String dn = this.configurationService.getStringConfiguration(CONF_DN, "{login}").replaceAll(Pattern.quote("{login}"), username);
        this.log.warn("LDAP-Passwd update not implemented");
        return false;
    }

    private boolean login(String login, String secret) {
        try {
            boolean result;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", String.format("ldap://%s:%d", this.configurationService.getStringConfiguration(CONF_SERVER, this.configurationService.getServerName()), this.configurationService.getIntConfiguration(CONF_PORT, 389)));
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", this.configurationService.getStringConfiguration(CONF_DN, "{login}").replaceAll(Pattern.quote("{login}"), login));
            env.put("java.naming.security.credentials", secret);
            InitialDirContext ctx = new InitialDirContext(env);
            boolean bl = result = ctx != null;
            if (ctx != null) {
                ctx.close();
            }
            this.log.trace("LDAP-Login successful for {}", (Object)login);
            return result;
        }
        catch (Exception e) {
            this.log.info("LDAP-Login for {} failed: {}", (Object)login, (Object)e.getMessage());
            return false;
        }
    }
}

