/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.user.services;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.user.api.UserConfigurationService;
import org.apache.marmotta.platform.user.model.UserAccount;
import org.slf4j.Logger;

@ApplicationScoped
public class UserConfigurationServiceImpl
implements UserConfigurationService {
    @Inject
    private Logger log;
    @Inject
    private ConfigurationService configurationService;
    private HashMap<String, Configuration> userConfigurations;

    @PostConstruct
    public void initialise() {
        this.userConfigurations = new HashMap();
    }

    @Override
    public boolean isUserConfigurationSet(UserAccount user, String key) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)key);
        return this.getUserConfiguration(user).containsKey(key);
    }

    @Override
    public String getUserConfiguration(UserAccount user, String key, String defaultValue) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)key);
        return this.getUserConfiguration(user).getString(key, defaultValue);
    }

    @Override
    public String getUserConfiguration(UserAccount user, String key) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)key);
        return this.getUserConfiguration(user).getString(key);
    }

    @Override
    public List<Object> getUserListConfiguration(UserAccount user, String key) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)key);
        return this.getUserListConfiguration(user, key, Collections.<Object>emptyList());
    }

    @Override
    public List<Object> getUserListConfiguration(UserAccount user, String key, List<Object> defaultValue) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)key);
        return this.getUserConfiguration(user).getList(key, defaultValue);
    }

    @Override
    public void removeUserConfiguration(UserAccount user, String key) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)key);
        this.getUserConfiguration(user).clearProperty(key);
    }

    @Override
    public void setUserListConfiguration(UserAccount user, String key, List<String> values) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)key);
        this.getUserConfiguration(user).setProperty(key, values);
    }

    @Override
    public void setUserConfiguration(UserAccount user, String key, String value) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)key);
        this.getUserConfiguration(user).setProperty(key, (Object)value);
    }

    public Configuration getUserConfiguration(UserAccount user) {
        Configuration userConfig = this.userConfigurations.get(user.getLogin());
        if (userConfig == null) {
            String userConfigFile = this.configurationService.getConfiguration("kiwi.work.dir") + File.separator + "config" + File.separator + user.getLogin() + ".conf";
            try {
                File f = new File(userConfigFile);
                if (f.exists()) {
                    f.createNewFile();
                }
                userConfig = new PropertiesConfiguration(f);
            }
            catch (Exception ex) {
                this.log.error("could not create user configuration in file #0: #1", (Object)userConfigFile, (Object)ex.getMessage());
                userConfig = new MapConfiguration(new HashMap());
            }
            this.userConfigurations.put(user.getLogin(), userConfig);
        }
        return userConfig;
    }

    public void save(UserAccount user) {
        Configuration userConfig = this.getUserConfiguration(user);
        if (userConfig instanceof PropertiesConfiguration) {
            try {
                ((PropertiesConfiguration)userConfig).save();
            }
            catch (ConfigurationException e) {
                this.log.error("could not save user configuration for user #0: #1", (Object)user.getLogin(), (Object)e.getMessage());
            }
        }
    }
}

